/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import nanorep.nanowidget.R;

public class NRLinkedArticlesBrowserView
extends RelativeLayout {
    private ImageButton mNextButton;
    private ImageButton mPrevButton;
    private State mState = State.single;
    private Listener mListener;

    public NRLinkedArticlesBrowserView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.linked_articles_browser_view, (ViewGroup)this);
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public void setState(State state) {
        if (this.mState != state) {
            this.mPrevButton.setEnabled(false);
            this.mNextButton.setEnabled(false);
            String nextImageName = "disabled_right_arrow";
            String prevImageName = "disabled_left_arrow";
            this.mState = state;
            switch (state) {
                case hasNext: {
                    nextImageName = "right_arrow";
                    this.mNextButton.setEnabled(true);
                    break;
                }
                case hasPrev: {
                    prevImageName = "left_arrow";
                    this.mPrevButton.setEnabled(true);
                    break;
                }
                case hasNextAndPrev: {
                    this.mPrevButton.setEnabled(true);
                    this.mNextButton.setEnabled(true);
                    nextImageName = "right_arrow";
                    prevImageName = "left_arrow";
                }
            }
            this.mNextButton.setImageResource(this.resId(nextImageName));
            this.mPrevButton.setImageResource(this.resId(prevImageName));
        }
    }

    private int resId(String resName) {
        return this.getResources().getIdentifier(resName, "drawable", this.getContext().getPackageName());
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.mNextButton = (ImageButton)child.findViewById(R.id.rightArrow);
        this.mPrevButton = (ImageButton)child.findViewById(R.id.leftArrow);
        this.mNextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                NRLinkedArticlesBrowserView.this.mListener.onNextClicked();
            }
        });
        this.mPrevButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                NRLinkedArticlesBrowserView.this.mListener.onPrevClicked();
            }
        });
    }

    public static interface Listener {
        public void onNextClicked();

        public void onPrevClicked();
    }

    public static enum State {
        single,
        hasNext,
        hasPrev,
        hasNextAndPrev;

    }
}

