package nanorep.nanowidget.Components;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

import com.nanorep.nanoclient.RequestParams.NRLikeType;

import nanorep.nanowidget.Components.AbstractViews.ViewIdsFactory;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.DislikeConfiguration;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.NRCustomDislikeDialog;
import nanorep.nanowidget.R;

import static android.view.Gravity.NO_GRAVITY;
import static com.nanorep.nanoclient.Response.NRConfiguration.MULTIPLE_CHOICE;
import static com.nanorep.nanoclient.Response.NRConfiguration.MULTIPLE_CHOICE_OPEN_TEXT;
import static com.nanorep.nanoclient.Response.NRConfiguration.OPEN_TEXT;

/**
 * Created by obenoved on 12/03/2018.
 */

public class NRDislikeDialog extends NRCustomDislikeDialog implements View.OnClickListener {

    private boolean isDismissHandled;
    private String feedbackText;

    private NRLikeType mSelection = NRLikeType.MISSING_INFORMATION;

    public static NRDislikeDialog newInstance(DislikeConfiguration dislikeConfiguration, ViewIdsFactory viewIdsFactory) {
        NRDislikeDialog fragment = new NRDislikeDialog();
        fragment.setConfiguration(dislikeConfiguration);
        fragment.setDislikeViewId(viewIdsFactory.getLayoutId());
        fragment.setDislikeViewsProducer(viewIdsFactory.getIDProducer());
        return fragment;
    }

    @Override
    public void onStart() {
        super.onStart();

        final Dialog dialog = getDialog();
        final Window window = dialog.getWindow();

        if (window != null) {
            window.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);
            window.setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            if (dialogGravity != NO_GRAVITY) {
                window.setGravity(dialogGravity);
            }
        }
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {

        View view;

        try {
            view = inflater.inflate(dislikeViewId, container, false);
        } catch (NullPointerException | InflateException e) {
            view = inflater.inflate(R.layout.dislike_dialog_mixed, container, false);
        }

        return view;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        TextView dialogTitle = view.findViewById(idProducer.getTitleId());
        feedbackEditText = view.findViewById(idProducer.getFeedbackEditTextId());
        RadioGroup feedbackChoicesRadio = view.findViewById(idProducer.getRadioId());
        cancelButton = view.findViewById(idProducer.getCancelButtonId());
        okButton = view.findViewById(idProducer.getSubmitButtonId());

        okButton.setText(dislikeConfiguration.getSubmitButtonText());
        dialogTitle.setText(dislikeConfiguration.getTitle());

        if (feedbackDialogType != OPEN_TEXT && dislikeConfiguration.getDialogOptions() != null && dislikeConfiguration.getDialogOptions().size() > 1) {

            RadioButton firstRadioOption = view.findViewById(idProducer.getFirstRadioButtonId());
            firstRadioOption.setText(dislikeConfiguration.getFirstOptionText());

            RadioButton secondRadioOption = view.findViewById(idProducer.getSecondRadioButtonId());
            secondRadioOption.setText(dislikeConfiguration.getSecondOptionText());

            if (feedbackDialogType == MULTIPLE_CHOICE) {
                feedbackEditText.setVisibility(View.GONE);
            }

            feedbackChoicesRadio.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(RadioGroup group, @IdRes int checkedId) {
                    if (checkedId == idProducer.getFirstRadioButtonId()) {
                        mSelection = NRLikeType.MISSING_INFORMATION;
                    } else {
                        mSelection = NRLikeType.INCORRECT_ANSWER;
                    }
                }
            });
        } else if (feedbackDialogType == OPEN_TEXT) {
            feedbackChoicesRadio.setVisibility(View.GONE);
            mSelection = NRLikeType.INCORRECT_ANSWER;
        } else {
            this.dismiss();
            return;
        }

        cancelButton.setOnClickListener(this);
        okButton.setOnClickListener(this);
    }

    @Override
    public void onDismiss(DialogInterface dialogInterface) {
        hideKeyboard();
        if (!isDismissHandled) {
            dislikeDialogListener.onCancel();
        }
    }

    @Override
    public void onClick(View view) {
        hideKeyboard();

        if (view.getId() == okButton.getId()) {
            isDismissHandled = true;
            if (feedbackDialogType == OPEN_TEXT || feedbackDialogType == MULTIPLE_CHOICE_OPEN_TEXT) {
                feedbackText = feedbackEditText.getText().toString();
            }
            dislikeDialogListener.onDislike(mSelection, feedbackText);
            this.dismiss();
        } else {
            isDismissHandled = true;
            dislikeDialogListener.onCancel();
            this.dismiss();
        }
    }

    private void hideKeyboard() {
        View view = getView();
        if (view != null) {
            view.clearFocus();

            InputMethodManager imm = (InputMethodManager) getActivity().getSystemService(Context.INPUT_METHOD_SERVICE);
            if (imm != null) {
                imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
        }
    }
}
