/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components.formSDK.Adapters;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.List;
import nanorep.nanowidget.Components.formSDK.Interactions.AdapterFragmentInteraction;
import nanorep.nanowidget.Components.formSDK.Interactions.FormViewHolderAdapterInteraction;
import nanorep.nanowidget.Components.formSDK.ViewHolders.AutoButtonsViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.CheckBoxListViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.EditTextViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.FormFieldViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.PickerViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.SpinnerViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.TextViewHolder;
import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.R;
import org.json.JSONException;

public class FormAdapter
extends RecyclerView.Adapter<FormFieldViewHolder>
implements AutoButtonsViewHolder.ButtonClicked,
FormViewHolderAdapterInteraction {
    private List<FormFields> formFields;
    private RecyclerView recyclerView;
    private AdapterFragmentInteraction adapterFragmentInteraction;
    private final int ANDROID_EDIT_TEXT = 0;
    private final int ANDROID_BUTTONS = 1;
    private final int ANDROID_SPINNER = 2;
    private final int ANDROID_TEXT_VIEW = 3;
    private final int ANDROID_PICKER = 4;
    private final int ANDROID_CHECKBOX_LIST = 5;
    private final int ANDROID_FILE_UPLOAD = 6;

    public FormAdapter(List<FormFields> formFields, AdapterFragmentInteraction adapterFragmentInteraction) {
        this.formFields = formFields;
        this.adapterFragmentInteraction = adapterFragmentInteraction;
    }

    public FormFieldViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        switch (viewType) {
            case 0: {
                View view = inflater.inflate(R.layout.form_view_holder_edittext, parent, false);
                return new EditTextViewHolder(view, this.formFields, this);
            }
            case 1: {
                View view = inflater.inflate(R.layout.form_view_holder_auto_buttons, parent, false);
                return new AutoButtonsViewHolder(view, this.formFields, this);
            }
            case 2: {
                View view = inflater.inflate(R.layout.form_view_holder_spinner, parent, false);
                return new SpinnerViewHolder(view, this.formFields, this);
            }
            case 3: {
                View view = inflater.inflate(R.layout.form_view_holder_textview, parent, false);
                return new TextViewHolder(view, this.formFields);
            }
            case 4: {
                View view = inflater.inflate(R.layout.form_view_holder_picker, parent, false);
                return new PickerViewHolder(view, this.formFields, this);
            }
            case 6: {
                View view = inflater.inflate(R.layout.form_view_holder_picker, parent, false);
                return new PickerViewHolder(view, this.formFields, this);
            }
            case 5: {
                View view = inflater.inflate(R.layout.form_view_holder_checkbox_list, parent, false);
                return new CheckBoxListViewHolder(view, this.formFields, this);
            }
        }
        return null;
    }

    public int getItemViewType(int position) {
        FormFields formField = this.formFields.get(position);
        switch (formField.getInputType()) {
            case 1: {
                if (formField.isDatePickerField() || formField.isTimePickerField() || formField.isFilePickerField()) {
                    return 4;
                }
                return 0;
            }
            case 8: {
                return 1;
            }
            case 2: 
            case 5: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 6: {
                return 5;
            }
            case 9: {
                return 6;
            }
        }
        return -1;
    }

    public void onBindViewHolder(FormFieldViewHolder holder, int position) {
        holder.bind();
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.recyclerView = recyclerView;
    }

    public int getItemCount() {
        return this.formFields.size();
    }

    @Override
    public void selectFromPickerAndUpdateView(int adapterPosition, PickerViewHolder pickerViewHolder) {
        this.adapterFragmentInteraction.selectFromPicker(11, adapterPosition, pickerViewHolder);
    }

    @Override
    public void onNextClicked(int position) {
        RecyclerView.ViewHolder nextViewHolder = this.recyclerView.findViewHolderForAdapterPosition(position + 1);
        if (nextViewHolder instanceof EditTextViewHolder) {
            nextViewHolder.itemView.requestFocus();
        }
    }

    @Override
    public void yesButtonClicked() throws JSONException {
        this.recyclerView.clearFocus();
        this.adapterFragmentInteraction.validateDataAndSendForm();
    }

    @Override
    public void noButtonClicked() {
        this.adapterFragmentInteraction.discardForm();
    }
}

