package nanorep.nanowidget.DataClass;

import android.app.AlertDialog;
import android.content.Context;
import android.util.Log;
import android.widget.Toast;


import com.nanorep.nanoclient.Connection.NRConnection;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Interfaces.NRSpeechRecognizerCompletion;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRFAQLikeParams;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRFAQAnswer;
import com.nanorep.nanoclient.Response.NRFAQData;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.Response.NRSearchResponse;
import com.nanorep.nanoclient.Response.NRSuggestions;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.ContextValue;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.OnDataResponse;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRFetcherListener;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

/**
 * Created by nissimpardo on 04/06/16.
 */
public class NRFetchedDataManager {
    private NRFAQData mFaqData;
    private NRFetcherListener mFetcherListener;
    private NRConfigFetcherListener mconfigFetcherListener;
    private Context context;
    private String preContextSelectionQuery;
    private String searchContext;
    private List<Map<String, Object>> contextList;
    private String selectionDialogTitle;
    private AlertDialog contextSelectionDialog;
    private NRConfigFetcherListener fetcherListener;

    public NRFetchedDataManager(Context context, NRConfigFetcherListener configFetcherListener) {
        this.context = context;
        mconfigFetcherListener = configFetcherListener;
        fetchConfiguration();
    }

    public void fetchConfiguration() {
        if (Nanorep.getInstance().getNRConfiguration() != null) {
            mconfigFetcherListener.onConfigurationReady();
            prepareDatasource();
        }
    }

    public NRFetcherListener getFetcherListener() {
        return mFetcherListener;
    }

    public void setFetcherListener(NRFetcherListener listener) {
        mFetcherListener = listener;
    }

    public void setConfigFetcherListener(NRConfigFetcherListener mconfigFetcherListener) {
        this.mconfigFetcherListener = mconfigFetcherListener;
    }

    private void prepareDatasource() {
        if (Nanorep.getInstance().getAccountParams().isLabelsMode()) {
            updateCategoriesResults(null);
            return;
        }

        NRConnection.Listener listener = new NRConnection.Listener() {
            @Override
            public void response(Object responseParam, int status, NRError error) {

                final ArrayList<NRFAQGroupItem> groups = new ArrayList<>();
                if (responseParam instanceof HashMap) {
                    final HashMap<String, Object> map = (HashMap<String, Object>) responseParam;
                    final NRFAQGroupItem group = new NRFAQGroupItem(map);
                    groups.add(group);
                    mconfigFetcherListener.insertRows(groups);
                }
            }

            @Override
            public void log(String tag, String msg) {

            }
        };

        Nanorep.getInstance().updateFaqList(null, Nanorep.getInstance().getAccountParams().getContext(), true, listener);
    }

    private void updateCategoriesResults(ArrayList<NRFAQGroupItem> groups) {
        if (groups != null) {
            mconfigFetcherListener.insertRows(groups);
        } else {
            mconfigFetcherListener.insertRows(null);
        }
    }

    public static ArrayList<NRResult> generateNRResultArray(ArrayList<NRQueryResult> queryResults, Context context) {
        if (queryResults != null) {
            int height = Integer.valueOf(Nanorep.getInstance().getNRConfiguration().getTitle().getTitleRowHeight());
            ArrayList<NRResult> results = new ArrayList<>();
            for (NRQueryResult result : queryResults) {
                NRResult currentResult = new NRResult(result, NRResultItem.RowType.TITLE);
                currentResult.setHeight((int) Calculate.pxFromDp(context, height));
                results.add(currentResult);
            }
            return results;
        }
        return null;
    }

    @SuppressWarnings("unchecked")
    public void searchText(final String text) {
        Nanorep.getInstance().searchText(text, new Nanorep.OnSearchResultsFetchedListener() {
            @Override
            public void onSearchResponse(NRSearchResponse response, NRError error) {
                if (error != null) {
                    Log.d("RequestError", error.getDescription());

                } else {
                    // Response null or no results found:

                    if (response == null || (response.getAnswerList() == null || response.getAnswerList().isEmpty())) {
                        NRResult noResult = getNoResultResponse(response, text);
                        mconfigFetcherListener.noResultFound(noResult, searchContext);
                        return;
                    }

                    // Results found:

                    boolean contextSelectionOnly;
                    String contextName = null;

                    ArrayList<NRResult> results = generateNRResultArray(response.getAnswerList(), context);

                    // try to generate contextList from the response.
                    try {
                        if (contextList == null && response.getParams().containsKey("context")) {
                            contextList = (List<Map<String, Object>>) ((Map<String, Object>) response.getParams().get("context")).get("values");
                        }

                        contextSelectionOnly = (boolean) response.getAnswerList().get(0).getParams().get("contextSelectionOnly");

                        List<Integer> selectionContextIds = response.getSelectionContextId();

                        if (contextList != null && !contextList.isEmpty()) {
                            contextName = findContextName(selectionContextIds, contextList);
                        }

                        if (contextName != null && contextName.length() == 0) {
                            contextSelectionOnly = false;
                        }

                    } catch (NullPointerException | ClassCastException e) {
                        contextSelectionOnly = false;
                    }

                    // responses handling:

                         // Has dynamic context
                    if (contextSelectionOnly && contextName != null && !contextName.isEmpty()) {
                        preContextSelectionQuery = text;
                        fetchContextSelectionData(contextName);

                        // Doesn't have dynamic context but has results
                    } else {
                        mFetcherListener.insertRows(results, searchContext);
                    }
                }
            }
        });
    }

    private String findContextName(List<Integer> ids, List<Map<String, Object>> contextList) {
        StringBuilder ctx = new StringBuilder();

        for (int id : ids) {
            for (Map<String, Object> map : contextList) {
                String _id = String.valueOf(map.get("id"));
                if (_id.equals(String.valueOf(id))) {
                    if (ctx.length() > 0) {
                        ctx.append(",");
                    }
                    selectionDialogTitle = (String) map.get("selectionText");
                    ctx.append((String) map.get("name"));
                }
            }
        }

        return ctx.toString();
    }


    private NRResult getNoResultResponse(NRSearchResponse response, String text) {
        response.getParams().put("originalSearch", text);
        return new NRResult(response.getParams());
    }

    private void fetchContextSelectionData(final String contextName) {
        Nanorep.getInstance().getContextValues(contextName, new OnDataResponse<String>() {
            @Override
            public void onSuccess(String response) {
                try {
                    String[] keys = contextName.split(",");
                    ContextValue contextValues = new ContextValue(keys[0]);
                    extractContext(new JSONObject(response), contextValues, keys, 0);
                    mconfigFetcherListener.showContextSelectionDialog(contextValues);
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }

            @Override
            public void onError(NRConnectionException error) {

            }
        });
    }

    private void extractContext(JSONObject json, ContextValue contextValue, String[] key, int depth) throws JSONException {
        Iterator<String> jsonKeys = json.keys();
        while (jsonKeys.hasNext()) {
            String propName = jsonKeys.next();
            ContextValue subContext;
            if (propName.equals("values")) {
                subContext = contextValue;
            } else {
                subContext = new ContextValue(key[depth]);
                subContext.setParentContextValue(propName);
                contextValue.getSubContext().add(subContext);
            }

            JSONArray arr = json.getJSONArray(propName);
            for (int i = 0; i < arr.length(); i++) {
                if (arr.get(i) instanceof String) {
                    subContext.getValues().add((String) arr.get(i));
                } else {
                    extractContext((JSONObject) arr.get(i), subContext, key, depth + 1);
                }
            }
        }
    }

    public void presentResultsForSelectedContext(final String selectedSearchContext) {
        Nanorep.getInstance().setContext(selectedSearchContext, new OnDataResponse<DefaultResponse>() {
            @Override
            public void onSuccess(DefaultResponse response) {
                Nanorep.getInstance().removeFromSearchCache(preContextSelectionQuery);
                if (searchContext == null) {
                    searchContext = "";
                }
                searchContext = selectedSearchContext;
                Nanorep.getInstance().searchText(preContextSelectionQuery, new Nanorep.OnSearchResultsFetchedListener() {
                    @Override
                    public void onSearchResponse(NRSearchResponse response, NRError error) {
                        ArrayList<NRResult> results = generateNRResultArray(response.getAnswerList(), context);
                        if (results != null) {
                            mFetcherListener.insertRows(results, searchContext);
                        } else {
                            NRResult noResult = getNoResultResponse(response, preContextSelectionQuery);
                            ArrayList<NRResult> noResultsArrayList = new ArrayList<>();
                            noResultsArrayList.add(noResult);
                            mFetcherListener.insertRows(noResultsArrayList, searchContext);
                        }
                    }
                });
            }

            @Override
            public void onError(NRConnectionException error) {
            }
        });
    }

    public void searchSuggestion(final String suggestion) {
        Nanorep.getInstance().suggestionsForText(suggestion, new Nanorep.OnSuggestionsFetchedListener() {
            @Override
            public void onSuggestionsFetched(NRSuggestions suggestions, NRError error) {
                if (error != null) {
                    Log.d("Fetcher", error.getDomain());
                } else if (suggestions != null && suggestions.getSuggestions() != null) {
                    mFetcherListener.presentSuggestion(suggestion, suggestions.getSuggestions());
                }
            }
        });
    }

    public void startSpeech(NRSpeechRecognizerCompletion completion) {
//        mNanoRep.startVoiceRecognition(completion);
    }

    public void sendLike(NRLikeType likeType, String feedbackText, NRQueryResult result, Nanorep.OnLikeSentListener completion) {
//        if (true) {
            NRFAQLikeParams likeParams = new NRFAQLikeParams(result, feedbackText);
            likeParams.setLikeType(likeType);
            likeParams.setAnswerId(result.getId());
            Nanorep.getInstance().likeForFAQResult(likeParams, completion);
//        } else {
//            NRSearchLikeParams likeParams = new NRSearchLikeParams(result);
//            likeParams.setFeedbackType(likeType);
//            Nanorep.getInstance().likeForSearchResult(likeParams, completion);
//        }
    }

    public void resetLike(String resultId) {
        for (NRQueryResult result : mFaqData.getGroups().get(0).getAnswers()) {
            if (result.getId().equals(resultId)) {
                result.setLikeState(NRQueryResult.LikeState.notSelected);
            }
        }
    }

    public void faqAnswer(final String answerId, Integer answerHash, final OnFAQAnswerFetched answerFetcher) {
        Nanorep.getInstance().fetchFAQAnswer(answerId, answerHash, new Nanorep.OnFAQAnswerFetchedListener() {
            @Override
            public void onFAQAnswerFetched(NRFAQAnswer faqAnswer, NRError error) {
                if (error == null) {
                    answerFetcher.onAnswerFetched(faqAnswer);
                } else {
                    answerFetcher.onAnswerFetched(null);
                }
            }
        });
    }

    private void onRequestError(NRError error) {

    }

    public void clearSearchContext() {
        searchContext = null;
    }

    public void fetchLabelFAQ(final NRLabel label) {
        Nanorep.getInstance().updateFaqList(null, label.getContext(), false, new NRConnection.Listener() {
            @Override
            public void response(Object responseParam, int status, NRError error) {
                try {
                    final ArrayList<NRFAQGroupItem> groups = new ArrayList<>();
                    if (responseParam instanceof HashMap) {
                        final HashMap<String, Object> map = (HashMap<String, Object>) responseParam;
                        final NRFAQGroupItem group = new NRFAQGroupItem(map);
                        groups.add(group);
                        if (!groups.isEmpty()) {
                            mconfigFetcherListener.insertRows(groups);
                        } else {
                            Log.e("labelError", "no data for label " + label.getTitle());
                        }
                    }

                } catch (ClassCastException e) {
                    Log.d("ResponseError", "Response cast error");
                }
            }

            @Override
            public void log(String tag, String msg) {

            }
        });
    }

    private boolean duplicateFAQ(NRQueryResult nrQueryResult, ArrayList<NRQueryResult> answers) {
        for (NRQueryResult answer : answers) {
            if (answer.getId().equals(nrQueryResult.getId())) {
                return true;
            }
        }
        return false;
    }
}
