/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.DataClass;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.nanorep.nanoclient.model.ContextValue;
import nanorep.nanowidget.R;

class ContextSelectionAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final ContextSelectionListener listener;
    private boolean hasSubContext;
    private ContextValue contextValues;
    private StringBuilder contextBuilder;

    public ContextSelectionAdapter(ContextValue contextValues, ContextSelectionListener listener) {
        this.listener = listener;
        this.contextBuilder = new StringBuilder();
        this.contextValues = contextValues;
        if (contextValues.subContext.size() > 0) {
            this.hasSubContext = true;
        }
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Context context = parent.getContext();
        View view = LayoutInflater.from((Context)context).inflate(R.layout.context_selection_recycler_item, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        String text = this.hasSubContext ? ((ContextValue)this.contextValues.subContext.get((int)position)).parentContextValue : (String)this.contextValues.values.get(position);
        holder.textView.setText((CharSequence)text);
    }

    public int getItemCount() {
        return this.hasSubContext ? this.contextValues.subContext.size() : this.contextValues.values.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        public TextView textView;

        public ViewHolder(View view) {
            super(view);
            view.setOnClickListener((View.OnClickListener)this);
            this.textView = (TextView)view.findViewById(R.id.context_selection_item_textview);
        }

        public void onClick(View v) {
            if (ContextSelectionAdapter.this.hasSubContext) {
                ContextSelectionAdapter.this.contextBuilder.append(((ContextSelectionAdapter)ContextSelectionAdapter.this).contextValues.contextKey).append(":");
                ContextSelectionAdapter.this.contextValues = (ContextValue)((ContextSelectionAdapter)ContextSelectionAdapter.this).contextValues.subContext.get(this.getAdapterPosition());
                ContextSelectionAdapter.this.contextBuilder.append(((ContextSelectionAdapter)ContextSelectionAdapter.this).contextValues.parentContextValue).append(",");
                ContextSelectionAdapter.this.hasSubContext = ((ContextSelectionAdapter)ContextSelectionAdapter.this).contextValues.subContext.size() > 0;
                ContextSelectionAdapter.this.listener.onContextSelected(ContextSelectionAdapter.this.contextBuilder.toString());
            } else {
                if (((ContextSelectionAdapter)ContextSelectionAdapter.this).contextValues.contextKey != null && ((ContextSelectionAdapter)ContextSelectionAdapter.this).contextValues.values.size() > 0) {
                    ContextSelectionAdapter.this.contextBuilder.append(((ContextSelectionAdapter)ContextSelectionAdapter.this).contextValues.contextKey).append(":").append((String)((ContextSelectionAdapter)ContextSelectionAdapter.this).contextValues.values.get(this.getAdapterPosition()));
                }
                ContextSelectionAdapter.this.listener.onContextSelected(ContextSelectionAdapter.this.contextBuilder.toString());
            }
        }
    }

    public static interface ContextSelectionListener {
        public void onContextSelected(String var1);
    }
}

