package nanorep.nanowidget.Fragments;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Spannable;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingPhoneNumber;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRExtraDataListener;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRAnswer;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.OnDataResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.NRCustomDislikeDialog;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresentor;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.ChannelPresenters.NRCustomScriptChannelPresentor;
import nanorep.nanowidget.Components.ConfirmationDialogFragment;
import nanorep.nanowidget.Components.MyWebView;
import nanorep.nanowidget.Components.NRCategoriesView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRLikeViewText;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRArticleView;
import nanorep.nanowidget.Components.NRResultsView;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.Components.NRTitleView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.Components.formSDK.FormFragment;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRLabelsAdapter;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.DataClass.NRResultsAdapter;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.DislikeConfiguration;
import nanorep.nanowidget.interfaces.DislikeDialogListener;
import nanorep.nanowidget.interfaces.NRApplicationContentListener;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRFetcherListener;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

import static com.nanorep.nanoclient.Channeling.NRChanneling.NRChannelingType.ChatForm;
import static com.nanorep.nanoclient.Channeling.NRChanneling.NRChannelingType.ContactForm;
import static com.nanorep.nanoclient.Channeling.NRChanneling.NRChannelingType.PhoneNumber;
import static com.nanorep.nanoclient.Response.NRConfiguration.NO_FEEDBACK_DIALOG_TYPE;

public class NRMainFragment extends Fragment implements NRSearchBarListener, NRLabelsAdapter.NRLabelsListener,
        NRSuggestionsListener,
        NRCategoriesView.Listener,
        NRResultsView.Listener,
        NRContentView.Listener,
        NRChannelItem.OnChannelSelectedListener,
        NRArticleView.Listener,
        NRErrorHandler.Listener {

    public static final String TAG = NRMainFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;

    private NRFetchedDataManager mFetchedDataManager;

    private NRCustomViewAdapter viewAdapter;

    private RelativeLayout mLoadingView;

    private LinearLayout fragmentMainLayout;

    private SearchViewsProvider viewsProvider;

    private FrameLayout contentMain;

    private Nanorep.NanoRepWidgetListener widgetListener;

    // search bar
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;

    // suggestion view
    private NRCustomSuggestionsView mSuggestionsView;
    private LinearLayout mSuggestionViewContainer;

    private NRCategoriesView categoriesView;

    private boolean resetSuggestions = false;

    private boolean autocompleteEnabled = true;

    private View.OnKeyListener onKeyListener;

    // no connection
    private LinearLayout noConnectionView;

    private boolean animation = false;

    private NRApplicationContentListener applicationContentListener;
    private NRCustomChannelView channelView;
    private NRCustomLikeView likeView;
    private String articleId;
    private Button clearContextButton;

    private TextView searchContextTextView;
    private LinearLayout searchContextLayout;
    private String searchContextKey;
    private String searchContextValue;

    private NRLabel currentLabel;
    private TextView actionBarTextView;
    //    private NRResult currentResult;
    private boolean fragmentPaused;
    private NRChannelingView noResultsChannelingRecycler;
    private long previousClickTime;
    private NRConfiguration configuration;
    private NRResultsView resultsView;

    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }

    @Override
    public void fetchBodyForResult(final NRCustomContentView view, String resultID, Integer resultHash) {
        this.articleId = resultID;
        mFetchedDataManager.faqAnswer(resultID, resultHash, new OnFAQAnswerFetched() {
            @Override
            public void onAnswerFetched(NRQueryResult result) {
                if (result != null) {
                    view.loadData(result.getBody(), "text/html", "UTF-8");
                }
            }
        });
    }

    @Override
    public void closeAnswer() {
        // get the last view
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);

        if (!animation) {
            view.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_out_left));
        } else {
            if (view instanceof NRArticleView && !((NRArticleView) view).getmResult().isSingle()) {
                ((NRArticleView) view).setResultUnFoldState(false);
                ((NRArticleView) view).removeTopView();
            }
        }

        contentMain.removeView(view);
    }

    @Override
    public void onChannelSelected(final NRChanneling channel) {
        String extraData;
        NRQueryResult currentResult = getCurrentResult();
        if (currentResult == null || currentResult.getExtraData() == null) {
//
//            if(channel.getNoResultExtra() == null) {
//                openChannel(channel);
//                return;
//            }
            extraData = channel.getNoResultExtra();
        } else {
            extraData = getCurrentResult().getExtraData();
        }

        widgetListener
                .personalInfoWithExtraData(
                        channel.getChannelDescription(),
                        extraData,
                        new NRExtraDataListener() {
                            @Override
                            public void onExtraData(Map<String, String> extraData) {
                                channel.setExtraData(extraData);
                                openChannel(channel);
                            }
                        });
    }

    private void openChannel(NRChanneling channeling) {

        NRChannelPresentor presentor = NRChannelStrategy.presentor(getContext(), channeling, Nanorep.getInstance());

        if (presentor instanceof NRCustomScriptChannelPresentor) {

            presentor.present();

        } else {
            String url = presentor.getUrl();
            if (url != null) {
                if (channeling.getType() == ContactForm
                        && TextUtils.isDigitsOnly(channeling.getContactForm())
                        && android.os.Build.VERSION.SDK_INT < Build.VERSION_CODES.KITKAT) {

                    FormFragment fragment = FormFragment.newInstance(Integer.parseInt(channeling.getContactForm()), channeling.getThankYouMessage(), configuration.getFeedbackConfirmationDialogTitle(), configuration.getFeedbackConfirmationDialogButton());
                    getFragmentManager()
                            .beginTransaction()
                            .setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out)
                            .add(R.id.content_main, fragment)
                            .addToBackStack("linked").commit();

                } else {
                    if (channeling.getType() == ChatForm) {
                        final RelativeLayout holder = getView().findViewById(R.id.fragment_place_holder);
                        holder.setVisibility(View.VISIBLE);
                    }
                    NRWebContentFragment fragment = NRWebContentFragment.newInstance(url, channeling.getThankYouMessage(), configuration.getFeedbackConfirmationDialogTitle(), configuration.getFeedbackConfirmationDialogButton());
                    fragment.setListener(new NRWebContentFragment.WebFormListener() {
                        @Override
                        public void onDismiss(String result) {
                            if (result == null) {
                                getFragmentManager().popBackStack();
                            }
                            InputMethodManager imm = (InputMethodManager) getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
                            imm.hideSoftInputFromWindow(getView().getWindowToken(), 0);
                            requestFocus();
                        }
                    });
                    getFragmentManager()
                            .beginTransaction()
                            .setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out)
                            .add(R.id.content_main, fragment)
                            .addToBackStack("linked").commit();
                }
            } else if (channeling.getType() == PhoneNumber) {
                String phoneNumber = ((NRChannelingPhoneNumber) channeling).getPhoneNumber();
                widgetListener.onChannel(PhoneNumber, phoneNumber);
                String channelName = channeling.getName();
//                Intent intent = new Intent(Intent.ACTION_DIAL, Uri.fromParts("tel", phoneNumber, null));
//                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
//                try {
//                    startActivity(intent);
//                } catch (ActivityNotFoundException e) {
//
//                }
                Nanorep.getInstance().reportChanneling(articleId, "5", channelName);
            }
        }
    }


    private NRQueryResult getCurrentResult() {
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            return ((NRArticleView) view).getmResult().getFetchedResult();
        }
        return null;
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
        mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched() {
            @Override
            public void onAnswerFetched(final NRQueryResult result) {

                NRResult newResult = new NRResult(result, NRResultItem.RowType.TITLE);
                int height = Integer.valueOf(configuration.getTitle().getTitleRowHeight());
                newResult.setHeight((int) Calculate.pxFromDp(getContext(), height));
                newResult.setSingle(true);

                NRArticleView resultTopView = getTopView();
                contentMain.addView(resultTopView);

                resultTopView.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_in_left));

                resultTopView.openOpenedView(newResult);

                requestFocus();
            }
        });
    }

    @Override
    public void onLinkClicked(String url) {
        if (Nanorep.getInstance().getAccountParams().isOpenLinksInternally()) {
            MyWebView webView = new MyWebView(getContext(), url, new MyWebView.Listener() {
                @Override
                public void onDismiss() {
                    contentMain.removeViewAt(contentMain.getChildCount() - 1);
                    requestFocus();
                }
            });

            contentMain.addView(webView);
            requestFocus();
        } else {
            Intent intent = new Intent(Intent.ACTION_VIEW);
            intent.setData(Uri.parse(url));
            try {
                startActivity(intent);
            } catch (Exception e) {

            }
        }
    }

    @Override
    public void onDismiss() { //for NRContent
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);

        if (view instanceof NRArticleView) {
            view.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_out_left));
        }

        removeTopView();
    }

    @Override
    public void onLikeClicked(final NRArticleView view, final NRCustomLikeView likeView, String resultId, boolean isLike) {
        final NRResult result = view.getmResult();

        if (isLike) {
            result.getFetchedResult().setLikeState(NRQueryResult.LikeState.positive);
            mFetchedDataManager.sendLike(NRLikeType.POSITIVE, "", result.getFetchedResult(), new Nanorep.OnLikeSentListener() {
                @Override
                public void onLikeSent(boolean success) {
                    if (!success) {
                        view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                        likeView.resetLikeView();
                    } else {
                        View view = getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                        new ConfirmationDialogFragment(getContext(), view, configuration.getFeedbackConfirmationDialogBody(), configuration.getFeedbackConfirmationDialogButton(), configuration.getFeedbackConfirmationDialogTitle());
                    }
                }
            });
        } else {
            if (likeView.shouldOpenDialog()) {
                openDislikeDialog(result, view, likeView);
            } else {
                onDislike(result, view, likeView, NRLikeType.INCORRECT_ANSWER, "");
            }
        }
    }

    private void onDislike(NRResult result, final NRArticleView view, final NRCustomLikeView likeView, NRLikeType type, String feedbackText) {
        result.getFetchedResult().setLikeState(NRQueryResult.LikeState.negative);
        mFetchedDataManager.sendLike(type, feedbackText, result.getFetchedResult(), new Nanorep.OnLikeSentListener() {
            @Override
            public void onLikeSent(boolean success) {
                if (!success) {
                    view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                    Toast.makeText(getContext(), getResources().getString(R.string.feedback_error_message), Toast.LENGTH_LONG).show();
                    removeTopView();
                } else {
                    View view = getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                    new ConfirmationDialogFragment(getContext(), view, configuration.getFeedbackConfirmationDialogBody(), configuration.getFeedbackConfirmationDialogButton(), configuration.getFeedbackConfirmationDialogTitle());
                }
            }
        });
    }

    private void onDismissDislike() {
        // update channeling
        Nanorep.getInstance().getChanneling(articleId, false, new OnDataResponse<List<NRChanneling>>() {
            @Override
            public void onSuccess(List<NRChanneling> response) {

                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (view instanceof NRArticleView) {
                    NRQueryResult fetchedResult = ((NRArticleView) view).getmResult().getFetchedResult();
                    for (NRChanneling channel : response) {
                        channel.setQueryResult(fetchedResult);
                    }
                }
                channelView.setVisibility(View.VISIBLE);
                channelView.setChanneling(response);
            }

            @Override
            public void onError(NRConnectionException error) {
                Log.e("updateChanneling", "error on updateChanneling: " + error.getData());
                channelView.setVisibility(View.GONE);
            }
        });
    }


    private void openDislikeDialog(final NRResult result, final NRArticleView view, final NRCustomLikeView likeView) {
        // String reasons[] = new String[]{getString(R.string.missing_information), getString(R.string.didnt_find)};

        final int dialogType = configuration.getFeedbackDialogType();
        final int dislikeViewId;

        if (dialogType != NO_FEEDBACK_DIALOG_TYPE) {
            if (viewsProvider != null) {
                int dialogFragmentViewId = viewsProvider.getNegativeFeedbackDialogLayout();
                dislikeViewId =  dialogFragmentViewId;
            } else {
                dislikeViewId = R.layout.dislike_dialog_mixed;
            }

            NRCustomDislikeDialog dislikeDialog = viewsProvider.getDislikeDialog(new DislikeConfiguration(configuration) {
                @Override
                public DislikeDialogListener getDislikeDialogListener() {
                    return new DislikeDialogListener() {
                        @Override
                        public void onCancel() {
                            likeView.resetLikeView();
                            NRMainFragment.this.onDismissDislike();
                        }

                        @Override
                        public void onDislike(NRLikeType type, String feedbackText) {
                            NRMainFragment.this.onDislike(result, view, likeView, type, feedbackText);
                        }
                    };
                }
            });

            dislikeDialog.show(getFragmentManager(), "dislike");
        }
    }

    public static NRMainFragment newInstance(String context) {
        NRMainFragment fragment = new NRMainFragment();
        return fragment;
    }

    public static NRMainFragment newInstance(SearchInjector injector) {
        NRMainFragment fragment = new NRMainFragment();

        SearchViewsProvider viewsProvider = injector.getUiProvider();
        fragment.setViewsProvider(viewsProvider == null ? new SearchInjector.DefaultsInjector().getUiProvider() : viewsProvider);

        return fragment;
    }

    public static NRMainFragment newInstance() {

        Bundle args = new Bundle();

        NRMainFragment fragment = new NRMainFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if (context instanceof NRCustomViewAdapter) {
            viewAdapter = (NRCustomViewAdapter) context;
        }
    }

    private void initDataManager() {
        mFetchedDataManager = new NRFetchedDataManager(getContext(), new NRConfigFetcherListener() {
            @Override
            public void onConfigurationReady() {

                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) {
                    contentMain.removeView(view);
                }

                updateTitleNormalText();
                updateSearchBar();
                showSuggestionsView();
                mLoadingView.setVisibility(View.GONE);
            }

            @Override
            public void insertRows(ArrayList<NRFAQGroupItem> groups) {
                try {
                    hideKeyboard();
                    if (groups != null && groups.size() > 1 || Nanorep.getInstance().getAccountParams().isLabelsMode()) {
                        openCategoriesView(groups);
                    } else if (groups.size() == 1) {
                        // show results view immidiately
                        openNRResultView(NRFetchedDataManager.generateNRResultArray(groups.get(0).getAnswers(), getContext()), groups.get(0).getTitle());
                    }
                } catch (Exception e) {
                    return;
                }
            }

            @Override
            public void onError() {
                mLoadingView.setVisibility(View.GONE);
                noConnectionView.setVisibility(View.GONE);

                NRErrorView errorView = new NRErrorView(getContext());
                errorView.setListener(new NRErrorView.Listener() {
                    @Override
                    public void tryAgain() {
                        mFetchedDataManager.fetchConfiguration();
                        mLoadingView.setVisibility(View.VISIBLE);
                    }
                });
                contentMain.addView(errorView);
            }

            @Override
            public void noResultFound(NRResult result, String searchContext) {
                hideKeyboard();
                final NRArticleView resultTopView = getTopView();
                mSuggestionViewContainer.setVisibility(View.GONE);
                resultTopView.setVisibility(View.VISIBLE);
                contentMain.setVisibility(View.VISIBLE);
                contentMain.addView(resultTopView);
                searchContextValue = searchContext;
                if (!searchContext.isEmpty()) {
                    mFetchedDataManager.getmFetcherListener().insertRows(null, searchContextValue);
                }
                presentResult(result, 0, resultTopView);
            }
        });

        mFetchedDataManager.setFetcherListener(new NRFetcherListener() {

            @Override
            public void reloadWithAnimation() {

            }

            @Override
            public void reload() {

            }

            @Override
            public void insertRows(List<NRResult> results, String searchContext) {
                if (isDetached() || getContext() == null) {
                    return;
                }

                hideKeyboard();
                clearSuggestionsView();
                if (searchContext == null || searchContext.length() == 0) {
                    searchContextLayout.setVisibility(View.GONE);
                    searchContextValue = "";
                } else {
                    searchContextLayout.setVisibility(View.VISIBLE);
                    StringBuilder builder = new StringBuilder();
                    for (String context : searchContext.split(",")) {
                        String[] ctx = context.split(":");
                        if (ctx.length != 2) {
                            return;
                        }
                        if (builder.length() > 0) {
                            builder.append(", ");
                        }
                        builder.append(ctx[1]);
                    }
                    searchContextValue = builder.toString();
                    searchContextTextView.setText(searchContextValue);
                }

                if (results == null || results.isEmpty()) {
                    if (searchBarView.getText() != null) {
//                        noSearchResultView.setVisibility(View.VISIBLE);
//                        mNoTitleView.setText(Nanorep.getInstance().getNRConfiguration().getCustomNoAnswersTextContext(searchBarView.getText()));

                        while (contentMain.getChildCount() > 2) {
                            contentMain.removeViewAt(contentMain.getChildCount() - 1);
                        }

                        contentMain.setVisibility(View.VISIBLE);
                        requestFocus();
                    }
                } else if (results.size() == 1) {
                    NRResult currentResult = results.get(0);
                    articleId = currentResult.getFetchedResult().getId();
                    NRArticleView resultTopView = getTopView();

                    contentMain.setVisibility(View.VISIBLE);
                    contentMain.addView(resultTopView);

                    Animation animation = AnimationUtils.loadAnimation(getContext(), R.anim.slide_in_left);
                    animation.setAnimationListener(new Animation.AnimationListener() {
                        @Override
                        public void onAnimationStart(Animation animation) {
                            for (int i = 0; i <= contentMain.getChildCount() - 2; i++) {
                                View view = contentMain.getChildAt(i);
//                                view.setVisibility(View.INVISIBLE);
                            }
//                                    contentMain.getChildAt(contentMain.getChildCount() -2).setVisibility(View.INVISIBLE);
                            contentMain.getChildAt(contentMain.getChildCount() - 1).setVisibility(View.VISIBLE);
                        }

                        @Override
                        public void onAnimationEnd(Animation animation) {
                            for (int i = 0; i <= contentMain.getChildCount() - 2; i++) {
                                View view = contentMain.getChildAt(i);
//                                view.setVisibility(View.VISIBLE);
                            }
                        }

                        @Override
                        public void onAnimationRepeat(Animation animation) {

                        }
                    });

                    resultTopView.setAnimation(animation);

                    resultTopView.startAnimation(animation);

                    NRResult result = results.get(0);

                    result.setSingle(true);

                    resultTopView.openOpenedView(result);

                    requestFocus();
                } else if (results.size() > 1) {
                    // show results View
                    contentMain.setVisibility(View.VISIBLE);

                    openNRResultView(results, null);
                }
            }

            @Override
            public void presentSuggestion(String querytext, ArrayList<Spannable> suggestions) {
                if (!resetSuggestions && searchBarView.getText().length() - querytext.length() <= 1 && autocompleteEnabled) {
                    mSuggestionsView.setSuggestions(suggestions);
                    mSuggestionViewContainer.setVisibility(View.VISIBLE);
                    // hide content view
                    contentMain.setVisibility(View.GONE);
                }
            }

            @Override
            public void onConnectionFailed(HashMap<String, Object> errorParams) {

            }
        });
    }

    private void hideKeyboard() {
        View view = getView();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager) getActivity().getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();

        Nanorep.getInstance().reset();
    }

    @Override
    public void onPause() {
        super.onPause();
        fragmentPaused = true;
        NRErrorHandler.getInstance().setListener(null);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (fragmentPaused) {
            renewSession();
            fragmentPaused = false;
        }
    }

    private void renewSession() {
        if (Nanorep.getInstance().getSessionId() == null) {
            return;
        }

        //todo
    }

    private void openCategoriesView(ArrayList<NRFAQGroupItem> groups) {

        categoriesView = new NRCategoriesView(getActivity());

        if (Nanorep.getInstance().getAccountParams().isLabelsMode()) {
            categoriesView.setLabels(NRMainFragment.this);
        } else {
            categoriesView.setCategories(groups, viewAdapter, NRMainFragment.this);
        }


        contentMain.addView(categoriesView);
    }

    private NRArticleView getTopView() {

        NRArticleView resultTopView = new NRArticleView(getActivity(), viewsProvider);
        resultTopView.setListener(this);
        NRCustomTitleView titleView = viewAdapter.getTitle(getContext());

        if (titleView == null) {
            titleView = new NRTitleView(getContext());
            ((NRTitleView) titleView).configViewObjects(configuration);
        }

        NRCustomContentView contentView = viewAdapter.getContent(getContext());

        if (contentView == null) {
            contentView = new NRContentView(getContext());
        }

        if (applicationContentListener != null) {
            contentView.setApplicationContentListener(applicationContentListener);
        }

        likeView = viewAdapter.getLikeView(getContext());

        if (likeView == null) {
            likeView = new NRLikeViewText(getContext(), viewsProvider);
        }

        channelView = viewAdapter.getChannelView(getContext());

        if (channelView == null) {
            channelView = new NRChannelingView(getContext(), viewsProvider);
        }

        NRCustomFeedbackView feedbackView = viewAdapter.getFeedbackView(getContext());

        resultTopView.setTitleView(titleView);
        resultTopView.setContentView(contentView, this);


        if (feedbackView != null) {
            feedbackView.setCustomChannelView(channelView);
            feedbackView.setCustomLikeView(likeView);
            resultTopView.setLikeView(feedbackView.getCustomLikeView());
            resultTopView.setChannelView(feedbackView.getCustomChannelView(), this);
            resultTopView.setFeedbackView(feedbackView);
        } else {
            resultTopView.setLikeView(likeView);
            resultTopView.setChannelView(channelView, this);
        }

        return resultTopView;
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        configuration = Nanorep.getInstance().getNRConfiguration();
        widgetListener = Nanorep.getInstance().getWidgetListener();

        if (viewAdapter == null) {
            viewAdapter = new NRViewAdapter(viewsProvider);
        }

        NRErrorHandler.getInstance().setListener(this);
        View view = inflater.inflate(R.layout.fragment_main, container, false);
        mLoadingView = view.findViewById(R.id.fragment_place_holder);
        contentMain = view.findViewById(R.id.content_main);
        fragmentMainLayout = view.findViewById(R.id.fragment_main_layout);
        noConnectionView = view.findViewById(R.id.noConnectionView);
        searchContextTextView = view.findViewById(R.id.user_selected_context_textview);
        clearContextButton = view.findViewById(R.id.clear_user_selected_button);
        searchContextLayout = view.findViewById(R.id.current_user_selected_context_layout);
        noResultsChannelingRecycler = view.findViewById(R.id.channelingView);

        clearContextButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onClearClicked(true);
                mFetchedDataManager.clearSearchContext();
                searchContextValue = "";
                searchContextLayout.setVisibility(View.GONE);
                if (contentMain.getChildCount() > 1) {
                    removeTopView();
                }
            }
        });

        setViews(view);
        initDataManager();
        return view;
    }

    private void clearContextFromSession() {
        searchContextLayout.setVisibility(View.GONE);

        Nanorep.getInstance().setContext(null, new OnDataResponse<DefaultResponse>() {
            @Override
            public void onSuccess(DefaultResponse response) {
                Log.d("ClearContext", "Context cleared successfully");
                searchContextValue = "";
                mFetchedDataManager.clearSearchContext();
            }

            @Override
            public void onError(NRConnectionException error) {
                Log.d("ClearContext", "Error on clearing Context");

            }
        });
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = configuration.getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = configuration.getSearchBar();

        searchBarView.setHint(searchBarConfig.getInitialText());
        String titleBGColor;

        // titleConfig color
        if (!isEmpty(titleConfig.getTitleBGColor())) {
            titleBGColor = titleConfig.getTitleBGColor();
        } else {
            titleBGColor = "#0aa0ff";
        }

        searchBarContainer.setBackgroundColor(Color.parseColor(titleBGColor));
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = configuration.getTitle();
        ActionBar actionBar = ((AppCompatActivity) getActivity()).getSupportActionBar();
        if (actionBar == null) {
            return;
        }

        View customActionBar = getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
        ActionBar.LayoutParams layout = new ActionBar.LayoutParams(ActionBar.LayoutParams.MATCH_PARENT, ActionBar.LayoutParams.MATCH_PARENT);

        actionBar.setCustomView(customActionBar, layout);
        actionBar.setDisplayShowHomeEnabled(false);
        actionBar.setDisplayShowTitleEnabled(false);
        actionBar.setDisplayShowCustomEnabled(true);

        Toolbar parent = (Toolbar) customActionBar.getParent();
        parent.setPadding(0, 0, 0, 0);//for tab otherwise give space in tab
        parent.setContentInsetsAbsolute(0, 0);

        actionBarTextView = actionBar.getCustomView().findViewById(R.id.titleBarTv);


        // titleConfig text
        String titleText = configuration.getTitleText();
        setActionBarTitleText(titleText);
//        actionBarTextView.setText(titleText);

        // titleConfig color
        if (!isEmpty(title.getTitleColor())) {
            String titleColor = title.getTitleColor();
            actionBarTextView.setTextColor(Color.parseColor(titleColor));
        }

        // titleConfig background color
        if (!isEmpty(title.getTitleBGColor())) {
            String titleBGColor = title.getTitleBGColor();
            RelativeLayout relativeLayout = actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
            relativeLayout.setBackgroundColor(Color.parseColor(titleBGColor));
        }

        // titleConfig font
        if (!isEmpty(title.getTitleFont())) {
            String titleFont = title.getTitleFont();
            actionBarTextView.setTypeface(Typeface.create(titleFont, Typeface.NORMAL));
        }
    }

    private void setActionBarTitleText(String title) {
        if (getActivity() != null) {
            ActionBar actionBar = ((AppCompatActivity) getActivity()).getSupportActionBar();

            if (actionBar == null) {
                return;
            }

            String fixedTitle = Nanorep.getInstance().getAccountParams().getFixedTitle();

            TextView tv = actionBar.getCustomView().findViewById(R.id.titleBarTv);
            tv.setText(fixedTitle != null ? fixedTitle : title);
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }


    private void setViews(View nanoView) {
        // suggestion view
        mSuggestionViewContainer = nanoView.findViewById(R.id.suggestion_view_container);

        mSuggestionsView = viewAdapter.getSuggestionsView(getContext());

        if (mSuggestionsView == null) {
            mSuggestionsView = new NRSuggestionsView(getContext());
        }

        mSuggestionsView.setListener(this);

        if (mSuggestionsView.getParent() != null) {
            ((LinearLayout) mSuggestionsView.getParent()).removeView(mSuggestionsView);
        }

        mSuggestionViewContainer.addView(mSuggestionsView);


        // search bar
        searchBarContainer = nanoView.findViewById(R.id.search_bar_container);


        searchBarView = viewAdapter.getSearchBar(getContext());

        if (searchBarView == null) {
            searchBarView = new NRSearchBar(getContext());
        }

        searchBarView.setListener(this);

        if (searchBarView.getParent() != null) {
            ((LinearLayout) searchBarView.getParent()).removeView(searchBarView);
        }

        searchBarContainer.addView(searchBarView, new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT));
    }


    @Override
    public void onStartRecording(ImageButton button) {

    }

    @Override
    public void fetchSuggestionsForText(String text) {
        hideNoResultsView();

        resetSuggestions = false;
        mFetchedDataManager.searchSuggestion(text);
    }

    @Override
    public void searchForText(String text) {
        resetSuggestions = true;
       clearSuggestionsView();

        mFetchedDataManager.searchText(text);
    }

    @Override
    public void onClearClicked(boolean byUser) {
        resetSuggestions = true;
        clearSuggestionsView();

        while (contentMain.getChildCount() > 1) {
            contentMain.removeViewAt(contentMain.getChildCount() - 1);
        }
        String titleText = configuration.getTitleText();
        setActionBarTitleText(titleText);
        // show content
        clearContextFromSession();
        contentMain.setVisibility(View.VISIBLE);
        setLoadingState(false);
    }

    @Override
    public void clearAutoComplete() {
        clearSuggestionsView();
        contentMain.setVisibility(View.VISIBLE);
    }

    @Override
    public void onEmptyQuery() {

    }

    private void hideNoResultsView() {
//        noSearchResultView.setVisibility(View.GONE);
    }

    @Override
    public void onSelectSuggestion(String suggestion) {
        resetSuggestions = true;

        searchBarView.dismissKeyboard();
        searchBarView.updateEditTextView(suggestion);

        resetSuggestions = true;
        mFetchedDataManager.searchText(suggestion);
        clearSuggestionsView();
    }

    private void showSuggestionsView() {
        if (!configuration.getAutocompleteEnabled()) {
            autocompleteEnabled = false;
        }
    }

    @Override
    public void onResultSelected(final int y, NRResultsAdapter.ViewHolder titleViewHolder) {
        if (isBouncing()) {
            return;
        }
        setLoadingState(true);
        hideKeyboard();
        final NRArticleView resultTopView = getTopView();
        final NRResult result = titleViewHolder.getResult();

        String title = "";
        if (currentLabel != null) {
            title = currentLabel.getTitle();
        } else if (result.getFetchedResult() != null) {
            title = result.getFetchedResult().getTitle();
        }

        searchBarView.showLabelLayout(true, title);

        if (result.getFetchedResult().getBody() == null) {
            this.articleId = result.getFetchedResult().getId();
            mFetchedDataManager.faqAnswer(result.getFetchedResult().getId(), null, new OnFAQAnswerFetched() {
                @Override
                public void onAnswerFetched(NRQueryResult queryResult) {
                    if (queryResult != null) {
                        resultTopView.setVisibility(View.GONE);
                        contentMain.addView(resultTopView);
                        result.setFetchedResult(queryResult);
                        presentResult(result, y, resultTopView);
                    } else {
                        show(NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE);
                    }
                }
            });
        } else {
            resultTopView.setVisibility(View.GONE);
            contentMain.addView(resultTopView);
            presentResult(result, y, resultTopView);
        }
    }

    private void presentResult(NRResult result, int y, NRArticleView resultTopView) {
        if (getContext() == null) {
            return;
        }

        setLoadingState(false);

        result.setUnfolded(true);
        resultTopView.setVisibility(View.VISIBLE);
        resultTopView.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_in_left));
        if (result.getFetchedResult() == null) {
            resultTopView.showNoResult(result);
        } else {
            resultTopView.openOpenedView(result);
        }
        requestFocus();
    }

    private void requestFocus() {
        if (getView() != null) {
            getView().requestFocus();
        }
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (getView() != null) {
            getView().setFocusableInTouchMode(true);
            getView().requestFocus();
        }
        onKeyListener = new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == KeyEvent.ACTION_DOWN) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                        hideNoResultsView();

                        if (NRMainFragment.this.getFragmentManager().getBackStackEntryCount() == 1) {
                            // channel is opened

                            NRMainFragment.this.getFragmentManager().popBackStack();
                            return true;

                        } else if (mSuggestionViewContainer.getVisibility() == View.VISIBLE) {
                            resetSuggestions = true;
                            clearSuggestionsView();
                            contentMain.setVisibility(View.VISIBLE);
                            return true;
                        } else if (contentMain.getChildCount() > 1) {

                            // get the last view
                            View view = contentMain.getChildAt(contentMain.getChildCount() - 1);

                            if (!animation) {
                                if (view instanceof NRArticleView) {
                                    if (currentLabel != null) {
                                        view.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_out_left));
                                        searchBarView.showLabelLayout(true, currentLabel.getTitle());
                                    } else if (!searchContextValue.isEmpty()){
                                        searchContextLayout.setVisibility(View.VISIBLE);
                                        searchContextTextView.setText(searchContextValue);
                                    }
                                } else if (view instanceof NRResultsView) {
                                    searchBarView.showLabelLayout(false, "");
                                    searchBarView.updateEditTextView("");
                                }

                                removeTopView();

                            } else { // if answer is opened from list, it should be animated
                                if (view instanceof NRArticleView) {// &&
                                    if (!((NRArticleView) view).getmResult().isSingle()) { // opened from results lists)
                                        ((NRArticleView) view).setResultUnFoldState(false);
                                        ((NRArticleView) view).removeTopView();

                                        updateSearchBarTextForResultTop(view);

                                    } else {
                                        view.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_out_left));
                                        removeTopView();
                                    }

                                } else {

                                    removeTopView();
                                }
                            }

                            return true;
                        } else {
                            return false;
                        }

                    } else { // if (keyCode == KeyEvent.KEYCODE_BACK)
                        return false;
                    }
                } else { // if (event.getAction() == KeyEvent.ACTION_DOWN)
                    return false;
                }
            }
        };

        if (getView() != null) {
            getView().setOnKeyListener(onKeyListener);
        }
    }

    private void removeTopView() {
        noConnectionView.setVisibility(View.GONE);
        if (contentMain.getChildCount() == 2 && currentLabel != null) {

            clearContextFromSession();
            currentLabel = null;
        }

        contentMain.removeViewAt(contentMain.getChildCount() - 1);

        View currentView = contentMain.getChildAt(contentMain.getChildCount() - 1);
        currentView.setVisibility(View.VISIBLE);
        if (currentView instanceof NRArticleView) {

            updateSearchBarTextForResultTop(currentView);
        } else {
            searchBarView.updateEditTextView("");
            requestFocus();

            String title = configuration.getTitleText();

            if (currentView instanceof NRResultsView) {
                if (!isEmpty(((NRResultsView) currentView).getTitle())) {
                    title = ((NRResultsView) currentView).getTitle();
                }
                resultsView.enableAdapterClicks(true);
            }

            if (currentView instanceof NRCategoriesView) {
                categoriesView.enableAdapterClicks(true);
            }

            setActionBarTitleText(currentLabel == null ? title : currentLabel.getTitle());
        }
        setLoadingState(false);
    }

    private void updateSearchBarTextForResultTop(View view) {
        if (((NRArticleView) view).getmResult() != null && ((NRArticleView) view).getmResult().getFetchedResult() instanceof NRAnswer) {
            searchBarView.updateEditTextView(((NRArticleView) view).getmResult().getFetchedResult().getTitle());
            resetSuggestions = true;
            clearSuggestionsView();
            contentMain.setVisibility(View.VISIBLE);
            requestFocus();
        }
    }

    private void clearSuggestionsView() {
        mSuggestionsView.setSuggestions(null);
        mSuggestionViewContainer.setVisibility(View.GONE);
    }

    private void fadeViews(View view, final float f, long duration, final boolean removeTopTitle) {
        view.animate()
                .alpha(f)
                .setDuration(duration)
                .setListener(new Animator.AnimatorListener() {
                    @Override
                    public void onAnimationStart(Animator animation) {

                    }

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        if (removeTopTitle) {
                            contentMain.removeViewAt(contentMain.getChildCount() - 1);
                        }
                    }

                    @Override
                    public void onAnimationCancel(Animator animation) {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation) {

                    }
                });
    }

    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) {
        if (beforeGoingDown) {
            animateBGColor(50, contentMain.getChildAt(contentMain.getChildCount() - 1), false, null);

        } else {
            fadeViews(contentMain.getChildAt(contentMain.getChildCount() - 1), 0.0f, 500, true);
        }
    }

    private void animateBGColor(int milliseconds, final View view, final boolean unfold, final NRResultsAdapter.ViewHolder titleViewHolder) {

        int colorFrom = getResources().getColor(R.color.nr_background_color);
        int colorTo = getResources().getColor(R.color.white);

        if (!unfold) {
            colorFrom = Color.WHITE;
            colorTo = getResources().getColor(R.color.nr_background_color);
        }

        ValueAnimator colorAnimation = ValueAnimator.ofObject(new ArgbEvaluator(), colorFrom, colorTo);
        colorAnimation.setDuration(milliseconds); // milliseconds
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {

            @Override
            public void onAnimationUpdate(ValueAnimator animator) {
                view.setBackgroundColor((int) animator.getAnimatedValue());
            }

        });

        colorAnimation.addListener(new Animator.AnimatorListener() {
            @Override
            public void onAnimationStart(Animator animation) {

            }

            @Override
            public void onAnimationEnd(Animator animation) {
                if (unfold) {
//                    titleViewHolder.getTitleView().setVisibility(View.VISIBLE);
                }
            }

            @Override
            public void onAnimationCancel(Animator animation) {

            }

            @Override
            public void onAnimationRepeat(Animator animation) {

            }
        });

        if (unfold) {
            colorAnimation.setStartDelay(300);
        }
        colorAnimation.start();
    }

    @Override
    public void show(NRErrorHandler.ErrorType errorType) { // error handler
        switch (errorType) {
            case TIMEOUT_UPPER_LINE:
                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (!(view instanceof NRErrorView)) {
                    noConnectionView.setVisibility(View.VISIBLE);
                    searchBarView.dismissKeyboard();
                }
                break;
        }

    }

    @Override
    public void dismiss() {
        if (noConnectionView == null) {
            return;
        }
        noConnectionView.setVisibility(View.GONE);
    }

    @Override
    public void onLabelSelected(final NRLabel label) {
        if (isBouncing()) {
            return;
        }
        setLoadingState(true);
        this.currentLabel = label;

//        if (actionBarTextView != null) {
//            setTitleText(label.getTitle());
//        }
        Nanorep.getInstance().setContext(label.getContext(), new OnDataResponse<DefaultResponse>() {
            @Override
            public void onSuccess(DefaultResponse response) {
                mFetchedDataManager.fetchLabelFAQ(label, searchBarView);
            }

            @Override
            public void onError(NRConnectionException error) {
                show(NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE);
            }
        });
    }

    private boolean isBouncing() {
        long currentTime = System.currentTimeMillis();
        final long threshold = 300;
        if (currentTime - this.previousClickTime < threshold) {
            return true;
        }
        this.previousClickTime = currentTime;
        return false;
    }

    @Override
    public void onCategorySelected(NRFAQGroupItem groupItem) {
        if (isBouncing()) {
            return;
        }
        setLoadingState(true);
        openNRResultView(NRFetchedDataManager.generateNRResultArray(groupItem.getAnswers(), getContext()), groupItem.getTitle());
    }

    private void openNRResultView(List<NRResult> results, String title) {
        try {
            setLoadingState(false);
            resultsView = new NRResultsView(getActivity());
            resultsView.setListener(NRMainFragment.this);
            resultsView.setResults(results, title, viewAdapter);
            resultsView.setIsAnimated(animation);
            resultsView.enableAdapterClicks(true);

            if (!isEmpty(title)) {
                setActionBarTitleText(title);
            }

            contentMain.addView(resultsView);

            requestFocus();
        } catch (Exception e) {

        }
    }


    private void setLoadingState(boolean state) {
        if (contentMain.getChildCount() == 0) {
            return;
        }

        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
        if (view instanceof NRCategoriesView) {
            ((NRCategoriesView) view).setLoading(state);
        } else if (view instanceof NRResultsView) {
            ((NRResultsView) view).setLoading(state);
        }
    }


}