package nanorep.nanowidget.DataClass;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import nanorep.nanowidget.Components.NRCategoriesView;
import nanorep.nanowidget.interfaces.CRUDAdapterInterface;

import com.nanorep.nanoclient.Response.NRFAQGroupItem;

import java.util.ArrayList;
import java.util.List;

import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;

public class NRCategoriesAdapter extends NRBaseAdapter<NRCategoriesAdapter.ViewHolder>
        implements CRUDAdapterInterface<NRFAQGroupItem> {
    private ArrayList<NRFAQGroupItem> mGroupResults;
    private NRCustomViewAdapter viewAdapter;
    private NRCategoriesView.Listener listener;

    public NRCategoriesAdapter() {
//        enableClicks = true;
        this.mGroupResults = new ArrayList<NRFAQGroupItem>();
    }

    public class ViewHolder extends RecyclerView.ViewHolder implements View.OnClickListener {
        private TextView textView;

        public ViewHolder(View view) {
            super(view);
            view.findViewById(R.id.titleLayout).setOnClickListener(this);
            textView = (TextView) view.findViewById(R.id.titleTextView);
        }

        @Override
        public void onClick(View v) {
            if (enableClicks) {
                enableClicks = false;
                showItem(mGroupResults.get(getAdapterPosition()), getAdapterPosition());
            }
        }
    }

    @Override
    public NRCategoriesAdapter.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Context context = parent.getContext();
        View view = LayoutInflater.from(context).inflate(R.layout.title_item_label, parent, false);
        view.findViewById(R.id.label_image).setVisibility(View.GONE);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(NRCategoriesAdapter.ViewHolder holder, final int position) {
        final NRFAQGroupItem groupItem = getItem(position);
        holder.textView.setText(groupItem.getTitle());
    }

    @Override
    public int getItemViewType(int position) {
        return 0;
    }

    @Override
    public int getItemCount() {

        return mGroupResults.size();
    }

    @Override
    public NRFAQGroupItem getItem(int position) {
        return mGroupResults.get(position);
    }

    @Override
    public void addItem(NRFAQGroupItem item) {

    }

    @Override
    public void removeItem(NRFAQGroupItem item) {

    }

    @Override
    public void addItems(List<NRFAQGroupItem> items) {
        mGroupResults.addAll(items);
        notifyDataSetChanged();
    }

    @Override
    public void clearList() {

    }

    @Override
    public void updateItem(int pos, NRFAQGroupItem item) {

    }

    @Override
    public void showItem(NRFAQGroupItem item, int itemPosition) {
        listener.onCategorySelected(item);
    }

    @Override
    public List<NRFAQGroupItem> getItems() {
        return null;
    }

    @Override
    public void removeItem(int currentItemPosition) {

    }

    public void setListener(NRCategoriesView.Listener listener) {
        this.listener = listener;
    }

    public void setViewAdapter(NRCustomViewAdapter viewAdapter) {
        this.viewAdapter = viewAdapter;
    }
}