package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageButton;

import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRConfiguration;

import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchViewsProvider;

/**
 * Created by obenoved on 07/01/18.
 */
public class NRLikeViewIcons extends NRCustomLikeView {

    private ImageButton mLikeButton;
    private ImageButton mDislikeButton;
    private boolean mLikeSelection;

    public NRLikeViewIcons(Context context, SearchViewsProvider searchViewsProvider) {
        super(context);
        if (searchViewsProvider != null) {
            LayoutInflater.from(context).inflate(searchViewsProvider.getLikeViewLayout(), this);
        } else {
            LayoutInflater.from(context).inflate(R.layout.like_view_icons, this);
        }
    }

    @Override
    public void updateLikeButton(boolean isLike) {
        resetLikeView();
        if (isLike) {
            mLikeButton.setImageDrawable(ContextCompat.getDrawable(getContext(), R.drawable.like));
//            mDislikeButton.setImageDrawable(ContextCompat.getDrawable(getContext(), R.drawable.ic_thumb_down_black_24dp));
            mLikeButton.setSelected(true);
        } else {
//            mLikeButton.setImageDrawable(ContextCompat.getDrawable(getContext(), R.drawable.ic_thumb_up_black_24dp));
            mDislikeButton.setImageDrawable(ContextCompat.getDrawable(getContext(), R.drawable.dislike));
            mDislikeButton.setSelected(true);
        }
        mDislikeButton.setEnabled(false);
        mLikeButton.setEnabled(false);
        mLikeSelection = isLike;
    }

    @Override
    public void resetLikeView() {
        mDislikeButton.setEnabled(true);
        mLikeButton.setEnabled(true);
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);
        mLikeButton = findViewById(R.id.fragment_article_positiveFeedback_button);
        mDislikeButton = findViewById(R.id.fragment_article_negativeFeedback_button);

        mLikeButton.setImageDrawable(ContextCompat.getDrawable(getContext(), R.drawable.like));
        mDislikeButton.setImageDrawable(ContextCompat.getDrawable(getContext(), R.drawable.dislike));

        mLikeButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                sendSelection(true);
            }
        });
        mDislikeButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                sendSelection(false);
            }
        });
    }

    private void sendSelection(boolean selection) {
        mLikeSelection = selection;
        updateLikeButton(mLikeSelection);
        mListener.onLikeClicked(NRLikeViewIcons.this, null, mLikeSelection);
    }

    @Override
    public boolean getLikeSelection() {
        return mLikeSelection;
    }

    @Override
    public boolean shouldOpenDialog() {
        return Nanorep.getInstance().getNRConfiguration().getFeedbackDialogType() != NRConfiguration.NO_FEEDBACK_DIALOG_TYPE;
    }
}
