package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;

import android.view.LayoutInflater;
import android.view.View;

import com.nanorep.nanoclient.Channeling.NRChanneling;
import java.util.List;

import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchViewsProvider;


public class NRChannelingView extends NRCustomChannelView {

    private RecyclerView mChannelingsRecycleView;

    public NRChannelingView(Context context, SearchViewsProvider viewsProvider) {
        super(context, viewsProvider);
        LayoutInflater.from(context).inflate(viewsProvider.getChannelingLayout(), this);
    }

    @Override
    public void setChanneling(List<NRChanneling> channeling) {
        mChannelings = channeling;
        LinearLayoutManager manager = new mLinearLayoutManager(getContext(), LinearLayoutManager.HORIZONTAL, false);
        mChannelingsRecycleView.setLayoutManager(manager);
        mAdapter.notifyDataSetChanged();
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);
        mChannelingsRecycleView = child.findViewById(R.id.channelingTabs);
        mChannelingsRecycleView.setAdapter(mAdapter);
    }

    @Override
    public void onChannelSelected(NRChanneling channeling) {
        mListener.onChannelSelected(channeling);
    }

    class mLinearLayoutManager extends LinearLayoutManager{


        public mLinearLayoutManager(Context context, int orientation, boolean reverseLayout) {
            super(context, orientation, reverseLayout);
        }

        @Override
        public boolean canScrollHorizontally() {
            return mChannelings.size() >= 2;
        }
    }

}
