package nanorep.nanowidget.Fragments;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Toast;

import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Channeling.*;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRExtraDataListener;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.network.OnDataResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.DislikeConfiguration;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.NRCustomDislikeDialog;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresentor;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.ChannelPresenters.NRCustomScriptChannelPresentor;
import nanorep.nanowidget.Components.ConfirmationDialogFragment;
import nanorep.nanowidget.Components.MyWebView;
import nanorep.nanowidget.Components.NRArticleView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRLikeViewText;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRTitleView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.DislikeDialogListener;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

import static com.nanorep.nanoclient.Channeling.NRChanneling.NRChannelingType.PhoneNumber;
import static com.nanorep.nanoclient.Response.NRConfiguration.NO_FEEDBACK_DIALOG_TYPE;
import static nanorep.nanowidget.Components.AbstractViews.dislikeDialog.NRCustomDislikeDialog.TAG;

/**
 * Created by obenoved on 14 Feb 2018.
 */

public class DeepLinkFragment extends Fragment
        implements NRArticleView.Listener, NRErrorHandler.Listener, NRChannelItem.OnChannelSelectedListener, NRContentView.Listener, Nanorep.NanoRepWidgetListener {
    private static final String ARTICLE_ID = "articleId";

    private FrameLayout contentMain;
    private NRCustomViewAdapter viewAdapter;
    private NRFetchedDataManager mFetchedDataManager;
    private NRConfiguration configuration;
    private LinearLayout noConnectionView;
    private NRCustomChannelView channelView;
    private String articleId;
    private static AccountParams accountParams;

    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }

    private SearchViewsProvider viewsProvider;

    public void setArticleId(String articleId) {
        this.articleId = articleId;
    }

    public void setAccountParams(AccountParams accountParams) {
        DeepLinkFragment.accountParams = accountParams;
    }

    public static DeepLinkFragment newInstance(String articleId, AccountParams accountParams, SearchInjector searchInjector) {
        DeepLinkFragment fragment = new DeepLinkFragment();

        SearchViewsProvider viewsProvider = searchInjector.getUiProvider();

        fragment.setViewsProvider(viewsProvider == null ? new SearchInjector.DefaultsInjector().getUiProvider() : viewsProvider);
        fragment.setArticleId(articleId);
        fragment.setAccountParams(accountParams);

        return fragment;
    }

    private void initDataManager() {
        mFetchedDataManager = new NRFetchedDataManager(getContext(), new NRConfigFetcherListener() {
            @Override
            public void onConfigurationReady() {
            }

            @Override
            public void insertRows(ArrayList<NRFAQGroupItem> groups) {

            }

            @Override
            public void onError() {

            }

            @Override
            public void noResultFound(NRResult response) {

            }
        });
    }


    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_deeplink, container, false);


        Nanorep.initialize(accountParams, DeepLinkFragment.this);
        Nanorep.getInstance().setHttpRequestTimeout(15);


        noConnectionView = (LinearLayout) view.findViewById(R.id.noConnectionView);
        contentMain = (FrameLayout) view.findViewById(R.id.content_main);

        viewAdapter = new NRViewAdapter(viewsProvider);

        articleId = getArguments().getString(ARTICLE_ID);

        return view;
    }

    private NRArticleView getTopView() {

        NRArticleView resultTopView = new NRArticleView(getActivity(), viewsProvider);
        resultTopView.setListener(this);

        NRCustomTitleView titleView = viewAdapter.getTitle(getContext());

        if (titleView == null) {
            titleView = new NRTitleView(getContext());
            ((NRTitleView) titleView).configViewObjects(configuration);
        }

        NRCustomContentView contentView = viewAdapter.getContent(getContext());

        if (contentView == null) {
            contentView = new NRContentView(getContext());
        }


        NRCustomLikeView likeView = viewAdapter.getLikeView(getContext());

        if (likeView == null) {
            likeView = new NRLikeViewText(getContext(), viewsProvider);
        }

        channelView = viewAdapter.getChannelView(getContext());

        if (channelView == null) {
            channelView = new NRChannelingView(getContext(), viewsProvider);
        }

        NRCustomFeedbackView feedbackView = viewAdapter.getFeedbackView(getContext());

        resultTopView.setTitleView(titleView);
        resultTopView.setContentView(contentView, this);


        if (feedbackView != null) {
            feedbackView.setCustomChannelView(channelView);
            feedbackView.setCustomLikeView(likeView);
            resultTopView.setLikeView(feedbackView.getCustomLikeView());
            resultTopView.setChannelView(feedbackView.getCustomChannelView(), this);
            resultTopView.setFeedbackView(feedbackView);
        } else {
            resultTopView.setLikeView(likeView);
            resultTopView.setChannelView(channelView, this);
        }

        return resultTopView;
    }

    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) {

    }

    @Override
    public void fetchBodyForResult(final NRCustomContentView view, String resultID, Integer resultHash) {
        this.articleId = resultID;
        mFetchedDataManager.faqAnswer(resultID, resultHash, new OnFAQAnswerFetched() {
            @Override
            public void onAnswerFetched(NRQueryResult result) {
                if (result != null) {
                    view.loadData(result.getBody(), "text/html", "UTF-8");
                }
            }
        });
    }

    @Override
    public void closeAnswer() {
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
            if (view instanceof NRArticleView && !((NRArticleView) view).getmResult().isSingle()) {
                ((NRArticleView) view).setResultUnFoldState(false);
                ((NRArticleView) view).removeTopView();
        }

        contentMain.removeView(view);
    }

    @Override
    public void onLikeClicked(final NRArticleView view, final NRCustomLikeView likeView, String resultId, boolean isLike) {
        final NRQueryResult result = view.getmResult().getFetchedResult();

        if (isLike) {
            result.setLikeState(NRQueryResult.LikeState.positive);
            mFetchedDataManager.sendLike(NRLikeType.POSITIVE, "", result, new Nanorep.OnLikeSentListener() {
                @Override
                public void onLikeSent(boolean success) {
                    if (!success) {
                        view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                        likeView.resetLikeView();
                    } else {
                        View view = getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                        new ConfirmationDialogFragment(getContext(), view,configuration.getFeedbackConfirmationDialogBody() ,configuration.getFeedbackConfirmationDialogButton() ,configuration.getFeedbackConfirmationDialogTitle());
                    }
                }
            });
        } else {
            if (likeView.shouldOpenDialog()) {
                openDislikeDialog(result, view, likeView);
            } else {
                onDislike(result, view, likeView, NRLikeType.INCORRECT_ANSWER, "");
            }
        }
    }

    private void openDislikeDialog(final NRQueryResult result, final NRArticleView view, final NRCustomLikeView likeView) {
        // String reasons[] = new String[]{getString(R.string.missing_information), getString(R.string.didnt_find)};
        int dialogType = configuration.getFeedbackDialogType();
        if (dialogType != NO_FEEDBACK_DIALOG_TYPE) {
            final View dislikeView = getActivity().getLayoutInflater().inflate(R.layout.dislike_dialog_mixed, null);

            NRCustomDislikeDialog dislikeDialog = viewsProvider.getDislikeDialog(new DislikeConfiguration(configuration) {
                @Override
                public DislikeDialogListener getDislikeDialogListener() {
                    return new DislikeDialogListener() {
                        @Override
                        public void onCancel() {
                            likeView.resetLikeView();
                            onDismissDislike();
                        }

                        @Override
                        public void onDislike(NRLikeType type, String feedbackText) {
                            DeepLinkFragment.this.onDislike(result, view, likeView, type, feedbackText);
                        }
                    };
                }
            });
            dislikeDialog.show(getFragmentManager(), TAG);
        }
    }
    private void onDismissDislike() {
        // update channeling
        Nanorep.getInstance().getChanneling(articleId, false, new OnDataResponse<List<NRChanneling>>() {
            @Override
            public void onSuccess(List<NRChanneling> response) {

                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (view instanceof NRArticleView) {
                    NRQueryResult fetchedResult = ((NRArticleView) view).getmResult().getFetchedResult();
                    for (NRChanneling channel : response) {
                        channel.setQueryResult(fetchedResult);
                    }
                }
                channelView.setVisibility(View.VISIBLE);
                channelView.setChanneling(response);
            }

            @Override
            public void onError(NRConnectionException error) {
                Log.e("updateChanneling", "error on updateChanneling: " + error.getData());
                channelView.setVisibility(View.GONE);
            }
        });
    }
    private void onDislike(NRQueryResult result, final NRArticleView view, final NRCustomLikeView likeView, NRLikeType type, String feedbackText) {
        result.setLikeState(NRQueryResult.LikeState.negative);
        mFetchedDataManager.sendLike(type, feedbackText, result, new Nanorep.OnLikeSentListener() {
            @Override
            public void onLikeSent(boolean success) {
                if (!success) {
                    view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                    Toast.makeText(getContext(), getResources().getString(R.string.feedback_error_message), Toast.LENGTH_LONG).show();
                    removeTopView();
                } else {
                    View view = getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                    new ConfirmationDialogFragment(getContext(), view,configuration.getFeedbackConfirmationDialogBody() ,configuration.getFeedbackConfirmationDialogButton() ,configuration.getFeedbackConfirmationDialogTitle());
                }
            }
        });
    }

    @Override
    public void show(NRErrorHandler.ErrorType errorType) {
        switch (errorType) {
            case TIMEOUT_UPPER_LINE:
                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (!(view instanceof NRErrorView)) {
                    noConnectionView.setVisibility(View.VISIBLE);
                }
                break;
        }
    }

    @Override
    public void dismiss() {
        if (noConnectionView == null) {
            return;
        }
        noConnectionView.setVisibility(View.GONE);
    }

    @Override
    public void onChannelSelected(final NRChanneling channel) {
        String extraData;
        NRQueryResult currentResult = getCurrentResult();
        if (currentResult == null || currentResult.getExtraData() == null) {

            if(channel.getNoResultExtra() == null) {
                openChannel(channel);
                return;
            }
            extraData = channel.getNoResultExtra();
        }
        else {
            extraData = getCurrentResult().getExtraData();
        }

        Nanorep.getInstance()
                .getWidgetListener()
                .personalInfoWithExtraData(
                        channel.getChannelDescription(),
                        extraData,
                        new NRExtraDataListener() {
                            @Override
                            public void onExtraData(Map<String, String> extraData) {
                                channel.setExtraData(extraData);
                                openChannel(channel);
                            }
                        });
    }

    private void openChannel(NRChanneling channeling) {

        NRChannelPresentor presentor = NRChannelStrategy.presentor(getContext(), channeling, Nanorep.getInstance());

        if (presentor instanceof NRCustomScriptChannelPresentor) {

            presentor.present();

        } else {

            String url = presentor.getUrl();
            if (url != null) {
                final RelativeLayout holder = (RelativeLayout) getView().findViewById(R.id.fragment_place_holder);
                holder.setVisibility(View.VISIBLE);
                NRWebContentFragment webContentFragment = NRWebContentFragment.newInstance(url, channeling.getThankYouMessage(), configuration.getFeedbackConfirmationDialogTitle(),configuration.getFeedbackConfirmationDialogButton());
                webContentFragment.setListener(new NRWebContentFragment.WebFormListener() {
                    @Override
                    public void onDismiss(String result) {
                        if (result==null){
                            getFragmentManager().popBackStack();
                        }
                        InputMethodManager imm = (InputMethodManager) getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
                        imm.hideSoftInputFromWindow(getView().getWindowToken(), 0);
                        requestFocus();
                    }
                });
                getFragmentManager()
                        .beginTransaction()
                        .setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out)
                        .add(R.id.content_main, webContentFragment)
                        .addToBackStack("linked").commit();
            } else if (channeling.getType() == PhoneNumber) {
                String phoneNumber = ((NRChannelingPhoneNumber) channeling).getPhoneNumber();
                String channelName = ((NRChannelingPhoneNumber) channeling).getName();
                Intent intent = new Intent(Intent.ACTION_DIAL, Uri.fromParts("tel", phoneNumber, null));
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
                try {
                    startActivity(intent);
                } catch (ActivityNotFoundException ignored) {

                }
                Nanorep.getInstance().reportChanneling(articleId, "5", channelName);
            }
        }
    }


    private void requestFocus() {
        if (getView() != null) {
            getView().requestFocus();
        }
    }

    private NRQueryResult getCurrentResult() {
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            return ((NRArticleView) view).getmResult().getFetchedResult();
        }
        return null;
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
        mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched() {
            @Override
            public void onAnswerFetched(final NRQueryResult result) {
                NRResult newResult = new NRResult(result, NRResultItem.RowType.TITLE);
                int height = Integer.valueOf(configuration.getTitle().getTitleRowHeight());
                newResult.setHeight((int) Calculate.pxFromDp(getContext(), height));
                newResult.setSingle(true);

                NRArticleView resultTopView = getTopView();
                contentMain.addView(resultTopView);

                resultTopView.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_in_left));

                resultTopView.openOpenedView(newResult);

                requestFocus();
            }
        });
    }

    @Override
    public void onLinkClicked(String url) {
        if (Nanorep.getInstance().getAccountParams().isOpenLinksInternally()) {
            MyWebView webView = new MyWebView(getContext(), url, new MyWebView.Listener() {
                @Override
                public void onDismiss() {
                    contentMain.removeViewAt(contentMain.getChildCount() - 1);
                    requestFocus();
                }
            });

            contentMain.addView(webView);
            requestFocus();
        } else {
            Intent intent = new Intent(Intent.ACTION_VIEW);
            intent.setData(Uri.parse(url));
            try {
                startActivity(intent);
            } catch (Exception e) {

            }
        }
    }

    @Override
    public void onDismiss() {
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);

        if (view instanceof NRArticleView) {
            view.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_out_left));
        }
        removeTopView();
    }

    private void removeTopView() {
        contentMain.removeViewAt(contentMain.getChildCount() - 1);
    }

    @Override
    public void personalInfoWithExtraData(String channelDescription, String extraData, NRExtraDataListener listener) {
        Map<String, String> map = new HashMap<>();
        listener.onExtraData(map);
    }

    @Override
    public void onSubmitSupportForm(String formData, ArrayList<String> fileUploadPaths) {

    }

    @Override
    public void onConfigurationFetched() {
        configuration = Nanorep.getInstance().getNRConfiguration();
        initDataManager();

        final NRArticleView resultTopView = getTopView();

        mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched() {
            @Override
            public void onAnswerFetched(NRQueryResult queryResult) {
                if (queryResult != null) {
                    NRResult deepLinkingResult = new NRResult(queryResult, null);

                    resultTopView.setResult(deepLinkingResult);
                    contentMain.addView(resultTopView);
                    resultTopView.openOpenedView(deepLinkingResult);
                } else {
                    show(NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE);
                }
            }
        });
    }

    @Override
    public void onCachedImageRequest(String url, Nanorep.NRCachedImageResponder responder) {

    }

    @Override
    public void onInitializationFailure() {

    }

    @Override
    public void onEmptyDataResponse() {

    }
}

