package nanorep.nanowidget.DataClass;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.DecelerateInterpolator;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.GetBinaryHttpTask;
import com.nanorep.nanoclient.network.GetHttpTask;
import com.nanorep.nanoclient.network.HttpResponse;
import com.nanorep.nanoclient.network.NetworkManager;
import com.nanorep.nanoclient.network.OnDataResponse;

import java.util.ArrayList;
import java.util.List;

import nanorep.nanowidget.Components.NRTitleView;
import nanorep.nanowidget.R;

/**
 * Created by Aviran Abady on 4/23/17.
 */

public class NRLabelsAdapter extends RecyclerView.Adapter<NRLabelsAdapter.ViewHolder> {

    private final NRLabelsListener listener;

    public interface NRLabelsListener {
        void onLabelSelected(NRLabel label);
    }

    private List<NRLabel> labels;

    public NRLabelsAdapter(NRLabelsListener listener) {
        this.listener = listener;
        labels = Nanorep.getInstance().getNRConfiguration().getLabels();
        if (labels == null) {
            labels = new ArrayList<>();
        }
    }

    @Override
    public NRLabelsAdapter.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Context context = parent.getContext();
        View view = LayoutInflater.from(context).inflate(R.layout.title_item_label, parent, false);
        return new ViewHolder(view);


    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {
        NRLabel label = labels.get(position);
        holder.textView.setText(label.getTitle());
        loadImage(holder.imageView, label.getIcon());
    }

    private void loadImage(final ImageView imageView, String url) {
        if(url == null || url.length() == 0) {
            return;
        }

        Nanorep.getInstance().getWidgetListener().onCachedImageRequest(url, new Nanorep.NRCachedImageResponder() {
            @Override
            public void onBitmapResponse(Bitmap bitmap) {
                if(bitmap != null) {
                    imageView.setImageBitmap(bitmap);
                }
            }
        });
//
//        new GetBinaryHttpTask(url, new GetBinaryHttpTask.HttpBinaryResponse() {
//            @Override
//            public void success(byte[] response) {
//                Bitmap b = convertToBitmap(response);
//
//            }
//
//            @Override
//            public void error() {
//
//            }
//        }).execute();
    }

//    public Bitmap convertToBitmap(byte[] bytes) {
//        try {
//            Bitmap bitmap = BitmapFactory.decodeByteArray(bytes, 0, bytes.length);
//            return bitmap;
//        } catch (OutOfMemoryError outOfMemoryError) {
//            return null;
//        }
//    }

    @Override
    public int getItemCount() {
        return labels.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder implements View.OnClickListener {
        public ImageView imageView;
        public TextView textView;

        public ViewHolder(View view) {
            super(view);
            view.findViewById(R.id.titleLayout).setOnClickListener(this);
            textView = view.findViewById(R.id.titleTextView);
            imageView = view.findViewById(R.id.label_image);

        }

        @Override
        public void onClick(View v) {
            listener.onLabelSelected(labels.get(getAdapterPosition()));
        }
    }
}