package nanorep.nanowidget.Components;

import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

import com.nanorep.nanoclient.RequestParams.NRLikeType;

import nanorep.nanowidget.Components.AbstractViews.ViewIdsFactory;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.DislikeConfiguration;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.NRCustomDislikeDialog;

import static com.nanorep.nanoclient.Response.NRConfiguration.MULTIPLE_CHOICE;
import static com.nanorep.nanoclient.Response.NRConfiguration.MULTIPLE_CHOICE_OPEN_TEXT;
import static com.nanorep.nanoclient.Response.NRConfiguration.OPEN_TEXT;

/**
 * Created by obenoved on 12/03/2018.
 */

public class NanorepDislikeDialog extends NRCustomDislikeDialog implements View.OnClickListener {

    private boolean isDismissHandled;
    private String feedbackText;

    private NRLikeType mSelection = NRLikeType.MISSING_INFORMATION;

    public static NanorepDislikeDialog newInstance(DislikeConfiguration dislikeConfiguration, ViewIdsFactory viewIdsFactory) {
        NanorepDislikeDialog fragment = new NanorepDislikeDialog();
        fragment.setConfiguration(dislikeConfiguration);
        fragment.setDislikeViewId(viewIdsFactory.getLayoutId());
        fragment.setDislikeViewsProducer(viewIdsFactory.getIDProducer());
        return fragment;
    }

    @Override
    public void onStart() {
        super.onStart();

        Dialog dialog = getDialog();
        if (dialog != null && dialog.getWindow() != null) {
            dialog.getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            dialog.getWindow().setGravity(Gravity.BOTTOM);
        }
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(dislikeViewId, container, false);
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        TextView dialogTitle = view.findViewById(idProducer.getTitleId());
        feedbackEditText = view.findViewById(idProducer.getFeedbackEditTextId());
        RadioGroup feedbackChoicesRadio = view.findViewById(idProducer.getRadioId());
        cancelButton = view.findViewById(idProducer.getCancelButtonId());
        okButton = view.findViewById(idProducer.getSubmitButtonId());

        okButton.setText(dislikeConfiguration.getSubmitButtonText());
        dialogTitle.setText(dislikeConfiguration.getTitle());

        if (feedbackDialogType != OPEN_TEXT && dislikeConfiguration.getDialogOptions() != null && dislikeConfiguration.getDialogOptions().size() > 1) {

            RadioButton firstRadioOption = view.findViewById(idProducer.getFirstRadioButtonId());
            firstRadioOption.setText(dislikeConfiguration.getFirstOptionText());

            RadioButton secondRadioOption = view.findViewById(idProducer.getSecondRadioButtonId());
            secondRadioOption.setText(dislikeConfiguration.getSecondOptionText());

            if (feedbackDialogType == MULTIPLE_CHOICE) {
                feedbackEditText.setVisibility(View.GONE);
            }

            feedbackChoicesRadio.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(RadioGroup group, @IdRes int checkedId) {
                    if (checkedId == idProducer.getFirstRadioButtonId()) {
                        mSelection = NRLikeType.MISSING_INFORMATION;
                    } else {
                        mSelection = NRLikeType.IRRELEVANT;
                    }
                }
            });
        } else if (feedbackDialogType == OPEN_TEXT) {
            feedbackChoicesRadio.setVisibility(View.GONE);
        } else {
            this.dismiss();
            return;
        }

        cancelButton.setOnClickListener(this);
        okButton.setOnClickListener(this);
    }

    @Override
    public void onDismiss(DialogInterface dialogInterface) {
        if (!isDismissHandled) {
            dislikeDialogListener.onCancel();
        }
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == okButton.getId()) {
            isDismissHandled = true;
            if (feedbackDialogType == OPEN_TEXT || feedbackDialogType == MULTIPLE_CHOICE_OPEN_TEXT) {
                feedbackText = feedbackEditText.getText().toString();
            }
            dislikeDialogListener.onDislike(mSelection, feedbackText);
            this.dismiss();
        } else {
            isDismissHandled = true;
            dislikeDialogListener.onCancel();
            this.dismiss();
        }
    }
}
