package nanorep.nanowidget.Components;

import android.content.Context;
import android.graphics.Color;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.network.OnDataResponse;

import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.NRSearchBarListener;


/**
 * Created by nissimpardo on 07/06/16.
 */
public class NRSearchBar extends NRCustomSearchBarView implements View.OnClickListener, TextWatcher, TextView.OnEditorActionListener {

    private final int searchIconResourceId = R.drawable.ic_search_black_24dp;
    private final int closeIconResourceId = R.drawable.ic_close_black_24dp;
    private NRSearchBarListener mListener;
    private ImageButton mSpeechButton;
    private EditText mSearchEditText;
    private TextView labelName;
    private LinearLayout searchBarLayout;
    private LinearLayout labelLayout;



    public NRSearchBar(Context context) {
        super(context);
        LayoutInflater.from(context).inflate(R.layout.search_bar, this);
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);
        searchBarLayout = child.findViewById(R.id.searchBarLayout);
        mSearchEditText = child.findViewById(R.id.searchText);
        labelLayout = child.findViewById(R.id.labelLayout);
        labelName = child.findViewById(R.id.search_bar_label_name_textView);


        mSearchEditText.addTextChangedListener(this);
//        mSearchEditText.setHint(getResources().getString(R.string.type_question_here));
//        mSearchEditText.setTextColor(Color.WHITE);
//        mSearchEditText.setHintTextColor(Color.WHITE);
//        mSearchEditText.getBackground().setColorFilter(Color.TRANSPARENT, PorterDuff.Mode.SRC_IN);
        mSearchEditText.setOnEditorActionListener(this);
        mSpeechButton = child.findViewById(R.id.speechButton);
        mSpeechButton.setOnClickListener(this);

        mSearchEditText.setOnKeyListener(new OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == KeyEvent.ACTION_UP) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                        clear();
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public void setListener(NRSearchBarListener listener) {
        mListener = listener;
    }


    private int resId(String resName) {
        return getResources().getIdentifier(resName, "drawable", getContext().getPackageName());
    }

    public void dismissKeyboard() {
        InputMethodManager imm = (InputMethodManager) getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.hideSoftInputFromWindow(mSearchEditText.getWindowToken(), 0);
    }

    public void updateText(String text) {
        mSearchEditText.clearFocus();
        mSearchEditText.setText(text);
    }

    public void showLabelLayout(boolean show, String label){
        if (show) {
            searchBarLayout.setVisibility(GONE);
            labelName.setText(label);
            labelLayout.setVisibility(VISIBLE);
        } else {
            labelLayout.setVisibility(GONE);
            mSearchEditText.setText("");
            labelName.setText("");
            searchBarLayout.setVisibility(VISIBLE);
        }
    }

    public void setHint(String text) {
        mSearchEditText.setHint(text);
    }

    public void updateEditTextView(String text) {
        mSearchEditText.removeTextChangedListener(this);
//        mSpeechButton.setVisibility(text.length() > 0 ? VISIBLE : INVISIBLE);
        updateText(text);
        mSearchEditText.addTextChangedListener(this);
        if (text.length() == 0) {
            mSpeechButton.setImageResource(searchIconResourceId);
        }
    }

    public String getText() {
        return mSearchEditText.getText().toString();
    }

    @Override
    public void onClick(View v) {
        if (mSearchEditText.getText().length() > 0) {
            mSpeechButton.setImageResource(searchIconResourceId);
            clear();
        }
    }

    private void clear() {
        mSearchEditText.clearFocus();
        dismissKeyboard();
        mListener.onClearClicked(true);
        updateEditTextView("");
        clearContextFromSession();
    }

    private void clearContextFromSession() {

        Nanorep.getInstance().setContext(null, new OnDataResponse<DefaultResponse>() {
            @Override
            public void onSuccess(DefaultResponse response) {
                Nanorep.getInstance().clearCache();

            }

            @Override
            public void onError(NRConnectionException error) {

            }
        });
    }

    @Override
    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

    }

    @Override
    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
//        mSpeechButton.setVisibility(charSequence.length() > 0 ? VISIBLE : INVISIBLE);
        mSpeechButton.setImageResource(charSequence.length() > 0 ? closeIconResourceId : searchIconResourceId);
        Boolean state = Boolean.valueOf(charSequence.length() > 0);
//        mSpeechButton.setTag(state);
        if (charSequence.length() == 0) {
            dismissKeyboard();
            mListener.clearAutoComplete();
        }
    }

    @Override
    public void afterTextChanged(Editable editable) {
        if (editable != null && editable.length() > 0) {
            mListener.fetchSuggestionsForText(mSearchEditText.getText().toString());
        } else {
            mListener.onEmptyQuery();
        }
    }

    @Override
    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == EditorInfo.IME_ACTION_SEARCH) {
            mListener.searchForText(mSearchEditText.getText().toString());
            dismissKeyboard();
            return true;
        }
        return false;
    }

    @Override
    public void setBackgroundColor(int color) {
        super.setBackgroundColor(color);
        searchBarLayout.setBackgroundColor(Color.WHITE);
    }



}
