package nanorep.nanowidget.Fragments;


import android.Manifest;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.OpenableColumns;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ClientCertRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import android.widget.Toast;

import com.nanorep.nanoclient.Channeling.*;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Connection.NRConnection;
import com.nanorep.nanoclient.Handlers.UriToPathHandler;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.network.OnDataResponse;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;

import nanorep.nanowidget.Components.ConfirmationDialogFragment;
import nanorep.nanowidget.R;

import static android.app.Activity.RESULT_OK;

/**
 * A simple {@link Fragment} subclass.
 */
public class NRWebContentFragment extends Fragment {

    private static final String ARG_URL = "param1";
    private static final int FILE_CHOOSER_REQUEST = 100;
    private static final int FILE_CHOOSER_REQUEST_FROM_SCRIPT = 101;
    private static final String CHANNEL_CONFIRMATION_TEXT = "channelConfirmationText";
    private static final String CHANNEL_CONFIRMATION_TITLE = "channelConfirmationTitle";
    private static final String CHANNEL_CONFIRMATION_BUTTON = "channelConfirmationButton";
    public static String PERMISSION_GRANTED_BROADCAST = "permissionGranted";
    private static NRChanneling.NRChannelingType fragmentChannelType;
    private WebView mWebView;
    private WebFormListener mListener;
    private ValueCallback<Uri[]> mValueCallback;
    private WebChromeClient.FileChooserParams mFileChooserParams;
    private RelativeLayout mLoadingView;
    private ArrayList<String> fileUploadPaths;
    private String channelConfirmationText;
    private String channelConfirmationButton;
    private String channelConfirmationTitle;
    private String stringUrl;
    private String result;

    /**
     * The next script makes the form buttons (file upload, submit and cancel buttons) controlled by the fragment
     */

    private String script = "\n(function(){\n" +
            "\n" +
            "function overrideComponent(container) {\n" +
            "  var fileInput = container.querySelector('input[type=\"file\"]'),\n" +
            "      fileButton = container.querySelector('input[type=\"button\"]'),\n" +
            "      fileList = container.querySelector('.nr-fileuploader-list');\n" +
            "\n" +
            "  fileInput.parentNode.removeChild(fileInput);\n" +
            "  fileButton.onclick = function() {\n" +
            "    location.href = 'nanorep://contactForm/attachFile';\n" +
            "  }\n" +
            "\n" +
            "  window.nativeFileAttached = function(fileName) {\n" +
            "    var row = document.createElement('div'),\n" +
            "        item = document.createElement('div'),\n" +
            "        icon = document.createElement('div'),\n" +
            "        file = document.createElement('span'),\n" +
            "        btnRemove = document.createElement('a');\n" +
            "\n" +
            "    row.className = 'attachmentRow';\n" +
            "    item.className = 'attachment';\n" +
            "    icon.className = 'attachmentIcon';\n" +
            "    btnRemove.className = 'deleteFileLink';\n" +
            "    file.appendChild(document.createTextNode(fileName))\n" +
            "\n" +
            "    btnRemove.onclick = function() {\n" +
            "      var rowIndex = getRowIndex(row);\n" +
            "      row.parentNode.removeChild(row);\n" +
            "      location.href = 'nanorep://contactForm/removeFile?index=' + rowIndex;\n" +
            "    }\n" +
            "\n" +
            "    item.appendChild(icon);\n" +
            "    item.appendChild(file);\n" +
            "    item.appendChild(btnRemove);\n" +
            "    row.appendChild(item);\n" +
            "    fileList.appendChild(row);\n" +
            "  }\n" +
            "\n" +
            "  function getRowIndex(row) {\n" +
            "    var index = -1;\n" +
            "    for (var i = 0; i < fileList.children.length; i++) {\n" +
            "      if (fileList.children[i] === row) {\n" +
            "        index = i;\n" +
            "        break;\n" +
            "      }\n" +
            "    }\n" +
            "    return index;\n" +
            "  }\n" +
            "}\n" +
            "\n" +
            "\n" +
            "function modifyFormBehavior() {\n" +
            "  // override file inputs\n" +
            "  var fileInputs = document.querySelectorAll('.CF_fileUploadComp');\n" +
            "  for (var i = 0; i < fileInputs.length; i++) {\n" +
            "    overrideComponent(fileInputs[i]);\n" +
            "  }\n" +
            "\n" +
            "  // override method used in validation\n" +
            "  nanoRep.BundleManager.define({ name: 'MobileSDK', init: function(container) {\n" +
            "    var SimpleUploader = container.FileUploader.SimpleUploader\n" +
            "    SimpleUploader.prototype.getFileList = function() {\n" +
            "      return document.querySelectorAll('.CF_fileUploadComp .attachmentRow');\n" +
            "    };\n" +
            "    SimpleUploader.prototype.getUploadedFiles = function() {\n" +
            "      return [];\n" +
            "    }\n" +
            "  }});    \n" +
            "}\n" +
            "\n" +
            "var formReadyTimer = setInterval(function() {\n" +
            "  if (document.querySelector('.CF_fileUploadComp')) {\n" +
            "    clearTimeout(formReadyTimer);\n" +
            "    modifyFormBehavior();\n" +
            "  }\n" +
            "}, 100);\n" +
            "\n" +
            "}());\n";





    public NRWebContentFragment() {
        // Required empty public constructor
    }

    public static NRWebContentFragment newInstance(String url, NRChanneling.NRChannelingType channelType) {
        NRWebContentFragment fragment = new NRWebContentFragment();
        Bundle args = new Bundle();
        args.putString(ARG_URL, url);
        fragmentChannelType = channelType;
        fragment.setArguments(args);
        return fragment;
    }

    // TODO: Rename and change types and number of parameters
    public static NRWebContentFragment newInstance(String url, String channelConfirmationText, String channelConfirmationTitle, String channelConfirmationButton) {
        NRWebContentFragment fragment = new NRWebContentFragment();
        Bundle args = new Bundle();
        args.putString(ARG_URL, url);
        args.putString(CHANNEL_CONFIRMATION_TEXT, channelConfirmationText);
        args.putString(CHANNEL_CONFIRMATION_TITLE, channelConfirmationTitle);
        args.putString(CHANNEL_CONFIRMATION_BUTTON, channelConfirmationButton);
        fragment.setArguments(args);
        return fragment;
    }

    public void setListener(WebFormListener listener) {
        mListener = listener;
    }

    @SuppressLint("SetJavaScriptEnabled")
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.fragment_nrweb_content, container, false);

        /**
         * Usage of local broadcast from the activity when the file storage permissions granted
         */

        BroadcastReceiver receiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent != null) {
                    Intent fileChooserIntent = new Intent(Intent.ACTION_GET_CONTENT);
                    fileChooserIntent.addCategory(Intent.CATEGORY_OPENABLE);
                    fileChooserIntent.setType("image/*");
                    try {
                        startActivityForResult(fileChooserIntent, FILE_CHOOSER_REQUEST_FROM_SCRIPT);
                    } catch (ActivityNotFoundException e) {
                        Toast.makeText(getActivity().getApplicationContext(), "Cannot Open File Chooser", Toast.LENGTH_LONG).show();
                    }
                }
            }
        };

        LocalBroadcastManager lbm = LocalBroadcastManager.getInstance(getContext());
        lbm.registerReceiver(receiver, new IntentFilter(PERMISSION_GRANTED_BROADCAST));

        mLoadingView = (RelativeLayout) view.findViewById(R.id.webLoadingView);

        mWebView = (WebView) view.findViewById(R.id.webContentView);


        /**
         * this array will include all the uploaded files paths
         */
        fileUploadPaths = new ArrayList<>();

        if (getArguments() != null) {
            channelConfirmationButton = getArguments().getString(CHANNEL_CONFIRMATION_BUTTON);
            channelConfirmationText = getArguments().getString(CHANNEL_CONFIRMATION_TEXT);
            channelConfirmationTitle = getArguments().getString(CHANNEL_CONFIRMATION_TITLE);
            stringUrl = getArguments().getString(ARG_URL);
        }

        mWebView.getSettings().setJavaScriptEnabled(true);
        mWebView.getSettings().setAllowFileAccess(true);
        mWebView.getSettings().setAllowContentAccess(true);
        mWebView.getSettings().setAllowFileAccessFromFileURLs(true);

        if (fragmentChannelType == null || fragmentChannelType == NRChanneling.NRChannelingType.ChatForm) {
            mWebView.loadUrl(getArguments().getString(ARG_URL));
            mWebView.setWebChromeClient(new WebChromeClient() {
                @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
                @Override
                public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, FileChooserParams fileChooserParams) {
                    mValueCallback = filePathCallback;
                    mFileChooserParams = fileChooserParams;
                    if (ContextCompat.checkSelfPermission(getActivity(),
                            Manifest.permission.READ_EXTERNAL_STORAGE)
                            != PackageManager.PERMISSION_GRANTED) {
                        ActivityCompat.requestPermissions(getActivity(),
                                new String[]{Manifest.permission.READ_EXTERNAL_STORAGE},
                                FILE_CHOOSER_REQUEST);
                    }
                    Intent intent = mFileChooserParams.createIntent();
                    try {
                        startActivityForResult(intent, FILE_CHOOSER_REQUEST);
                    } catch (ActivityNotFoundException e) {
                        Toast.makeText(getActivity().getApplicationContext(), "Cannot Open File Chooser", Toast.LENGTH_LONG).show();
                    }

                    return true;
                }
            });
            mWebView.setWebViewClient(new NRPresentorWebClient());
        }

        if (Nanorep.getInstance().getWidgetListener() != null) {
            try {
                URL url = new URL(stringUrl);
                Uri.Builder builder = Uri.parse(String.valueOf(url.toURI())).buildUpon();

                //getting the html of the form
                NRConnection.connection(builder, new OnDataResponse<String>() {

                    @Override
                    public void onSuccess(String response) {
                        // injecting the script to the form's html
                        String html_first_part = response.substring(0, response.indexOf("<script>") + "<script>".length());
                        String html_first_part_with_script = html_first_part + script;
                        String upgradedHtml = html_first_part_with_script + response.substring(html_first_part.length());
                        mWebView.loadDataWithBaseURL(stringUrl, upgradedHtml,"text/html", "UTF-8", "");
                    }

                    @Override
                    public void onError(NRConnectionException error) {
                        Log.e("GetFormError", "error on downloading form data: " + error.getData());
                    }
                });

            } catch (MalformedURLException e) {
                e.printStackTrace();
            } catch (URISyntaxException e) {
                e.printStackTrace();
            }
        } else {
            Toast.makeText(getActivity().getApplicationContext(), "Form opening failure", Toast.LENGTH_LONG).show();
        }

        mWebView.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == KeyEvent.ACTION_DOWN) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                        if (mWebView.canGoBack()) {
                            mWebView.goBack();
                        } else {
                            getFragmentManager().popBackStack();
                            mListener.onDismiss(null);
                        }

                        return true;
                    }
                }

                return false;
            }
        });
        return view;
    }

    /**
     * Back from the file chooser after permission granted
     */
    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (data != null && resultCode == RESULT_OK) {
            Uri fileUploadUri = data.getData();

            // adding the file path to the fileUploadPaths array
            // generateFilePathFromUri is an engine that gets the file path from the uri
            fileUploadPaths.add(UriToPathHandler.generateFilePathFromUri(getContext(), fileUploadUri));

            /*if (requestCode == FILE_CHOOSER_REQUEST) {
                if (mValueCallback != null) {
                    mValueCallback.onReceiveValue(new Uri[]{fileUploadUri});
                }
            } else*/
            if (requestCode == FILE_CHOOSER_REQUEST_FROM_SCRIPT){
                String fileName = null;
                if (data.getScheme().equals("content")) {
                    Cursor cursor = getContext().getContentResolver().query(data.getData(), null, null, null, null);
                    try {
                        if (cursor != null && cursor.moveToFirst()) {
                            fileName = cursor.getString(cursor.getColumnIndex(OpenableColumns.DISPLAY_NAME));
                            mWebView.loadUrl("javascript:nativeFileAttached" + '(' + "'" + fileName + "'" + ')');
                        }
                    } finally {
                        if (cursor != null) {
                            cursor.close();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();

        mWebView.stopLoading();
        mWebView.loadUrl("about:blank");
    }


    public interface WebFormListener {
        void onDismiss(String result);
    }

    public class NRPresentorWebClient extends WebViewClient {

        @Override
        public void onReceivedClientCertRequest(WebView view, ClientCertRequest request) {
            super.onReceivedClientCertRequest(view, request);
        }

        @Override
        public void onUnhandledKeyEvent(WebView view, KeyEvent event) {
            super.onUnhandledKeyEvent(view, event);
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            mLoadingView.setVisibility(View.GONE);
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return shouldOverrideUrl(view, url);
        }

        @TargetApi(Build.VERSION_CODES.LOLLIPOP)
        @Override
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return shouldOverrideUrl(view, request.getUrl().toString());
        }

        private boolean shouldOverrideUrl(WebView webView, String url) {
            final String prefix = "nanorep://formData/";
//            final String dismissUrl = "nanorep://";
            final String prefixContactForm = "nanorep://contactForm";

            if (url.startsWith(prefix)) { //submit the form (get the result)
                result = url.startsWith(prefix) ? url.substring(prefix.length()) : "";
                return true;
            } else if (url.startsWith(prefixContactForm)){
                if (url.contains("attachFile")){ //If needed - ask for file permission else open the file chooser
                   if (getPermissionsStatus(Manifest.permission.READ_EXTERNAL_STORAGE, FILE_CHOOSER_REQUEST_FROM_SCRIPT) == PackageManager.PERMISSION_GRANTED){
                       openFileChooser();
                   }
                } else if (url.contains("removeFile")){ //Removes selected file from the list (update UI, formData and fileUploadPaths)
                    Uri uri = Uri.parse(url);
                    int fileIndex = Integer.valueOf(uri.getQueryParameter("index"));
                    fileUploadPaths.remove(fileIndex);
                } else if (url.contains("cancel")){ //cancel the form
                    mListener.onDismiss(null);
                } else if (url.contains("send") && url.endsWith("result=2")){ //submit the form
                    View view = getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                    new ConfirmationDialogFragment(getContext(), view, channelConfirmationText, channelConfirmationButton, channelConfirmationTitle, new ConfirmationDialogFragment.OnOkClick() {
                        @Override
                        public void okClicked() {
                            Nanorep.getInstance().getWidgetListener().onSubmitSupportForm(result, fileUploadPaths);
                            mListener.onDismiss(null);

                        }
                    });
                    return true;
                }
                return true;

//            } else if (url.startsWith(dismissUrl)) {
//                if (url.endsWith("result=3")) {
//                    return true;
//                }
//                getFragmentManager().popBackStack();
//                mListener.onDismiss(null);
//                return true;
            }
            return false;
        }
    }

    private int getPermissionsStatus(String permission, int requestCode){

        if (ActivityCompat.checkSelfPermission(getContext(), permission) != PackageManager.PERMISSION_GRANTED) {
            requestPermissions(new String[]{permission}, requestCode);

            return PackageManager.PERMISSION_DENIED;
        }
        return PackageManager.PERMISSION_GRANTED;
    }

    private void openFileChooser() {
        Intent fileChooserIntent = new Intent(Intent.ACTION_GET_CONTENT);
        fileChooserIntent.addCategory(Intent.CATEGORY_OPENABLE);
        fileChooserIntent.setType("image/*");
        try {
            startActivityForResult(fileChooserIntent, FILE_CHOOSER_REQUEST_FROM_SCRIPT);
        } catch (ActivityNotFoundException e) {
            Toast.makeText(getActivity().getApplicationContext(), "Cannot Open File Chooser", Toast.LENGTH_LONG).show();
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == FILE_CHOOSER_REQUEST_FROM_SCRIPT
                && grantResults.length > 0
                && grantResults[0] == PackageManager.PERMISSION_GRANTED) {

            openFileChooser();
        }
    }
}
