package nanorep.nanowidget.Components.formSDK.model;

import com.google.gson.annotations.SerializedName;

import java.util.Calendar;
import java.util.List;

import static nanorep.nanowidget.Components.formSDK.model.FormFieldType.CHECKBOX_LIST;
import static nanorep.nanowidget.Components.formSDK.model.FormFieldType.DATE_PATTERN;
import static nanorep.nanowidget.Components.formSDK.model.FormFieldType.TIME_PATTERN;

/**
 * Created by Oz on 7/20/2017.
 */

public class FormFields {

    private DbField[] db;
    private UserInput userInput;
    private boolean fieldChecked;
    private boolean isValid;

    public boolean isValid() {
        return isValid;
    }

    public void setValid(boolean valid) {
        isValid = valid;
    }

    @SerializedName("id")
    private int fromId;


    // Input Type:
    // Textbox: 1,Selectbox: 2,Container: 3,Checkbox: 4,
    // RadioList: 5,CheckboxList: 6,LabelItem: 7,AutoButtons: 8,fileUpload: 9
    @SerializedName("it")
    private int inputType;

    //change the behavior of the table (colspan)
    @SerializedName("sp")
    private int TableBehavior;

    // identify field by name
    @SerializedName("in")
    private String subject;

    @SerializedName("lv")
    private String fieldLabel;

    @SerializedName("do")
    private DoField dependencies;

    // text input type:
    //("General": 0,"Email": 1,"Phone": 2,"Number": 3,"Subject": 4,
    // "Comments": 5,"Message": 6,"Custom": 7,"Name": 8,"CC": 9,"BCC": 10)
    @SerializedName("ti")
    private int textInputType;

    @SerializedName("tb")
    private String textPlaceholder;

    //multiline true/false
    @SerializedName("ml")
    private Boolean multiline;

    @SerializedName("rx")
    private String regaxValidation;

    @SerializedName("mf")
    private Boolean mandatoryField;

    @SerializedName("vt")
    private String validationErrorMessage;

    @SerializedName("so")
    private List<SelectionOptions> selectionOptions;

    public String getLabel_button_yes() {
        return label_button_yes;
    }

    public String getLabel_button_no() {
        return label_button_no;
    }

    @SerializedName("cv")
    private String label_button_no;

    @SerializedName("sv")
    private String label_button_yes;

    public List<SelectionOptions> getSelectionOptions() {
        return selectionOptions;
    }

    public void setSelectionOptions(List<SelectionOptions> selectionOptions) {
        this.selectionOptions = selectionOptions;
    }

    public void setDb(DbField[] db) {
        this.db = db;
    }

    public void setFromId(int fromId) {
        this.fromId = fromId;
    }

    public void setInputType(int inputType) {
        this.inputType = inputType;
    }

    public void setTableBehavior(int tableBehavior) {
        TableBehavior = tableBehavior;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setDependencies(DoField dependencies) {
        this.dependencies = dependencies;
    }

    public void setTextInputType(int textInputType) {
        this.textInputType = textInputType;
    }

    public void setMultiline(Boolean multiline) {
        this.multiline = multiline;
    }

    public void setRegaxValidation(String regaxValidation) {
        this.regaxValidation = regaxValidation;
    }

    private void setMandatoryField(Boolean mandatoryField) {
        this.mandatoryField = mandatoryField;
    }

    public void setValidationErrorMessage(String validationErrorMessage) {
        this.validationErrorMessage = validationErrorMessage;
    }

    public void setLabel_button_yes(String label_button_yes) {
        this.label_button_yes = label_button_yes;
    }

    public void setLabel_button_no(String label_button_no) {
        this.label_button_no = label_button_no;
    }


    public DbField[] getDb() {
        return db;
    }

    public int getFromId() {
        return fromId;
    }

    public int getInputType() {
        return inputType;
    }

    public int getTableBehavior() {
        return TableBehavior;
    }

    public String getSubject() {
        return subject;
    }

    public String getFieldLabel() {
        return fieldLabel;
    }

    public DoField getDependencies() {
        return dependencies;
    }

    public int getTextInputType() {
        return textInputType;
    }

    public String getTextPlaceholder() {
        return textPlaceholder;
    }

    public Boolean getMultiline() {
        return multiline;
    }

    public String getRegaxValidation() {
        return regaxValidation;
    }

    private Boolean getMandatoryField() {
        if (mandatoryField != null) return mandatoryField;
        else return false;
    }

    public String getValidationErrorMessage() {
        return validationErrorMessage;
    }

    public boolean isRequired() {
        return getMandatoryField();
    }

    public void setRequired(boolean required) {
        setMandatoryField(required);
    }

    public void setTextPlaceholder(String textPlaceholder) {
        this.textPlaceholder = textPlaceholder;
    }

    public boolean isDatePickerField() {
        return inputType == 1
                && (getFieldLabel().contains(DATE_PATTERN));
    }

    public boolean isTimePickerField() {
        return inputType == 1
                && (getFieldLabel().contains(TIME_PATTERN));
    }

    public String setFieldLabel(String fieldLabel) {
        this.fieldLabel = fieldLabel;
        return fieldLabel;
    }

    boolean fieldIsCheckBoxList() {
        return getInputType() == CHECKBOX_LIST;
    }

    private String correctDateAndTime() {
        String correctDateAndTimePlaceHolder;
        Calendar correctData = Calendar.getInstance();
        if (isDatePickerField()) {
            final int correctYear = correctData.get(Calendar.YEAR);
            final int correctMonth = correctData.get(Calendar.MONTH);
            final int correctDay = correctData.get(Calendar.DAY_OF_MONTH);
            correctDateAndTimePlaceHolder = correctYear +
                    "-" + ((correctMonth < 10) ? "0" + correctMonth : correctMonth) +
                    "-" + ((correctDay < 10) ? "0" + correctDay : correctDay);
        } else if (isTimePickerField()) {
            int hourOfDay = correctData.get(Calendar.HOUR_OF_DAY);
            int minute = correctData.get(Calendar.MINUTE);
            correctDateAndTimePlaceHolder = ((hourOfDay < 10) ? "0" + hourOfDay : hourOfDay) + ":" + ((minute < 10) ? "0" + minute : minute);
        } else return "";
        return correctDateAndTimePlaceHolder;
    }

    public boolean isFilePickerField() {
        return inputType == 9;
    }

    public void setFieldChecked(boolean fieldChecked) {
        this.fieldChecked = fieldChecked;
    }

    public boolean isChecked() {
        return fieldChecked;
    }

    public UserInput getUserInputs() {
        return userInput;
    }

    public void setUserInput(UserInput userInputs) {
        this.userInput = userInputs;
    }

    @Override
    public String toString() {
        return inputType + "  " + fieldLabel;
    }
}
