/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Fragments;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ClientCertRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.nanorep.nanoclient.Connection.NRConnection;
import com.nanorep.nanoclient.Handlers.UriToPathHandler;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import nanorep.nanowidget.Components.ConfirmationDialogFragment;
import nanorep.nanowidget.R;

public class NRWebContentFragment
extends Fragment {
    private static final String ARG_URL = "param1";
    private static final int FILE_CHOOSER_REQUEST = 100;
    private static final int FILE_CHOOSER_REQUEST_FROM_SCRIPT = 101;
    private static final String CHANNEL_CONFIRMATION_TEXT = "channelConfirmationText";
    private static final String CHANNEL_CONFIRMATION_TITLE = "channelConfirmationTitle";
    private static final String CHANNEL_CONFIRMATION_BUTTON = "channelConfirmationButton";
    private WebView mWebView;
    private WebFormListener mListener;
    private ValueCallback<Uri[]> mValueCallback;
    private WebChromeClient.FileChooserParams mFileChooserParams;
    private RelativeLayout mLoadingView;
    private Uri fileUploadUri;
    private ArrayList<String> fileUploadPaths;
    private String channelConfirmationText;
    private String channelConfirmationButton;
    private String channelConfirmationTitle;
    private String stringUrl;
    private String script = "\n(function(){\n\n\tfunction overrideComponent(container) {\n\t  var fileInput = container.querySelector('input[type=\"file\"]'),\n\t\t  fileButton = container.querySelector('input[type=\"button\"]'),\n\t\t  fileList = container.querySelector('.nr-fileuploader-list');\n   \n\t  fileInput.parentNode.removeChild(fileInput);\n\t  fileButton.onclick = function() {\n\t\tlocation.href = 'nanorep://contactForm/attachFile';\n\t  }\n   \n\t  window.nativeFileAttached = function(fileName) {\n\t\tvar row = document.createElement('div'),\n\t\t\titem = document.createElement('div'),\n\t\t\ticon = document.createElement('div'),\n\t\t\tfile = document.createElement('span'),\n\t\t\tbtnRemove = document.createElement('a');\n   \n\t\trow.className = 'attachmentRow';\n\t\titem.className = 'attachment';\n\t\ticon.className = 'attachmentIcon';\n\t\tbtnRemove.className = 'deleteFileLink';\n\t\tfile.appendChild(document.createTextNode(fileName))\n   \n\t\tbtnRemove.onclick = function() {\n\t\t  var rowIndex = getRowIndex(row);\n\t\t  row.parentNode.removeChild(row);\n\t\t  location.href = 'nanorep://contactForm/removeFile?index=' + rowIndex;\n\t\t}\n   \n\t\titem.appendChild(icon);\n\t\titem.appendChild(file);\n\t\titem.appendChild(btnRemove);\n\t\trow.appendChild(item);\n\t\tfileList.appendChild(row);\n\t  }\n   \n\t  function getRowIndex(row) {\n\t\tvar index = -1;\n\t\tfor (var i = 0; i < fileList.children.length; i++) {\n\t\t  if (fileList.children[i] === row) {\n\t\t\tindex = i;\n\t\t\tbreak;\n\t\t  }\n\t\t}\n\t\treturn index;\n\t  }\n\t}\n   \n   \n\tfunction modifyFormBehavior() {\n\t  var fileInputs = document.querySelectorAll('.CF_fileUploadComp');\n\t  for (var i = 0; i < fileInputs.length; i++) {\n\t\toverrideComponent(fileInputs[i]);\n\t  }\n\t}\n   \n\tvar formReadyTimer = setInterval(function() {\n\t  if (document.querySelector('.CF_fileUploadComp')) {\n\t\tclearTimeout(formReadyTimer);\n\t\tmodifyFormBehavior();\n\t  }\n\t}, 100);\n   \n   }());\n";

    public static NRWebContentFragment newInstance(String url) {
        NRWebContentFragment fragment = new NRWebContentFragment();
        Bundle args = new Bundle();
        args.putString(ARG_URL, url);
        fragment.setArguments(args);
        return fragment;
    }

    public static NRWebContentFragment newInstance(String url, String channelConfirmationText, String channelConfirmationTitle, String channelConfirmationButton) {
        NRWebContentFragment fragment = new NRWebContentFragment();
        Bundle args = new Bundle();
        args.putString(ARG_URL, url);
        args.putString(CHANNEL_CONFIRMATION_TEXT, channelConfirmationText);
        args.putString(CHANNEL_CONFIRMATION_TITLE, channelConfirmationTitle);
        args.putString(CHANNEL_CONFIRMATION_BUTTON, channelConfirmationButton);
        fragment.setArguments(args);
        return fragment;
    }

    public void setListener(WebFormListener listener) {
        this.mListener = listener;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_nrweb_content, container, false);
        this.mLoadingView = (RelativeLayout)view.findViewById(R.id.webLoadingView);
        this.mWebView = (WebView)view.findViewById(R.id.webContentView);
        this.fileUploadPaths = new ArrayList();
        if (this.getArguments() != null) {
            this.channelConfirmationButton = this.getArguments().getString(CHANNEL_CONFIRMATION_BUTTON);
            this.channelConfirmationText = this.getArguments().getString(CHANNEL_CONFIRMATION_TEXT);
            this.channelConfirmationTitle = this.getArguments().getString(CHANNEL_CONFIRMATION_TITLE);
            this.stringUrl = this.getArguments().getString(ARG_URL);
        }
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.getSettings().setAllowFileAccess(true);
        this.mWebView.getSettings().setAllowContentAccess(true);
        this.mWebView.getSettings().setAllowFileAccessFromFileURLs(true);
        this.mWebView.setWebViewClient((WebViewClient)new NRPresentorWebClient());
        if (Nanorep.getInstance().getWidgetListener() != null) {
            try {
                URL url = new URL(this.stringUrl);
                Uri.Builder builder = Uri.parse((String)String.valueOf(url.toURI())).buildUpon();
                NRConnection.connection((Uri.Builder)builder, (OnDataResponse)new OnDataResponse<String>(){

                    public void onSuccess(String response) {
                        String html_first_part = response.substring(0, response.indexOf("<script>") + "<script>".length());
                        String html_first_part_with_script = html_first_part + NRWebContentFragment.this.script;
                        String upgradedHtml = html_first_part_with_script + response.substring(html_first_part.length());
                        NRWebContentFragment.this.mWebView.loadDataWithBaseURL(NRWebContentFragment.this.stringUrl, upgradedHtml, "text/html", "UTF-8", "");
                    }

                    public void onError(NRConnectionException error) {
                    }
                });
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        } else {
            this.mWebView.loadUrl(this.getArguments().getString(ARG_URL));
            this.mWebView.setWebChromeClient(new WebChromeClient(){

                @RequiresApi(api=21)
                public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
                    NRWebContentFragment.this.mValueCallback = filePathCallback;
                    NRWebContentFragment.this.mFileChooserParams = fileChooserParams;
                    if (ContextCompat.checkSelfPermission((Context)NRWebContentFragment.this.getActivity(), (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
                        ActivityCompat.requestPermissions((Activity)NRWebContentFragment.this.getActivity(), (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, (int)100);
                    }
                    Intent intent = NRWebContentFragment.this.mFileChooserParams.createIntent();
                    try {
                        NRWebContentFragment.this.startActivityForResult(intent, 100);
                    }
                    catch (ActivityNotFoundException e) {
                        Toast.makeText((Context)NRWebContentFragment.this.getActivity().getApplicationContext(), (CharSequence)"Cannot Open File Chooser", (int)1).show();
                    }
                    return true;
                }
            });
            this.mWebView.setOnKeyListener(new View.OnKeyListener(){

                public boolean onKey(View v, int keyCode, KeyEvent event) {
                    if (event.getAction() == 0 && keyCode == 4) {
                        if (NRWebContentFragment.this.mWebView.canGoBack()) {
                            NRWebContentFragment.this.mWebView.goBack();
                        } else {
                            NRWebContentFragment.this.getFragmentManager().popBackStack();
                            NRWebContentFragment.this.mListener.onDismiss(null);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (data != null && resultCode == -1) {
            this.fileUploadUri = data.getData();
            this.fileUploadPaths.add(UriToPathHandler.generateFilePathFromUri((Context)this.getContext(), (Uri)this.fileUploadUri));
            if (requestCode == 100) {
                if (this.mValueCallback != null) {
                    this.mValueCallback.onReceiveValue((Object)new Uri[]{this.fileUploadUri});
                }
            } else if (requestCode == 101) {
                String fileName = null;
                if (data.getScheme().equals("content")) {
                    try (Cursor cursor = this.getContext().getContentResolver().query(data.getData(), null, null, null, null);){
                        if (cursor != null && cursor.moveToFirst()) {
                            fileName = cursor.getString(cursor.getColumnIndex("_display_name"));
                            this.mWebView.loadUrl("javascript:nativeFileAttached('" + fileName + "'" + ')');
                        }
                    }
                }
            }
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mWebView.stopLoading();
        this.mWebView.loadUrl("about:blank");
    }

    public class NRPresentorWebClient
    extends WebViewClient {
        public void onReceivedClientCertRequest(WebView view, ClientCertRequest request) {
            super.onReceivedClientCertRequest(view, request);
        }

        public void onUnhandledKeyEvent(WebView view, KeyEvent event) {
            super.onUnhandledKeyEvent(view, event);
        }

        public void onPageFinished(WebView view, String url) {
            NRWebContentFragment.this.mLoadingView.setVisibility(8);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return this.shouldOverrideUrl(view, url);
        }

        @TargetApi(value=21)
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return this.shouldOverrideUrl(view, request.getUrl().toString());
        }

        private boolean shouldOverrideUrl(WebView webView, String url) {
            String prefix = "nanorep://formData/";
            String dismissUrl = "nanorep://";
            String prefixContactForm = "nanorep://contactForm";
            if (url.startsWith("nanorep://formData/")) {
                final String result = url.startsWith("nanorep://formData/") ? url.substring("nanorep://formData/".length()) : "";
                View view = NRWebContentFragment.this.getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                new ConfirmationDialogFragment(NRWebContentFragment.this.getContext(), view, NRWebContentFragment.this.channelConfirmationText, NRWebContentFragment.this.channelConfirmationButton, NRWebContentFragment.this.channelConfirmationTitle, new ConfirmationDialogFragment.OnOkClick(){

                    @Override
                    public void okClicked() {
                        Nanorep.getInstance().getWidgetListener().onSubmitSupportForm(result, NRWebContentFragment.this.fileUploadPaths);
                        NRWebContentFragment.this.mListener.onDismiss(null);
                    }
                });
                return true;
            }
            if (url.startsWith("nanorep://contactForm")) {
                if (url.contains("attachFile")) {
                    Intent i = new Intent("android.intent.action.GET_CONTENT");
                    i.addCategory("android.intent.category.OPENABLE");
                    i.setType("image/*");
                    NRWebContentFragment.this.startActivityForResult(Intent.createChooser((Intent)i, (CharSequence)"File Chooser"), 101);
                } else if (url.contains("removeFile")) {
                    Uri uri = Uri.parse((String)url);
                    int fileIndex = Integer.valueOf(uri.getQueryParameter("index"));
                    NRWebContentFragment.this.fileUploadPaths.remove(fileIndex);
                }
                return true;
            }
            if (url.startsWith("nanorep://")) {
                if (url.endsWith("result=3")) {
                    return true;
                }
                NRWebContentFragment.this.getFragmentManager().popBackStack();
                NRWebContentFragment.this.mListener.onDismiss(null);
                return true;
            }
            return false;
        }
    }

    public static interface WebFormListener {
        public void onDismiss(String var1);
    }
}

