/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Fragments;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Spannable;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingPhoneNumber;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRExtraDataListener;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRAnswer;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresentor;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.ChannelPresenters.NRCustomScriptChannelPresentor;
import nanorep.nanowidget.Components.ConfirmationDialogFragment;
import nanorep.nanowidget.Components.DislikeDialog;
import nanorep.nanowidget.Components.MyWebView;
import nanorep.nanowidget.Components.NRArticleView;
import nanorep.nanowidget.Components.NRCategoriesView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRLikeView;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRResultsView;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.Components.NRTitleView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.Components.formSDK.FormFragment;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRLabelsAdapter;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.DataClass.NRResultsAdapter;
import nanorep.nanowidget.Fragments.NRWebContentFragment;
import nanorep.nanowidget.R;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRApplicationContentListener;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRFetcherListener;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

public class NRMainFragment
extends Fragment
implements NRSearchBarListener,
NRLabelsAdapter.NRLabelsListener,
NRSuggestionsListener,
NRCategoriesView.Listener,
NRResultsView.Listener,
NRContentView.Listener,
NRChannelItem.OnChannelSelectedListener,
NRArticleView.Listener,
NRErrorHandler.Listener {
    public static final String TAG = NRMainFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;
    private NRFetchedDataManager mFetchedDataManager;
    private NRCustomViewAdapter viewAdapter;
    private RelativeLayout mLoadingView;
    private LinearLayout fragmentMainLayout;
    private FrameLayout contentMain;
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;
    private NRCustomSuggestionsView mSuggestionsView;
    private LinearLayout mSuggestionViewContainer;
    private NRCategoriesView categoriesView;
    private boolean resetSuggestions = false;
    private boolean autocompleteEnabled = true;
    private View.OnKeyListener onKeyListener;
    private LinearLayout noConnectionView;
    private boolean animation = false;
    private NRApplicationContentListener applicationContentListener;
    private NRCustomChannelView channelView;
    private String articleId;
    private Button clearContextButton;
    private TextView userSelectedContextTextView;
    private LinearLayout userSelectedContextLayout;
    private String userSelectedContextKey;
    private NRLabel currentLabel;
    private TextView actionBarTextView;
    private boolean fragmentPaused;
    private NRChannelingView noResultsChannelingRecycler;
    private long previousClickTime;
    private NRConfiguration configuration;

    public static NRMainFragment newInstance(String context) {
        NRMainFragment fragment = new NRMainFragment();
        return fragment;
    }

    @Override
    public void fetchBodyForResult(final NRCustomContentView view, String resultID, Integer resultHash) {
        this.articleId = resultID;
        this.mFetchedDataManager.faqAnswer(resultID, resultHash, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                if (result != null) {
                    view.loadData(result.getBody(), "text/html", "UTF-8");
                }
            }
        });
    }

    @Override
    public void closeAnswer() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (!this.animation) {
            view.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_out_left));
        } else if (view instanceof NRArticleView && !((NRArticleView)view).getmResult().isSingle()) {
            ((NRArticleView)view).setResultUnFoldState(false);
            ((NRArticleView)view).removeTopView();
        }
        this.contentMain.removeView(view);
    }

    @Override
    public void onChannelSelected(final NRChanneling channel) {
        String extraData;
        NRQueryResult currentResult = this.getCurrentResult();
        if (currentResult == null || currentResult.getExtraData() == null) {
            if (channel.getNoResultExtra() == null) {
                this.openChannel(channel);
                return;
            }
            extraData = channel.getNoResultExtra();
        } else {
            extraData = this.getCurrentResult().getExtraData();
        }
        Nanorep.getInstance().getWidgetListener().personalInfoWithExtraData(channel.getChannelDescription(), extraData, new NRExtraDataListener(){

            public void onExtraData(Map<String, String> extraData) {
                channel.setExtraData(extraData);
                NRMainFragment.this.openChannel(channel);
            }
        });
    }

    private void openChannel(NRChanneling channeling) {
        NRChannelPresentor presentor = NRChannelStrategy.presentor(this.getContext(), channeling, Nanorep.getInstance());
        if (presentor instanceof NRCustomScriptChannelPresentor) {
            presentor.present();
        } else {
            String url = presentor.getUrl();
            if (url != null) {
                RelativeLayout holder = (RelativeLayout)this.getView().findViewById(R.id.fragment_place_holder);
                holder.setVisibility(0);
                if (TextUtils.isDigitsOnly((CharSequence)channeling.getContactForm())) {
                    if (Build.VERSION.SDK_INT < 19) {
                        FormFragment formFragment = FormFragment.newInstance(Integer.parseInt(channeling.getContactForm()), channeling.getThankYouMessage(), this.configuration.getFeedbackConfirmationDialogTitle(), this.configuration.getFeedbackConfirmationDialogButton());
                        this.getFragmentManager().beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(R.id.content_main, (Fragment)formFragment).addToBackStack("linked").commit();
                    } else {
                        NRWebContentFragment webContentFragment = NRWebContentFragment.newInstance(url, channeling.getThankYouMessage(), this.configuration.getFeedbackConfirmationDialogTitle(), this.configuration.getFeedbackConfirmationDialogButton());
                        webContentFragment.setListener(new NRWebContentFragment.WebFormListener(){

                            @Override
                            public void onDismiss(String result) {
                                if (result == null) {
                                    NRMainFragment.this.getFragmentManager().popBackStack();
                                }
                                InputMethodManager imm = (InputMethodManager)NRMainFragment.this.getContext().getSystemService("input_method");
                                imm.hideSoftInputFromWindow(NRMainFragment.this.getView().getWindowToken(), 0);
                                NRMainFragment.this.requestFocus();
                            }
                        });
                        this.getFragmentManager().beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(R.id.content_main, (Fragment)webContentFragment).addToBackStack("linked").commit();
                    }
                }
            } else if (channeling.getType() == NRChanneling.NRChannelingType.PhoneNumber) {
                String phoneNumber = ((NRChannelingPhoneNumber)channeling).getPhoneNumber();
                String channelName = ((NRChannelingPhoneNumber)channeling).getName();
                Intent intent = new Intent("android.intent.action.DIAL", Uri.fromParts((String)"tel", (String)phoneNumber, null));
                intent.setFlags(0x10008000);
                try {
                    this.startActivity(intent);
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    // empty catch block
                }
                Nanorep.getInstance().reportChanneling(this.articleId, "5", channelName);
            }
        }
    }

    private NRQueryResult getCurrentResult() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            return ((NRArticleView)view).getmResult().getFetchedResult();
        }
        return null;
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
        this.mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                NRResult newResult = new NRResult(result, NRResultItem.RowType.TITLE);
                int height = Integer.valueOf(NRMainFragment.this.configuration.getTitle().getTitleRowHeight());
                newResult.setHeight((int)Calculate.pxFromDp(NRMainFragment.this.getContext(), height));
                newResult.setSingle(true);
                NRArticleView resultTopView = NRMainFragment.this.getTopView();
                NRMainFragment.this.contentMain.addView((View)resultTopView);
                resultTopView.startAnimation(AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_in_left));
                resultTopView.openOpenedView(newResult);
                NRMainFragment.this.requestFocus();
            }
        });
    }

    @Override
    public void onLinkClicked(String url) {
        if (Nanorep.getInstance().getAccountParams().isOpenLinksInternally()) {
            MyWebView webView = new MyWebView(this.getContext(), url, new MyWebView.Listener(){

                @Override
                public void onDismiss() {
                    NRMainFragment.this.contentMain.removeViewAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                    NRMainFragment.this.requestFocus();
                }
            });
            this.contentMain.addView((View)webView);
            this.requestFocus();
        } else {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            try {
                this.startActivity(intent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onDismiss() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            view.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_out_left));
        }
        this.removeTopView();
    }

    @Override
    public void onLikeClicked(final NRArticleView view, final NRCustomLikeView likeView, String resultId, boolean isLike) {
        NRResult result = view.getmResult();
        if (isLike) {
            result.getFetchedResult().setLikeState(NRQueryResult.LikeState.positive);
            this.mFetchedDataManager.sendLike(NRLikeType.POSITIVE, "", result.getFetchedResult(), new Nanorep.OnLikeSentListener(){

                public void onLikeSent(boolean success) {
                    if (!success) {
                        view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                        likeView.resetLikeView();
                    } else {
                        View view2 = NRMainFragment.this.getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                        new ConfirmationDialogFragment(NRMainFragment.this.getContext(), view2, NRMainFragment.this.configuration.getFeedbackConfirmationDialogBody(), NRMainFragment.this.configuration.getFeedbackConfirmationDialogButton(), NRMainFragment.this.configuration.getFeedbackConfirmationDialogTitle());
                    }
                }
            });
        } else if (likeView.shouldOpenDialog()) {
            this.openDislikeDialog(result, view, likeView);
        } else {
            this.onDislike(result, view, likeView, NRLikeType.INCORRECT_ANSWER, "");
        }
    }

    private void onDislike(NRResult result, final NRArticleView view, final NRCustomLikeView likeView, NRLikeType type, String feedbackText) {
        result.getFetchedResult().setLikeState(NRQueryResult.LikeState.negative);
        this.mFetchedDataManager.sendLike(type, feedbackText, result.getFetchedResult(), new Nanorep.OnLikeSentListener(){

            public void onLikeSent(boolean success) {
                if (!success) {
                    view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                    Toast.makeText((Context)NRMainFragment.this.getContext(), (CharSequence)NRMainFragment.this.getResources().getString(R.string.feedback_error_message), (int)1).show();
                    NRMainFragment.this.removeTopView();
                } else {
                    View view2 = NRMainFragment.this.getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                    new ConfirmationDialogFragment(NRMainFragment.this.getContext(), view2, NRMainFragment.this.configuration.getFeedbackConfirmationDialogBody(), NRMainFragment.this.configuration.getFeedbackConfirmationDialogButton(), NRMainFragment.this.configuration.getFeedbackConfirmationDialogTitle());
                }
            }
        });
    }

    private void onDismissDislike() {
        Nanorep.getInstance().getChanneling(this.articleId, false, (OnDataResponse)new OnDataResponse<List<NRChanneling>>(){

            public void onSuccess(List<NRChanneling> response) {
                View view = NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                if (view instanceof NRArticleView) {
                    NRQueryResult fetchedResult = ((NRArticleView)view).getmResult().getFetchedResult();
                    for (NRChanneling channel : response) {
                        channel.setQueryResult(fetchedResult);
                    }
                }
                NRMainFragment.this.channelView.setVisibility(0);
                NRMainFragment.this.channelView.setChanneling(response);
            }

            public void onError(NRConnectionException error) {
            }
        });
    }

    private void openDislikeDialog(final NRResult result, final NRArticleView view, final NRCustomLikeView likeView) {
        int dialogType = this.configuration.getFeedbackDialogType();
        if (dialogType != -1 && (dialogType != 2 && this.configuration.getFeedbackOptions() != null || dialogType == 2)) {
            View dislikeView = this.getActivity().getLayoutInflater().inflate(R.layout.dislike_dialog_mixed, null);
            DislikeDialog dislikeAlert = new DislikeDialog(this.getContext(), dislikeView, this.configuration.getFeedbackDialogType());
            dislikeAlert.setListener(new DislikeDialog.Listener(){

                @Override
                public void onCancel() {
                    likeView.resetLikeView();
                    NRMainFragment.this.onDismissDislike();
                }

                @Override
                public void onDislike(NRLikeType type, String feedbackText) {
                    NRMainFragment.this.onDislike(result, view, likeView, type, feedbackText);
                }
            });
        }
    }

    public static NRMainFragment newInstance() {
        Bundle args = new Bundle();
        NRMainFragment fragment = new NRMainFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof NRCustomViewAdapter) {
            this.viewAdapter = (NRCustomViewAdapter)context;
        }
    }

    private void initDataManager() {
        this.mFetchedDataManager = new NRFetchedDataManager(this.getContext(), new NRConfigFetcherListener(){

            @Override
            public void onConfigurationReady() {
                View view = NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) {
                    NRMainFragment.this.contentMain.removeView(view);
                }
                NRMainFragment.this.updateTitleNormalText();
                NRMainFragment.this.updateSearchBar();
                NRMainFragment.this.showSuggestionsView();
                NRMainFragment.this.mLoadingView.setVisibility(8);
            }

            @Override
            public void insertRows(ArrayList<NRFAQGroupItem> groups) {
                try {
                    NRMainFragment.this.hideKeyboard();
                    if (groups != null && groups.size() > 1 || Nanorep.getInstance().getAccountParams().isLabelsMode()) {
                        NRMainFragment.this.openCategoriesView(groups);
                    } else if (groups.size() == 1) {
                        NRMainFragment.this.mFetchedDataManager;
                        NRMainFragment.this.openNRResultView(NRFetchedDataManager.generateNRResultArray(groups.get(0).getAnswers(), NRMainFragment.this.getContext()), groups.get(0).getTitle());
                    }
                }
                catch (Exception e) {
                    return;
                }
            }

            @Override
            public void onError() {
                NRMainFragment.this.mLoadingView.setVisibility(8);
                NRMainFragment.this.noConnectionView.setVisibility(8);
                NRErrorView errorView = new NRErrorView(NRMainFragment.this.getContext());
                errorView.setListener(new NRErrorView.Listener(){

                    @Override
                    public void tryAgain() {
                        NRMainFragment.this.mFetchedDataManager.fetchConfiguration();
                        NRMainFragment.this.mLoadingView.setVisibility(0);
                    }
                });
                NRMainFragment.this.contentMain.addView((View)errorView);
            }

            @Override
            public void noResultFound(NRResult result) {
                NRMainFragment.this.hideKeyboard();
                NRArticleView resultTopView = NRMainFragment.this.getTopView();
                resultTopView.setVisibility(0);
                NRMainFragment.this.contentMain.setVisibility(0);
                NRMainFragment.this.contentMain.addView((View)resultTopView);
                NRMainFragment.this.presentResult(result, 0, resultTopView);
            }
        });
        this.mFetchedDataManager.setFetcherListener(new NRFetcherListener(){

            @Override
            public void reloadWithAnimation() {
            }

            @Override
            public void reload() {
            }

            @Override
            public void insertRows(List<NRResult> results, String userSelectedContext) {
                if (NRMainFragment.this.isDetached() || NRMainFragment.this.getContext() == null) {
                    return;
                }
                NRMainFragment.this.hideKeyboard();
                if (userSelectedContext == null || userSelectedContext.length() == 0) {
                    NRMainFragment.this.userSelectedContextLayout.setVisibility(8);
                } else {
                    NRMainFragment.this.userSelectedContextLayout.setVisibility(0);
                    StringBuilder builder = new StringBuilder();
                    for (String context : userSelectedContext.split(",")) {
                        String[] ctx = context.split(":");
                        if (ctx.length != 2) {
                            return;
                        }
                        if (builder.length() > 0) {
                            builder.append(", ");
                        }
                        builder.append(ctx[1]);
                    }
                    NRMainFragment.this.userSelectedContextTextView.setText((CharSequence)builder.toString());
                }
                if (results == null || results != null && results.size() == 0) {
                    if (NRMainFragment.this.searchBarView.getText() != null) {
                        while (NRMainFragment.this.contentMain.getChildCount() > 2) {
                            NRMainFragment.this.contentMain.removeViewAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                        }
                        NRMainFragment.this.contentMain.setVisibility(0);
                        NRMainFragment.this.requestFocus();
                    }
                } else if (results.size() == 1) {
                    NRResult currentResult = results.get(0);
                    NRMainFragment.this.articleId = currentResult.getFetchedResult().getId();
                    NRArticleView resultTopView = NRMainFragment.this.getTopView();
                    NRMainFragment.this.contentMain.setVisibility(0);
                    NRMainFragment.this.contentMain.addView((View)resultTopView);
                    Animation animation = AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_in_left);
                    animation.setAnimationListener(new Animation.AnimationListener(){

                        public void onAnimationStart(Animation animation) {
                            for (int i = 0; i <= NRMainFragment.this.contentMain.getChildCount() - 2; ++i) {
                                View view = NRMainFragment.this.contentMain.getChildAt(i);
                            }
                            NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1).setVisibility(0);
                        }

                        public void onAnimationEnd(Animation animation) {
                            for (int i = 0; i <= NRMainFragment.this.contentMain.getChildCount() - 2; ++i) {
                                View view = NRMainFragment.this.contentMain.getChildAt(i);
                            }
                        }

                        public void onAnimationRepeat(Animation animation) {
                        }
                    });
                    resultTopView.setAnimation(animation);
                    resultTopView.startAnimation(animation);
                    NRResult result = results.get(0);
                    result.setSingle(true);
                    resultTopView.openOpenedView(result);
                    NRMainFragment.this.requestFocus();
                } else if (results.size() > 1) {
                    NRMainFragment.this.contentMain.setVisibility(0);
                    NRMainFragment.this.openNRResultView(results, null);
                }
            }

            @Override
            public void presentSuggestion(String querytext, ArrayList<Spannable> suggestions) {
                if (!NRMainFragment.this.resetSuggestions && NRMainFragment.this.searchBarView.getText().length() - querytext.length() <= 1 && NRMainFragment.this.autocompleteEnabled) {
                    NRMainFragment.this.mSuggestionsView.setSuggestions(suggestions);
                    NRMainFragment.this.contentMain.setVisibility(4);
                }
            }

            @Override
            public void onConnectionFailed(HashMap<String, Object> errorParams) {
            }
        });
    }

    private void hideKeyboard() {
        View view = this.getView();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        Nanorep.getInstance().reset();
    }

    public void onPause() {
        super.onPause();
        this.fragmentPaused = true;
        NRErrorHandler.getInstance().setListener(null);
    }

    public void onResume() {
        super.onResume();
        if (this.fragmentPaused) {
            this.renewSession();
            this.fragmentPaused = false;
        }
    }

    private void renewSession() {
        if (Nanorep.getInstance().getSessionId() == null) {
            return;
        }
    }

    private void openCategoriesView(ArrayList<NRFAQGroupItem> groups) {
        this.categoriesView = new NRCategoriesView((Context)this.getActivity());
        if (Nanorep.getInstance().getAccountParams().isLabelsMode()) {
            this.categoriesView.setLabels(this);
        } else {
            this.categoriesView.setCategories(groups, this.viewAdapter, this);
        }
        this.contentMain.addView((View)this.categoriesView);
    }

    private NRArticleView getTopView() {
        NRCustomLikeView likeView;
        NRCustomContentView contentView;
        NRArticleView resultTopView = new NRArticleView((Context)this.getActivity());
        resultTopView.setListener(this);
        NRCustomTitleView titleView = this.viewAdapter.getTitle(this.getContext());
        if (titleView == null) {
            titleView = new NRTitleView(this.getContext());
            ((NRTitleView)titleView).configViewObjects(this.configuration);
        }
        if ((contentView = this.viewAdapter.getContent(this.getContext())) == null) {
            contentView = new NRContentView(this.getContext());
        }
        if (this.applicationContentListener != null) {
            contentView.setApplicationContentListener(this.applicationContentListener);
        }
        if ((likeView = this.viewAdapter.getLikeView(this.getContext())) == null) {
            likeView = new NRLikeView(this.getContext());
        }
        this.channelView = this.viewAdapter.getChannelView(this.getContext());
        if (this.channelView == null) {
            this.channelView = new NRChannelingView(this.getContext());
        }
        NRCustomFeedbackView feedbackView = this.viewAdapter.getFeedbackView(this.getContext());
        resultTopView.setTitleView(titleView);
        resultTopView.setContentView(contentView, this);
        if (feedbackView != null) {
            feedbackView.setCustomChannelView(this.channelView);
            feedbackView.setCustomLikeView(likeView);
            resultTopView.setLikeView(feedbackView.getCustomLikeView());
            resultTopView.setChannelView(feedbackView.getCustomChannelView(), this);
            resultTopView.setFeedbackView(feedbackView);
        } else {
            resultTopView.setLikeView(likeView);
            resultTopView.setChannelView(this.channelView, this);
        }
        return resultTopView;
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.configuration = Nanorep.getInstance().getNRConfiguration();
        if (this.viewAdapter == null) {
            this.viewAdapter = new NRViewAdapter();
        }
        NRErrorHandler.getInstance().setListener((NRErrorHandler.Listener)this);
        View view = inflater.inflate(R.layout.fragment_main, container, false);
        this.mLoadingView = (RelativeLayout)view.findViewById(R.id.fragment_place_holder);
        this.contentMain = (FrameLayout)view.findViewById(R.id.content_main);
        this.fragmentMainLayout = (LinearLayout)view.findViewById(R.id.fragment_main_layout);
        this.noConnectionView = (LinearLayout)view.findViewById(R.id.noConnectionView);
        this.userSelectedContextTextView = (TextView)view.findViewById(R.id.user_selected_context_textview);
        this.clearContextButton = (Button)view.findViewById(R.id.clear_user_selected_button);
        this.userSelectedContextLayout = (LinearLayout)view.findViewById(R.id.current_user_selected_context_layout);
        this.noResultsChannelingRecycler = (NRChannelingView)view.findViewById(R.id.channelingView);
        this.clearContextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NRMainFragment.this.onClearClicked(true);
                NRMainFragment.this.mFetchedDataManager.clearUserSelectedContext();
                NRMainFragment.this.userSelectedContextLayout.setVisibility(8);
                if (NRMainFragment.this.contentMain.getChildCount() > 1) {
                    NRMainFragment.this.removeTopView();
                }
            }
        });
        this.setViews(view);
        this.initDataManager();
        return view;
    }

    private void clearContextFromSession() {
        this.userSelectedContextLayout.setVisibility(8);
        Nanorep.getInstance().setContext(null, (OnDataResponse)new OnDataResponse<DefaultResponse>(){

            public void onSuccess(DefaultResponse response) {
            }

            public void onError(NRConnectionException error) {
            }
        });
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = this.configuration.getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = this.configuration.getSearchBar();
        this.searchBarView.setHint(searchBarConfig.getInitialText());
        String titleBGColor = "#0aa0ff";
        if (!NRMainFragment.isEmpty(titleConfig.getTitleBGColor())) {
            titleBGColor = titleConfig.getTitleBGColor();
        }
        this.searchBarContainer.setBackgroundColor(Color.parseColor((String)titleBGColor));
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = this.configuration.getTitle();
        ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
        if (actionBar == null) {
            return;
        }
        View customActionBar = this.getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
        ActionBar.LayoutParams layout2 = new ActionBar.LayoutParams(-1, -1);
        actionBar.setCustomView(customActionBar, layout2);
        actionBar.setDisplayShowHomeEnabled(false);
        actionBar.setDisplayShowTitleEnabled(false);
        actionBar.setDisplayShowCustomEnabled(true);
        Toolbar parent = (Toolbar)customActionBar.getParent();
        parent.setPadding(0, 0, 0, 0);
        parent.setContentInsetsAbsolute(0, 0);
        this.actionBarTextView = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
        String titleText = this.configuration.getTitleText();
        this.setActionBarTitleText(titleText);
        if (!NRMainFragment.isEmpty(title.getTitleColor())) {
            String titleColor = title.getTitleColor();
            this.actionBarTextView.setTextColor(Color.parseColor((String)titleColor));
        }
        if (!NRMainFragment.isEmpty(title.getTitleBGColor())) {
            String titleBGColor = title.getTitleBGColor();
            RelativeLayout relativeLayout = (RelativeLayout)actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
            relativeLayout.setBackgroundColor(Color.parseColor((String)titleBGColor));
        }
        if (!NRMainFragment.isEmpty(title.getTitleFont())) {
            String titleFont = title.getTitleFont();
            this.actionBarTextView.setTypeface(Typeface.create((String)titleFont, (int)0));
        }
    }

    private void setActionBarTitleText(String title) {
        if (this.getActivity() != null) {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }
            String fixedTitle = Nanorep.getInstance().getAccountParams().getFixedTitle();
            TextView tv = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
            tv.setText((CharSequence)(fixedTitle != null ? fixedTitle : title));
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private void setViews(View nanoView) {
        this.mSuggestionViewContainer = (LinearLayout)nanoView.findViewById(R.id.suggestion_view_container);
        this.mSuggestionsView = this.viewAdapter.getSuggestionsView(this.getContext());
        if (this.mSuggestionsView == null) {
            this.mSuggestionsView = new NRSuggestionsView(this.getContext());
        }
        this.mSuggestionsView.setListener(this);
        if (this.mSuggestionsView.getParent() != null) {
            ((LinearLayout)this.mSuggestionsView.getParent()).removeView((View)this.mSuggestionsView);
        }
        this.mSuggestionViewContainer.addView((View)this.mSuggestionsView);
        this.searchBarContainer = (LinearLayout)nanoView.findViewById(R.id.search_bar_container);
        this.searchBarView = this.viewAdapter.getSearchBar(this.getContext());
        if (this.searchBarView == null) {
            this.searchBarView = new NRSearchBar(this.getContext());
        }
        this.searchBarView.setListener(this);
        if (this.searchBarView.getParent() != null) {
            ((LinearLayout)this.searchBarView.getParent()).removeView((View)this.searchBarView);
        }
        this.searchBarContainer.addView((View)this.searchBarView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
    }

    @Override
    public void onStartRecording(ImageButton button) {
    }

    @Override
    public void fetchSuggestionsForText(String text) {
        this.hideNoResultsView();
        this.resetSuggestions = false;
        this.mFetchedDataManager.searchSuggestion(text);
    }

    @Override
    public void searchForText(String text) {
        this.resetSuggestions = true;
        this.mSuggestionsView.setSuggestions(null);
        this.mFetchedDataManager.searchText(text);
    }

    @Override
    public void onClearClicked(boolean byUser) {
        this.resetSuggestions = true;
        this.mSuggestionsView.setSuggestions(null);
        while (this.contentMain.getChildCount() > 1) {
            this.contentMain.removeViewAt(this.contentMain.getChildCount() - 1);
        }
        String titleText = this.configuration.getTitleText();
        this.setActionBarTitleText(titleText);
        this.clearContextFromSession();
        this.contentMain.setVisibility(0);
        this.setLoadingState(false);
    }

    @Override
    public void clearAutoComplete() {
        this.mSuggestionsView.setSuggestions(null);
        this.contentMain.setVisibility(0);
    }

    @Override
    public void onEmptyQuery() {
    }

    private void hideNoResultsView() {
    }

    @Override
    public void onSelectSuggestion(String suggestion) {
        this.resetSuggestions = true;
        this.searchBarView.dismissKeyboard();
        this.searchBarView.updateEditTextView(suggestion);
        this.resetSuggestions = true;
        this.mSuggestionsView.setSuggestions(null);
        this.mFetchedDataManager.searchText(suggestion);
    }

    private void showSuggestionsView() {
        if (!this.configuration.getAutocompleteEnabled()) {
            this.autocompleteEnabled = false;
        }
    }

    @Override
    public void onResultSelected(final int y, NRResultsAdapter.ViewHolder titleViewHolder) {
        if (this.isBouncing()) {
            return;
        }
        this.setLoadingState(true);
        this.hideKeyboard();
        final NRArticleView resultTopView = this.getTopView();
        final NRResult result = titleViewHolder.getResult();
        this.searchBarView.showLabelLayout(true, this.currentLabel.getTitle());
        if (result.getFetchedResult().getBody() == null) {
            this.articleId = result.getFetchedResult().getId();
            this.mFetchedDataManager.faqAnswer(result.getFetchedResult().getId(), null, new OnFAQAnswerFetched(){

                @Override
                public void onAnswerFetched(NRQueryResult queryResult) {
                    if (queryResult != null) {
                        resultTopView.setVisibility(8);
                        NRMainFragment.this.contentMain.addView((View)resultTopView);
                        result.setFetchedResult(queryResult);
                        NRMainFragment.this.presentResult(result, y, resultTopView);
                    } else {
                        NRMainFragment.this.show(NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE);
                    }
                }
            });
        } else {
            resultTopView.setVisibility(8);
            this.contentMain.addView((View)resultTopView);
            this.presentResult(result, y, resultTopView);
        }
    }

    private void presentResult(NRResult result, int y, NRArticleView resultTopView) {
        if (this.getContext() == null) {
            return;
        }
        this.setLoadingState(false);
        result.setUnfolded(true);
        resultTopView.setVisibility(0);
        resultTopView.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_in_left));
        if (result.getFetchedResult() == null) {
            resultTopView.showNoResult(result);
        } else {
            resultTopView.openOpenedView(result);
        }
        this.requestFocus();
    }

    private void requestFocus() {
        if (this.getView() != null) {
            this.getView().requestFocus();
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (this.getView() != null) {
            this.getView().setFocusableInTouchMode(true);
            this.getView().requestFocus();
        }
        this.onKeyListener = new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 0) {
                    if (keyCode == 4) {
                        NRMainFragment.this.hideNoResultsView();
                        if (NRMainFragment.this.getFragmentManager().getBackStackEntryCount() == 1) {
                            NRMainFragment.this.getFragmentManager().popBackStack();
                            return true;
                        }
                        if (NRMainFragment.this.mSuggestionsView.getHeight() > 0) {
                            NRMainFragment.this.resetSuggestions = true;
                            NRMainFragment.this.mSuggestionsView.setSuggestions(null);
                            NRMainFragment.this.contentMain.setVisibility(0);
                            return true;
                        }
                        if (NRMainFragment.this.contentMain.getChildCount() > 1) {
                            View view = NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                            if (!NRMainFragment.this.animation) {
                                if (view instanceof NRArticleView && NRMainFragment.this.currentLabel != null) {
                                    view.startAnimation(AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_out_left));
                                    NRMainFragment.this.searchBarView.showLabelLayout(true, NRMainFragment.this.currentLabel.getTitle());
                                } else if (view instanceof NRResultsView) {
                                    NRMainFragment.this.searchBarView.showLabelLayout(false, "");
                                    NRMainFragment.this.searchBarView.updateEditTextView("");
                                }
                                NRMainFragment.this.removeTopView();
                            } else if (view instanceof NRArticleView) {
                                if (!((NRArticleView)view).getmResult().isSingle()) {
                                    ((NRArticleView)view).setResultUnFoldState(false);
                                    ((NRArticleView)view).removeTopView();
                                    NRMainFragment.this.updateSearchBarTextForResultTop(view);
                                } else {
                                    view.startAnimation(AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_out_left));
                                    NRMainFragment.this.removeTopView();
                                }
                            } else {
                                NRMainFragment.this.removeTopView();
                            }
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }
        };
        if (this.getView() != null) {
            this.getView().setOnKeyListener(this.onKeyListener);
        }
    }

    private void removeTopView() {
        this.noConnectionView.setVisibility(8);
        if (this.contentMain.getChildCount() == 2 && this.currentLabel != null) {
            this.clearContextFromSession();
            this.currentLabel = null;
        }
        this.contentMain.removeViewAt(this.contentMain.getChildCount() - 1);
        View currentView = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        currentView.setVisibility(0);
        if (currentView instanceof NRArticleView) {
            this.updateSearchBarTextForResultTop(currentView);
        } else {
            this.searchBarView.updateEditTextView("");
            this.requestFocus();
            String title = this.configuration.getTitleText();
            if (currentView instanceof NRResultsView && !NRMainFragment.isEmpty(((NRResultsView)currentView).getTitle())) {
                title = ((NRResultsView)currentView).getTitle();
            }
            this.setActionBarTitleText(this.currentLabel == null ? title : this.currentLabel.getTitle());
        }
        this.setLoadingState(false);
    }

    private void updateSearchBarTextForResultTop(View view) {
        if (((NRArticleView)view).getmResult() != null && ((NRArticleView)view).getmResult().getFetchedResult() instanceof NRAnswer) {
            this.searchBarView.updateEditTextView(((NRArticleView)view).getmResult().getFetchedResult().getTitle());
            this.resetSuggestions = true;
            this.mSuggestionsView.setSuggestions(null);
            this.contentMain.setVisibility(0);
            this.requestFocus();
        }
    }

    private void fadeViews(View view, float f, long duration, final boolean removeTopTitle) {
        view.animate().alpha(f).setDuration(duration).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (removeTopTitle) {
                    NRMainFragment.this.contentMain.removeViewAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) {
        if (beforeGoingDown) {
            this.animateBGColor(50, this.contentMain.getChildAt(this.contentMain.getChildCount() - 1), false, null);
        } else {
            this.fadeViews(this.contentMain.getChildAt(this.contentMain.getChildCount() - 1), 0.0f, 500L, true);
        }
    }

    private void animateBGColor(int milliseconds, final View view, final boolean unfold, NRResultsAdapter.ViewHolder titleViewHolder) {
        int colorFrom = this.getResources().getColor(R.color.nr_background_color);
        int colorTo = this.getResources().getColor(R.color.white);
        if (!unfold) {
            colorFrom = -1;
            colorTo = this.getResources().getColor(R.color.nr_background_color);
        }
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration((long)milliseconds);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                view.setBackgroundColor(((Integer)animator.getAnimatedValue()).intValue());
            }
        });
        colorAnimation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (unfold) {
                    // empty if block
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        if (unfold) {
            colorAnimation.setStartDelay(300L);
        }
        colorAnimation.start();
    }

    public void show(NRErrorHandler.ErrorType errorType) {
        switch (errorType) {
            case TIMEOUT_UPPER_LINE: {
                View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) break;
                this.noConnectionView.setVisibility(0);
                this.searchBarView.dismissKeyboard();
            }
        }
    }

    public void dismiss() {
        if (this.noConnectionView == null) {
            return;
        }
        this.noConnectionView.setVisibility(8);
    }

    @Override
    public void onLabelSelected(final NRLabel label) {
        if (this.isBouncing()) {
            return;
        }
        this.setLoadingState(true);
        this.currentLabel = label;
        Nanorep.getInstance().setContext(label.getContext(), (OnDataResponse)new OnDataResponse<DefaultResponse>(){

            public void onSuccess(DefaultResponse response) {
                NRMainFragment.this.mFetchedDataManager.fetchLabelFAQ(label, NRMainFragment.this.searchBarView);
            }

            public void onError(NRConnectionException error) {
                NRMainFragment.this.show(NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE);
            }
        });
    }

    private boolean isBouncing() {
        long currentTime = System.currentTimeMillis();
        long threshold = 300L;
        if (currentTime - this.previousClickTime < 300L) {
            return true;
        }
        this.previousClickTime = currentTime;
        return false;
    }

    @Override
    public void onCategorySelected(NRFAQGroupItem groupItem) {
        if (this.isBouncing()) {
            return;
        }
        this.setLoadingState(true);
        this.openNRResultView(NRFetchedDataManager.generateNRResultArray(groupItem.getAnswers(), this.getContext()), groupItem.getTitle());
    }

    private void openNRResultView(List<NRResult> results, String title) {
        try {
            this.setLoadingState(false);
            NRResultsView resultsView = new NRResultsView((Context)this.getActivity());
            resultsView.setListener(this);
            resultsView.setResults(results, title, this.viewAdapter);
            resultsView.setIsAnimated(this.animation);
            if (!NRMainFragment.isEmpty(title)) {
                this.setActionBarTitleText(title);
            }
            this.contentMain.addView((View)resultsView);
            this.requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setLoadingState(boolean state) {
        if (this.contentMain.getChildCount() == 0) {
            return;
        }
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRCategoriesView) {
            ((NRCategoriesView)view).setLoading(state);
        } else if (view instanceof NRResultsView) {
            ((NRResultsView)view).setLoading(state);
        }
    }
}

