/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Fragments;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingPhoneNumber;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRExtraDataListener;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresentor;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.ChannelPresenters.NRCustomScriptChannelPresentor;
import nanorep.nanowidget.Components.ConfirmationDialogFragment;
import nanorep.nanowidget.Components.DislikeDialog;
import nanorep.nanowidget.Components.MyWebView;
import nanorep.nanowidget.Components.NRArticleView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRLikeView;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRTitleView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.Fragments.NRWebContentFragment;
import nanorep.nanowidget.R;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

public class DeepLinkFragment
extends Fragment
implements NRArticleView.Listener,
NRErrorHandler.Listener,
NRChannelItem.OnChannelSelectedListener,
NRContentView.Listener,
Nanorep.NanoRepWidgetListener {
    private static final String ARTICLE_ID = "articleId";
    private FrameLayout contentMain;
    private NRCustomViewAdapter viewAdapter;
    private NRFetchedDataManager mFetchedDataManager;
    private NRConfiguration configuration;
    private LinearLayout noConnectionView;
    private NRCustomChannelView channelView;
    private String articleId;
    private static AccountParams params;

    public static DeepLinkFragment newInstance(String articleId, AccountParams accountParams) {
        Bundle args = new Bundle();
        args.putString(ARTICLE_ID, articleId);
        params = accountParams;
        DeepLinkFragment fragment = new DeepLinkFragment();
        fragment.setArguments(args);
        return fragment;
    }

    private void initDataManager() {
        this.mFetchedDataManager = new NRFetchedDataManager(this.getContext(), new NRConfigFetcherListener(){

            @Override
            public void onConfigurationReady() {
            }

            @Override
            public void insertRows(ArrayList<NRFAQGroupItem> groups) {
            }

            @Override
            public void onError() {
            }

            @Override
            public void noResultFound(NRResult response) {
            }
        });
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_deeplink, container, false);
        Nanorep.initialize((AccountParams)params, (Nanorep.NanoRepWidgetListener)this);
        Nanorep.getInstance().setHttpRequestTimeout(15);
        this.noConnectionView = (LinearLayout)view.findViewById(R.id.noConnectionView);
        this.contentMain = (FrameLayout)view.findViewById(R.id.content_main);
        this.viewAdapter = new NRViewAdapter();
        this.articleId = this.getArguments().getString(ARTICLE_ID);
        return view;
    }

    private NRArticleView getTopView() {
        NRCustomLikeView likeView;
        NRCustomContentView contentView;
        NRArticleView resultTopView = new NRArticleView((Context)this.getActivity());
        resultTopView.setListener(this);
        NRCustomTitleView titleView = this.viewAdapter.getTitle(this.getContext());
        if (titleView == null) {
            titleView = new NRTitleView(this.getContext());
            ((NRTitleView)titleView).configViewObjects(this.configuration);
        }
        if ((contentView = this.viewAdapter.getContent(this.getContext())) == null) {
            contentView = new NRContentView(this.getContext());
        }
        if ((likeView = this.viewAdapter.getLikeView(this.getContext())) == null) {
            likeView = new NRLikeView(this.getContext());
        }
        this.channelView = this.viewAdapter.getChannelView(this.getContext());
        if (this.channelView == null) {
            this.channelView = new NRChannelingView(this.getContext());
        }
        NRCustomFeedbackView feedbackView = this.viewAdapter.getFeedbackView(this.getContext());
        resultTopView.setTitleView(titleView);
        resultTopView.setContentView(contentView, this);
        if (feedbackView != null) {
            feedbackView.setCustomChannelView(this.channelView);
            feedbackView.setCustomLikeView(likeView);
            resultTopView.setLikeView(feedbackView.getCustomLikeView());
            resultTopView.setChannelView(feedbackView.getCustomChannelView(), this);
            resultTopView.setFeedbackView(feedbackView);
        } else {
            resultTopView.setLikeView(likeView);
            resultTopView.setChannelView(this.channelView, this);
        }
        return resultTopView;
    }

    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) {
    }

    @Override
    public void fetchBodyForResult(final NRCustomContentView view, String resultID, Integer resultHash) {
        this.articleId = resultID;
        this.mFetchedDataManager.faqAnswer(resultID, resultHash, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                if (result != null) {
                    view.loadData(result.getBody(), "text/html", "UTF-8");
                }
            }
        });
    }

    @Override
    public void closeAnswer() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView && !((NRArticleView)view).getmResult().isSingle()) {
            ((NRArticleView)view).setResultUnFoldState(false);
            ((NRArticleView)view).removeTopView();
        }
        this.contentMain.removeView(view);
    }

    @Override
    public void onLikeClicked(final NRArticleView view, final NRCustomLikeView likeView, String resultId, boolean isLike) {
        NRQueryResult result = view.getmResult().getFetchedResult();
        if (isLike) {
            result.setLikeState(NRQueryResult.LikeState.positive);
            this.mFetchedDataManager.sendLike(NRLikeType.POSITIVE, "", result, new Nanorep.OnLikeSentListener(){

                public void onLikeSent(boolean success) {
                    if (!success) {
                        view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                        likeView.resetLikeView();
                    } else {
                        View view2 = DeepLinkFragment.this.getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                        new ConfirmationDialogFragment(DeepLinkFragment.this.getContext(), view2, DeepLinkFragment.this.configuration.getFeedbackConfirmationDialogBody(), DeepLinkFragment.this.configuration.getFeedbackConfirmationDialogButton(), DeepLinkFragment.this.configuration.getFeedbackConfirmationDialogTitle());
                    }
                }
            });
        } else if (likeView.shouldOpenDialog()) {
            this.openDislikeDialog(result, view, likeView);
        } else {
            this.onDislike(result, view, likeView, NRLikeType.INCORRECT_ANSWER, "");
        }
    }

    private void openDislikeDialog(final NRQueryResult result, final NRArticleView view, final NRCustomLikeView likeView) {
        int dialogType = this.configuration.getFeedbackDialogType();
        if (dialogType != -1 && (dialogType != 2 && this.configuration.getFeedbackOptions() != null || dialogType == 2)) {
            View dislikeView = this.getActivity().getLayoutInflater().inflate(R.layout.dislike_dialog_mixed, null);
            DislikeDialog dislikeAlert = new DislikeDialog(this.getContext(), dislikeView, this.configuration.getFeedbackDialogType());
            dislikeAlert.setListener(new DislikeDialog.Listener(){

                @Override
                public void onCancel() {
                    likeView.resetLikeView();
                    DeepLinkFragment.this.onDismissDislike();
                }

                @Override
                public void onDislike(NRLikeType type, String feedbackText) {
                    DeepLinkFragment.this.onDislike(result, view, likeView, type, feedbackText);
                }
            });
        }
    }

    private void onDismissDislike() {
        Nanorep.getInstance().getChanneling(this.articleId, false, (OnDataResponse)new OnDataResponse<List<NRChanneling>>(){

            public void onSuccess(List<NRChanneling> response) {
                View view = DeepLinkFragment.this.contentMain.getChildAt(DeepLinkFragment.this.contentMain.getChildCount() - 1);
                if (view instanceof NRArticleView) {
                    NRQueryResult fetchedResult = ((NRArticleView)view).getmResult().getFetchedResult();
                    for (NRChanneling channel : response) {
                        channel.setQueryResult(fetchedResult);
                    }
                }
                DeepLinkFragment.this.channelView.setVisibility(0);
                DeepLinkFragment.this.channelView.setChanneling(response);
            }

            public void onError(NRConnectionException error) {
            }
        });
    }

    private void onDislike(NRQueryResult result, final NRArticleView view, final NRCustomLikeView likeView, NRLikeType type, String feedbackText) {
        result.setLikeState(NRQueryResult.LikeState.negative);
        this.mFetchedDataManager.sendLike(type, feedbackText, result, new Nanorep.OnLikeSentListener(){

            public void onLikeSent(boolean success) {
                if (!success) {
                    view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                    Toast.makeText((Context)DeepLinkFragment.this.getContext(), (CharSequence)DeepLinkFragment.this.getResources().getString(R.string.feedback_error_message), (int)1).show();
                    DeepLinkFragment.this.removeTopView();
                } else {
                    View view2 = DeepLinkFragment.this.getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                    new ConfirmationDialogFragment(DeepLinkFragment.this.getContext(), view2, DeepLinkFragment.this.configuration.getFeedbackConfirmationDialogBody(), DeepLinkFragment.this.configuration.getFeedbackConfirmationDialogButton(), DeepLinkFragment.this.configuration.getFeedbackConfirmationDialogTitle());
                }
            }
        });
    }

    public void show(NRErrorHandler.ErrorType errorType) {
        switch (errorType) {
            case TIMEOUT_UPPER_LINE: {
                View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) break;
                this.noConnectionView.setVisibility(0);
            }
        }
    }

    public void dismiss() {
        if (this.noConnectionView == null) {
            return;
        }
        this.noConnectionView.setVisibility(8);
    }

    @Override
    public void onChannelSelected(final NRChanneling channel) {
        String extraData;
        NRQueryResult currentResult = this.getCurrentResult();
        if (currentResult == null || currentResult.getExtraData() == null) {
            if (channel.getNoResultExtra() == null) {
                this.openChannel(channel);
                return;
            }
            extraData = channel.getNoResultExtra();
        } else {
            extraData = this.getCurrentResult().getExtraData();
        }
        Nanorep.getInstance().getWidgetListener().personalInfoWithExtraData(channel.getChannelDescription(), extraData, new NRExtraDataListener(){

            public void onExtraData(Map<String, String> extraData) {
                channel.setExtraData(extraData);
                DeepLinkFragment.this.openChannel(channel);
            }
        });
    }

    private void openChannel(NRChanneling channeling) {
        NRChannelPresentor presentor = NRChannelStrategy.presentor(this.getContext(), channeling, Nanorep.getInstance());
        if (presentor instanceof NRCustomScriptChannelPresentor) {
            presentor.present();
        } else {
            String url = presentor.getUrl();
            if (url != null) {
                RelativeLayout holder = (RelativeLayout)this.getView().findViewById(R.id.fragment_place_holder);
                holder.setVisibility(0);
                NRWebContentFragment webContentFragment = NRWebContentFragment.newInstance(url, channeling.getThankYouMessage(), this.configuration.getFeedbackConfirmationDialogTitle(), this.configuration.getFeedbackConfirmationDialogButton());
                webContentFragment.setListener(new NRWebContentFragment.WebFormListener(){

                    @Override
                    public void onDismiss(String result) {
                        if (result == null) {
                            DeepLinkFragment.this.getFragmentManager().popBackStack();
                        }
                        InputMethodManager imm = (InputMethodManager)DeepLinkFragment.this.getContext().getSystemService("input_method");
                        imm.hideSoftInputFromWindow(DeepLinkFragment.this.getView().getWindowToken(), 0);
                        DeepLinkFragment.this.requestFocus();
                    }
                });
                this.getFragmentManager().beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(R.id.content_main, (Fragment)webContentFragment).addToBackStack("linked").commit();
            } else if (channeling.getType() == NRChanneling.NRChannelingType.PhoneNumber) {
                String phoneNumber = ((NRChannelingPhoneNumber)channeling).getPhoneNumber();
                String channelName = ((NRChannelingPhoneNumber)channeling).getName();
                Intent intent = new Intent("android.intent.action.DIAL", Uri.fromParts((String)"tel", (String)phoneNumber, null));
                intent.setFlags(0x10008000);
                try {
                    this.startActivity(intent);
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    // empty catch block
                }
                Nanorep.getInstance().reportChanneling(this.articleId, "5", channelName);
            }
        }
    }

    private void requestFocus() {
        if (this.getView() != null) {
            this.getView().requestFocus();
        }
    }

    private NRQueryResult getCurrentResult() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            return ((NRArticleView)view).getmResult().getFetchedResult();
        }
        return null;
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
        this.mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                NRResult newResult = new NRResult(result, NRResultItem.RowType.TITLE);
                int height = Integer.valueOf(DeepLinkFragment.this.configuration.getTitle().getTitleRowHeight());
                newResult.setHeight((int)Calculate.pxFromDp(DeepLinkFragment.this.getContext(), height));
                newResult.setSingle(true);
                NRArticleView resultTopView = DeepLinkFragment.this.getTopView();
                DeepLinkFragment.this.contentMain.addView((View)resultTopView);
                resultTopView.startAnimation(AnimationUtils.loadAnimation((Context)DeepLinkFragment.this.getContext(), (int)R.anim.slide_in_left));
                resultTopView.openOpenedView(newResult);
                DeepLinkFragment.this.requestFocus();
            }
        });
    }

    @Override
    public void onLinkClicked(String url) {
        if (Nanorep.getInstance().getAccountParams().isOpenLinksInternally()) {
            MyWebView webView = new MyWebView(this.getContext(), url, new MyWebView.Listener(){

                @Override
                public void onDismiss() {
                    DeepLinkFragment.this.contentMain.removeViewAt(DeepLinkFragment.this.contentMain.getChildCount() - 1);
                    DeepLinkFragment.this.requestFocus();
                }
            });
            this.contentMain.addView((View)webView);
            this.requestFocus();
        } else {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            try {
                this.startActivity(intent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onDismiss() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            view.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_out_left));
        }
        this.removeTopView();
    }

    private void removeTopView() {
        this.contentMain.removeViewAt(this.contentMain.getChildCount() - 1);
    }

    public void personalInfoWithExtraData(String channelDescription, String extraData, NRExtraDataListener listener) {
        HashMap map = new HashMap();
        listener.onExtraData(map);
    }

    public void onSubmitSupportForm(String formData, ArrayList<String> fileUploadPaths) {
    }

    public void onConfigurationFetched() {
        this.configuration = Nanorep.getInstance().getNRConfiguration();
        this.initDataManager();
        final NRArticleView resultTopView = this.getTopView();
        this.mFetchedDataManager.faqAnswer(this.articleId, null, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult queryResult) {
                if (queryResult != null) {
                    NRResult deepLinkingResult = new NRResult(queryResult, null);
                    resultTopView.setResult(deepLinkingResult);
                    DeepLinkFragment.this.contentMain.addView((View)resultTopView);
                    resultTopView.openOpenedView(deepLinkingResult);
                } else {
                    DeepLinkFragment.this.show(NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE);
                }
            }
        });
    }

    public void onCachedImageRequest(String url, Nanorep.NRCachedImageResponder responder) {
    }

    public void onInitializationFailure() {
    }
}

