package nanorep.nanowidget.Fragments;


import android.Manifest;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.OpenableColumns;
import android.support.annotation.RequiresApi;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ClientCertRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import android.widget.Toast;

import com.nanorep.nanoclient.Connection.NRConnection;
import com.nanorep.nanoclient.Handlers.UriToPathHandler;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.network.OnDataResponse;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;

import nanorep.nanowidget.Components.ConfirmationDialogFragment;
import nanorep.nanowidget.R;

import static android.app.Activity.RESULT_OK;

/**
 * A simple {@link Fragment} subclass.
 */
public class NRWebContentFragment extends Fragment {

    private static final String ARG_URL = "param1";
    private static final int FILE_CHOOSER_REQUEST = 100;
    private static final int FILE_CHOOSER_REQUEST_FROM_SCRIPT = 101;
    private static final String CHANNEL_CONFIRMATION_TEXT = "channelConfirmationText";
    private static final String CHANNEL_CONFIRMATION_TITLE = "channelConfirmationTitle";
    private static final String CHANNEL_CONFIRMATION_BUTTON = "channelConfirmationButton";

    private WebView mWebView;
    private WebFormListener mListener;
    private ValueCallback<Uri[]> mValueCallback;
    private WebChromeClient.FileChooserParams mFileChooserParams;
    private RelativeLayout mLoadingView;
    private Uri fileUploadUri;
    private ArrayList<String> fileUploadPaths;
    private String channelConfirmationText;
    private String channelConfirmationButton;
    private String channelConfirmationTitle;
    private String stringUrl;
    private String script = "\n(function(){\n" +
            "\n" +
            "\tfunction overrideComponent(container) {\n" +
            "\t  var fileInput = container.querySelector('input[type=\"file\"]'),\n" +
            "\t\t  fileButton = container.querySelector('input[type=\"button\"]'),\n" +
            "\t\t  fileList = container.querySelector('.nr-fileuploader-list');\n" +
            "   \n" +
            "\t  fileInput.parentNode.removeChild(fileInput);\n" +
            "\t  fileButton.onclick = function() {\n" +
            "\t\tlocation.href = 'nanorep://contactForm/attachFile';\n" +
            "\t  }\n" +
            "   \n" +
            "\t  window.nativeFileAttached = function(fileName) {\n" +
            "\t\tvar row = document.createElement('div'),\n" +
            "\t\t\titem = document.createElement('div'),\n" +
            "\t\t\ticon = document.createElement('div'),\n" +
            "\t\t\tfile = document.createElement('span'),\n" +
            "\t\t\tbtnRemove = document.createElement('a');\n" +
            "   \n" +
            "\t\trow.className = 'attachmentRow';\n" +
            "\t\titem.className = 'attachment';\n" +
            "\t\ticon.className = 'attachmentIcon';\n" +
            "\t\tbtnRemove.className = 'deleteFileLink';\n" +
            "\t\tfile.appendChild(document.createTextNode(fileName))\n" +
            "   \n" +
            "\t\tbtnRemove.onclick = function() {\n" +
            "\t\t  var rowIndex = getRowIndex(row);\n" +
            "\t\t  row.parentNode.removeChild(row);\n" +
            "\t\t  location.href = 'nanorep://contactForm/removeFile?index=' + rowIndex;\n" +
            "\t\t}\n" +
            "   \n" +
            "\t\titem.appendChild(icon);\n" +
            "\t\titem.appendChild(file);\n" +
            "\t\titem.appendChild(btnRemove);\n" +
            "\t\trow.appendChild(item);\n" +
            "\t\tfileList.appendChild(row);\n" +
            "\t  }\n" +
            "   \n" +
            "\t  function getRowIndex(row) {\n" +
            "\t\tvar index = -1;\n" +
            "\t\tfor (var i = 0; i < fileList.children.length; i++) {\n" +
            "\t\t  if (fileList.children[i] === row) {\n" +
            "\t\t\tindex = i;\n" +
            "\t\t\tbreak;\n" +
            "\t\t  }\n" +
            "\t\t}\n" +
            "\t\treturn index;\n" +
            "\t  }\n" +
            "\t}\n" +
            "   \n" +
            "   \n" +
            "\tfunction modifyFormBehavior() {\n" +
            "\t  var fileInputs = document.querySelectorAll('.CF_fileUploadComp');\n" +
            "\t  for (var i = 0; i < fileInputs.length; i++) {\n" +
            "\t\toverrideComponent(fileInputs[i]);\n" +
            "\t  }\n" +
            "\t}\n" +
            "   \n" +
            "\tvar formReadyTimer = setInterval(function() {\n" +
            "\t  if (document.querySelector('.CF_fileUploadComp')) {\n" +
            "\t\tclearTimeout(formReadyTimer);\n" +
            "\t\tmodifyFormBehavior();\n" +
            "\t  }\n" +
            "\t}, 100);\n" +
            "   \n" +
            "   }());\n";





    public NRWebContentFragment() {
        // Required empty public constructor
    }

    public static NRWebContentFragment newInstance(String url) {
        NRWebContentFragment fragment = new NRWebContentFragment();
        Bundle args = new Bundle();
        args.putString(ARG_URL, url);
        fragment.setArguments(args);
        return fragment;
    }

    // TODO: Rename and change types and number of parameters
    public static NRWebContentFragment newInstance(String url, String channelConfirmationText, String channelConfirmationTitle, String channelConfirmationButton) {
        NRWebContentFragment fragment = new NRWebContentFragment();
        Bundle args = new Bundle();
        args.putString(ARG_URL, url);
        args.putString(CHANNEL_CONFIRMATION_TEXT, channelConfirmationText);
        args.putString(CHANNEL_CONFIRMATION_TITLE, channelConfirmationTitle);
        args.putString(CHANNEL_CONFIRMATION_BUTTON, channelConfirmationButton);
        fragment.setArguments(args);
        return fragment;
    }

    public void setListener(WebFormListener listener) {
        mListener = listener;
    }

    @SuppressLint("SetJavaScriptEnabled")
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.fragment_nrweb_content, container, false);

        mLoadingView = (RelativeLayout) view.findViewById(R.id.webLoadingView);

        mWebView = (WebView) view.findViewById(R.id.webContentView);

        fileUploadPaths = new ArrayList<>();

        if (getArguments() != null) {
            channelConfirmationButton = getArguments().getString(CHANNEL_CONFIRMATION_BUTTON);
            channelConfirmationText = getArguments().getString(CHANNEL_CONFIRMATION_TEXT);
            channelConfirmationTitle = getArguments().getString(CHANNEL_CONFIRMATION_TITLE);
            stringUrl = getArguments().getString(ARG_URL);
        }

        mWebView.getSettings().setJavaScriptEnabled(true);
        mWebView.getSettings().setAllowFileAccess(true);
        mWebView.getSettings().setAllowContentAccess(true);
        mWebView.getSettings().setAllowFileAccessFromFileURLs(true);
        mWebView.setWebViewClient(new NRPresentorWebClient());

        if (Nanorep.getInstance().getWidgetListener() != null) {
            try {
                URL url = new URL(stringUrl);
                Uri.Builder builder = Uri.parse(String.valueOf(url.toURI())).buildUpon();
                NRConnection.connection(builder, new OnDataResponse<String>() {

                    @Override
                    public void onSuccess(String response) {
                        String html_first_part = response.substring(0, response.indexOf("<script>") + "<script>".length());
                        String html_first_part_with_script = html_first_part + script;
                        String upgradedHtml = html_first_part_with_script + response.substring(html_first_part.length());
                        mWebView.loadDataWithBaseURL(stringUrl, upgradedHtml,"text/html", "UTF-8", "");
                    }

                    @Override
                    public void onError(NRConnectionException error) {

                    }
                });

            } catch (MalformedURLException e) {
                e.printStackTrace();
            } catch (URISyntaxException e) {
                e.printStackTrace();
            }
        } else {
            mWebView.loadUrl(getArguments().getString(ARG_URL));
            mWebView.setWebChromeClient(new WebChromeClient() {
                @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
                @Override
                public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, FileChooserParams fileChooserParams) {
                    mValueCallback = filePathCallback;
                    mFileChooserParams = fileChooserParams;
                    if (ContextCompat.checkSelfPermission(getActivity(),
                            Manifest.permission.READ_EXTERNAL_STORAGE)
                            != PackageManager.PERMISSION_GRANTED) {
                        ActivityCompat.requestPermissions(getActivity(),
                                new String[]{Manifest.permission.READ_EXTERNAL_STORAGE},
                                FILE_CHOOSER_REQUEST);
                    }
                    Intent intent = mFileChooserParams.createIntent();
                    try {
                        startActivityForResult(intent, FILE_CHOOSER_REQUEST);
                    } catch (ActivityNotFoundException e) {
                        Toast.makeText(getActivity().getApplicationContext(), "Cannot Open File Chooser", Toast.LENGTH_LONG).show();
                    }

                    return true;
                }
            });


            mWebView.setOnKeyListener(new View.OnKeyListener() {
                @Override
                public boolean onKey(View v, int keyCode, KeyEvent event) {
                    if (event.getAction() == KeyEvent.ACTION_DOWN) {
                        if (keyCode == KeyEvent.KEYCODE_BACK) {
                            if (mWebView.canGoBack()) {
                                mWebView.goBack();
                            } else {
                                getFragmentManager().popBackStack();
                                mListener.onDismiss(null);
                            }

                            return true;
                        }
                    }

                    return false;
                }
            });
        }
        return view;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (data != null && resultCode == RESULT_OK) {
            fileUploadUri = data.getData();
            fileUploadPaths.add(UriToPathHandler.generateFilePathFromUri(getContext(), fileUploadUri));

            if (requestCode == FILE_CHOOSER_REQUEST) {
                if (mValueCallback != null) {
                    mValueCallback.onReceiveValue(new Uri[]{fileUploadUri});
                }
            } else if (requestCode == FILE_CHOOSER_REQUEST_FROM_SCRIPT){
                String fileName = null;
                if (data.getScheme().equals("content")) {
                    Cursor cursor = getContext().getContentResolver().query(data.getData(), null, null, null, null);
                    try {
                        if (cursor != null && cursor.moveToFirst()) {
                            fileName = cursor.getString(cursor.getColumnIndex(OpenableColumns.DISPLAY_NAME));
                            mWebView.loadUrl("javascript:nativeFileAttached" + '(' + "'" + fileName + "'" + ')');
                        }
                    } finally {
                        if (cursor != null) {
                            cursor.close();
                        }
                    }
                }

            }
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();

        mWebView.stopLoading();
        mWebView.loadUrl("about:blank");
    }


    public interface WebFormListener {
        void onDismiss(String result);
    }

    public class NRPresentorWebClient extends WebViewClient {

        @Override
        public void onReceivedClientCertRequest(WebView view, ClientCertRequest request) {
            super.onReceivedClientCertRequest(view, request);
        }

        @Override
        public void onUnhandledKeyEvent(WebView view, KeyEvent event) {
            super.onUnhandledKeyEvent(view, event);
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            mLoadingView.setVisibility(View.GONE);
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return shouldOverrideUrl(view, url);
        }

        @TargetApi(Build.VERSION_CODES.LOLLIPOP)
        @Override
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return shouldOverrideUrl(view, request.getUrl().toString());
        }

        private boolean shouldOverrideUrl(WebView webView, String url) {
            final String prefix = "nanorep://formData/";
            final String dismissUrl = "nanorep://";
            final String prefixContactForm = "nanorep://contactForm";

            if (url.startsWith(prefix)) {
                final String result = url.startsWith(prefix) ? url.substring(prefix.length()) : "";
                View view = getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                new ConfirmationDialogFragment(getContext(), view, channelConfirmationText, channelConfirmationButton, channelConfirmationTitle, new ConfirmationDialogFragment.OnOkClick() {
                    @Override
                    public void okClicked() {
                        Nanorep.getInstance().getWidgetListener().onSubmitSupportForm(result, fileUploadPaths);
                        mListener.onDismiss(null);

                    }
                });
                return true;
            } else if (url.startsWith(prefixContactForm)){
                if (url.contains("attachFile")){
                    Intent i = new Intent(Intent.ACTION_GET_CONTENT);
                    i.addCategory(Intent.CATEGORY_OPENABLE);
                    i.setType("image/*");
                    startActivityForResult( Intent.createChooser( i, "File Chooser" ), FILE_CHOOSER_REQUEST_FROM_SCRIPT);

                } else if (url.contains("removeFile")){
                    Uri uri = Uri.parse(url);
                    int fileIndex = Integer.valueOf(uri.getQueryParameter("index"));
                    fileUploadPaths.remove(fileIndex);
                }
                return true;

            } else if (url.startsWith(dismissUrl)) {
                if (url.endsWith("result=3")) {
                    return true;
                }
                getFragmentManager().popBackStack();
                mListener.onDismiss(null);
                return true;
            }

            return false;
        }
    }
}
