package nanorep.nanowidget.Components.formSDK.Decorators;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import nanorep.nanowidget.Components.formSDK.ViewHolders.CheckBoxListViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.FormFieldViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.PickerViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.SpinnerViewHolder;

/**
 * Created by Oz on 8/23/2017.
 */

public class DividerItemDecorator extends RecyclerView.ItemDecoration {

    private Drawable divider;

    public DividerItemDecorator(Drawable divider) {
        this.divider = divider;
    }

    @Override
    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);

        if (parent.getChildAdapterPosition(view) == 0) {
            return;
        }

        outRect.top = divider.getIntrinsicHeight();
    }


    @Override
    public void onDraw(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
        if (state.getItemCount() > 1) {
            for (int i = 0; i < parent.getChildCount() - 2; i++) {
                View view = parent.getChildAt(i);
                if (parent.getChildViewHolder(view) instanceof CheckBoxListViewHolder ||
                        parent.getChildViewHolder(view) instanceof PickerViewHolder ||
                        parent.getChildViewHolder(view) instanceof SpinnerViewHolder) {
                    RecyclerView.LayoutParams params = (RecyclerView.LayoutParams) view.getLayoutParams();

                    int top = view.getBottom() + params.bottomMargin;
                    int button = view.getBottom() + params.bottomMargin + divider.getIntrinsicHeight();
                    int left = parent.getWidth() - ((FormFieldViewHolder) parent.getChildViewHolder(view)).getFieldDataLayout().getWidth();
                    int right = parent.getWidth() - parent.getPaddingRight();

                    divider.setBounds(left, top, right, button);
                    divider.draw(canvas);
                }
            }
        }
    }
}
