package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;


import java.util.List;

import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.DataClass.NRResultsAdapter;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;


/**
 * Created by noat on 08/11/2016.
 */

public class NRResultsView extends LinearLayout implements NRResultsAdapter.Listener{
    private RecyclerView mResultsRecyclerView;
    private NRResultsAdapter adapter;
    private Listener listener;
    private boolean isAnimated;
    private String title;
    private FrameLayout loadingview;
    private TextView faqTitle;

    private RelativeLayout frequentlyQuestions;
    private TextView frequentlyQuestionsTv;

    public void setIsAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
    }

    public boolean isAnimated() {
        return isAnimated;
    }

    public void setAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
    }


    public interface Listener{
        void onResultSelected(int y, NRResultsAdapter.ViewHolder titleViewHolder);
    }

    public NRResultsView(Context context) {
        super(context);
        LayoutInflater.from(context).inflate(R.layout.results_view, this);
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);

        adapter = new NRResultsAdapter();
        mResultsRecyclerView = (RecyclerView) child.findViewById(R.id.resultsView);
        faqTitle = (TextView) child.findViewById(R.id.faqTitle);
        mResultsRecyclerView.addItemDecoration(new SimpleDividerItemDecoration(getContext(), getResources(), SimpleDividerItemDecoration.PAGE_RESULTS));
        mResultsRecyclerView.setLayoutManager(new LinearLayoutManager(this.getContext()));
        mResultsRecyclerView.setAdapter(adapter);

        loadingview = (FrameLayout) child.findViewById(R.id.loading_layout);
        faqTitle.setVisibility(VISIBLE);
    }

    public void setLoading(boolean loading) {
        loadingview.setVisibility(loading ? VISIBLE : GONE);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setResults(List<NRResult> results, String title, NRCustomViewAdapter viewAdapter)  {

//        if(!NRMainFragment.isEmpty(title)) {
//            frequentlyQuestions.setVisibility(View.VISIBLE);
//            frequentlyQuestionsTv.setText(title);
//        }

        this.title = title;

        adapter.setListener(this);
        adapter.setViewAdapter(viewAdapter);
        adapter.addItems(results);
    }

    public String getTitle() {
        return title;
    }

    @Override
    public void onResultItemSelected(NRResultsAdapter.ViewHolder titleViewHolder, int pos) {
        listener.onResultSelected(0, titleViewHolder);
    }

}
