package nanorep.nanowidget.Components;

import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRConfiguration;

import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.OnLikeListener;

/**
 * Created by nissimpardo on 18/06/16.
 */
public class NRLikeView extends NRCustomLikeView  {

    private TextView mLikeButton;
    private TextView mDislikeButton;
    private TextView feedBackQuestion;
    private boolean mLikeSelection;

    private LinearLayout likeLayout;
    private LinearLayout dislikeLayout;

    public NRLikeView(Context context) {
        super(context);
        LayoutInflater.from(context).inflate(R.layout.like_view, this);
    }

    @Override
    public void updateLikeButton(boolean isLike) {
        resetLikeView();
        if (isLike) {
            mLikeButton.setTextColor(ContextCompat.getColor(getContext(), R.color.nr_like_color));
            mDislikeButton.setTextColor(ContextCompat.getColor(getContext(), R.color.nr_text_color));
        } else {
            mLikeButton.setTextColor(ContextCompat.getColor(getContext(), R.color.nr_text_color));
            mDislikeButton.setTextColor(ContextCompat.getColor(getContext(), R.color.nr_dislike_color));
        }
        mLikeButton.setEnabled(false);
        mDislikeButton.setEnabled(false);
        mLikeSelection = isLike;
    }

    @Override
    public void resetLikeView() {
        mLikeButton.setEnabled(true);
        mDislikeButton.setEnabled(true);
        mLikeButton.setTextColor(getResources().getColor(R.color.nr_text_color));
        mDislikeButton.setTextColor(getResources().getColor(R.color.nr_text_color));
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);

        feedBackQuestion = (TextView) child.findViewById(R.id.likeText);
        feedBackQuestion.setText(Nanorep.getInstance().getNRConfiguration().getFeedbackCustomiseText());

        mLikeButton = (TextView) child.findViewById(R.id.likeButton);
        mDislikeButton = (TextView) child.findViewById(R.id.dislikeButton);
        mLikeButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                sendSelection(true);
            }
        });
        mDislikeButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                sendSelection(false);
            }
        });
    }

    private void sendSelection(boolean selection) {
        mLikeSelection = selection;
        updateLikeButton(mLikeSelection);
        mListener.onLikeClicked(NRLikeView.this, null, mLikeSelection);
    }

    @Override
    public boolean getLikeSelection() {
        return mLikeSelection;
    }

    @Override
    public boolean shouldOpenDialog() {
        return Nanorep.getInstance().getNRConfiguration().getFeedbackDialogType() != NRConfiguration.NO_FEEDBACK_DIALOG_TYPE;
    }
}