package com.nanorep.nanoclient.Connection

import android.net.Uri
import com.nanorep.nanoclient.exception.NRConnectionException
import com.nanorep.nanoclient.network.OnDataResponse
import com.nanorep.nanoclient.network.SupportHttpResponseByte
import com.nanorep.nanoclient.network.SupportHttpTask
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch


interface Decoder<T>{
    fun decode(value: T) : ByteArray
}

class SupportDownloader {

    companion object {

        fun <T> download(uri: Uri, mListener: OnDataResponse<T>, decoder: ((response: ByteArray) -> T)? = null) {

            // Sends the request for the download on the IO thread
            GlobalScope.launch(Dispatchers.IO) {

                SupportHttpTask(uri, object : SupportHttpResponseByte {

                    override fun success(response: ByteArray) {

                        val parsedObject = decoder?.invoke(response)

                        // Returns the response on the Main Thread
                        GlobalScope.launch(Dispatchers.Main) {
                            mListener.onSuccess(parsedObject)
                        }
                    }

                    override fun error(error: NRConnectionException?) {
                        GlobalScope.launch(Dispatchers.Main) {
                            mListener.onError(error)
                        }
                    }

                }).execute()
            }
        }
    }
}
