package com.nanorep.nanoclient;

import android.net.Uri;

import com.nanorep.nanoclient.Connection.NRUtilities;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by noat on 24/11/2016.
 */

public class AccountParams implements Comparable<AccountParams> {

    private String mHost;
    private String mAccount;
    private String mKnowledgeBase;
    private String apiKey = "";
    private HashMap<String, String> mContext;
    private Map<String,String> selectedContext;

    private String mReferrer;
    private String mDomain;
    private boolean labels;
    private boolean supportCenter;
    private String knowledgeBaseId;
    private String currentLabelContext;

    private int labelId; // not in labels mode, but initiated with label
    private boolean contextExclusivity = true;
    private boolean openLinksInternally = true;
    private String fixedTitle;
    private int chevronResourceId;

    public AccountParams(String account, String kb) {
        mAccount = account;
        mKnowledgeBase = kb;
        mContext = new HashMap<>();
        selectedContext = new HashMap<>();
    }

    public int getLabelId() {
        return labelId;
    }

    public void setLabelId(int labelId) {
        this.labelId = labelId;
    }

    public String getAccount() {
        return mAccount;
    }

    public void setAccount(String account) {
        mAccount = account;
    }

    public String getHost() {
        return mHost;
    }

    public void setHost(String mHost) {
        this.mHost = mHost;
    }

    public String getKnowledgeBase() {
        if (mKnowledgeBase == null) {
            return "";
        }
        return mKnowledgeBase;
    }

    public void setKnowledgeBase(String knowledgeBase) {
        mKnowledgeBase = knowledgeBase;
    }

    public void setContext(HashMap<String, String> context) {
        mContext = context;
    }

    public String getNanorepContext() {
        if (mContext != null) {
            return NRUtilities.wrappedContextBase64(mContext);
        }
        return null;
    }

    public String getContext() {
        String context = null;

        if(mContext != null) {
            context = "";
            for (String key: mContext.keySet()) {
                context = context + key + ":" + mContext.get(key) + ",";
            }
            if (context.length() > 0 ) {
                context = context.substring(0, context.length()-1);
            }
        }

        return context;
    }

    public String getReferrer() {
        if (mReferrer == null) {
            mReferrer = "mobile";
        }
        return mReferrer;
    }

    public void setReferrer(String referrer) {
        mReferrer = referrer;
    }

    public Uri.Builder getUri(boolean setReferer) {
        Uri.Builder uri = getUriNoReferer();

        if(setReferer) {
            uri.appendQueryParameter("referer", NRUtilities.buildReferer(getReferrer()));
        }

        return uri;
    }

    private Uri.Builder getUriNoReferer() {
        Uri.Builder uri = new Uri.Builder();
        uri.scheme("https");

        if (mHost != null) {
            uri.authority(mHost + ".nanorep.com");
            uri.appendEncodedPath("~" + getAccount());
        } else {
            uri.authority(getAccount() + ".nanorep.co");
        }

        return uri;
    }

    public Uri.Builder getUri() {
        Uri.Builder uri = getUriNoReferer();
        uri.appendQueryParameter("referer", NRUtilities.buildReferer(getReferrer()));
        return uri;
    }

    public String getDomain() {
        return mDomain;
    }

    public void setDomain(String domain) {
        mDomain = domain;
    }

    @Override
    public int compareTo(AccountParams o) {
        if(this.getAccount().equals(o.getAccount()) &&
           this.getKnowledgeBase().equals(o.getKnowledgeBase()) && stringEqual(this.getHost(), o.getHost()) &&
                stringEqual(this.getContext(), o.getContext())) {

            return 0;

        }
        return -1;
    }

    private boolean stringEqual(String myString, String oString) {
        if(myString == null && oString == null) {
            return true;
        } else if(myString != null && myString.equals(oString)) {
            return true;
        }
        return false;
    }

    public void setSupportCenterMode(boolean supportCenter) {
        this.supportCenter = supportCenter;
    }

    public boolean isSupportCenterMode() {
        return supportCenter;
    }

    public void setLabelsMode(boolean labelsMode) {
        this.labels = labelsMode;
    }

    public boolean isLabelsMode() {
        return labels;
    }

    /* -> relevant for future bug fix
    public boolean isFaqsMode() {
        return !labels && !supportCenter;
    }*/

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public String getKnowledgeBaseId() {
        return knowledgeBaseId;
    }

    public void setCurrentLabelContext(String currentLabelContext) {
        this.currentLabelContext = currentLabelContext;
    }

    public String getCurrentLabelContext() {
        return currentLabelContext;
    }

    public void setSelectedContext(String selectedContext) {
        String[] contexts = selectedContext.split(",");
        for (String context : contexts) {
            String[] parts = context.split(":");
            if(parts.length != 2) {
                return;
            }

            this.selectedContext.put(parts[0], parts[1]);
        }
    }

    public String getSelectedContext() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> ctx : selectedContext.entrySet()) {
            builder.append(ctx.getKey()).append(":").append(ctx.getValue()).append(",");
        }
        if(builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }

        return builder.toString();
    }

    public void setContext(String nrContext) {
        HashMap<String, String> map = new HashMap<>();
        String[] contextArray = nrContext.split(",");
        if(contextArray.length == 0) {
            return;
        }
        for (String ctx : contextArray) {
            String[] kv = ctx.split(":");
            if(kv.length != 2) {
                continue;
            }
            map.put(kv[0], kv[1]);
        }
        setContext(map);
    }

    public void setContextExclusivity(boolean contextExclusivity) {
        this.contextExclusivity = contextExclusivity;
    }

    public boolean isContextExclusivity() {
        return contextExclusivity;
    }

    public boolean isOpenLinksInternally() {
        return openLinksInternally;
    }

    public void setOpenLinksInternally(boolean openLinksInternally) {
        this.openLinksInternally = openLinksInternally;
    }

    public void setFixedTitle(String fixedTitle) {
        this.fixedTitle = fixedTitle;
    }

    public String getFixedTitle() {
        return fixedTitle;
    }

    public void clearSelectedContext() {
        selectedContext.clear();
    }

    public String getContextValues() {
        StringBuilder builder = new StringBuilder();

        for (Map.Entry<String, String> ctx : mContext.entrySet()) {
            builder.append(ctx.getValue()).append(", ");
        }
        for (Map.Entry<String, String> ctx : selectedContext.entrySet()) {
            builder.append(ctx.getValue()).append(", ");
        }
        if(builder.length() > 0) {
            builder.delete(builder.length() - 2, builder.length() - 1);
        }

        return builder.toString();
    }

    public void setChevronResourceId(int chevronResourceId) {
        this.chevronResourceId = chevronResourceId;
    }

    public int getChevronResourceId() {
        return chevronResourceId;
    }

    public String getApiKey() {
        return apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }
}