/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.nanoclient.Response;

import android.support.annotation.NonNull;
import android.util.Xml;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class NRHtmlParser {
    private String mHtmlString;
    public static final String LinkedArticle = "nanoreplinkid";
    private static String JavascriptTag = "javascript:void(0)";

    public NRHtmlParser(@NonNull String htmlString) {
        this.mHtmlString = htmlString;
    }

    public String getParsedHtml() {
        try {
            String htmlStringCopy = String.copyValueOf(this.mHtmlString.toCharArray());
            htmlStringCopy = htmlStringCopy.replace("&nbsp;", "");
            XmlPullParserFactory pullParserFactory = XmlPullParserFactory.newInstance();
            XmlPullParser parser = pullParserFactory.newPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            parser.setInput((Reader)new StringReader(htmlStringCopy));
            parser.setFeature(Xml.FEATURE_RELAXED, true);
            return this.parseHtml(parser);
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String parseHtml(XmlPullParser parser) {
        try {
            int eventType = parser.getEventType();
            while (eventType != 1) {
                if (eventType == 2 && parser.getName().equalsIgnoreCase("a") && parser.getAttributeCount() > 1) {
                    String atr0 = parser.getAttributeValue(null, "href");
                    String atr1 = parser.getAttributeValue(null, LinkedArticle);
                    if (atr0.equals(JavascriptTag) && atr1.matches("[0-9]+") && atr1.length() > 2) {
                        this.mHtmlString = this.mHtmlString.replaceFirst(Pattern.quote('\"' + atr0 + '\"'), "nanoreplinkid://" + atr1);
                    }
                }
                eventType = parser.next();
            }
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
        }
        return this.mHtmlString;
    }

    private String getValue(String attribute, XmlPullParser parser) {
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (!parser.getAttributeName(i).equals(attribute)) continue;
            return parser.getAttributeValue(i);
        }
        return null;
    }
}

