package com.nanorep.nanoclient.network;

import android.net.Uri;
import android.os.AsyncTask;

import com.nanorep.nanoclient.Nanorep;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;


/**
 * Created by Aviran Abady on 3/15/17.
 */

public class GetHttpTask extends AsyncTask<Void, Void, String> {

    private HttpResponse responseListener;
    private URL url;

    public GetHttpTask( String strUrl, HttpResponse listener) {
        this.responseListener = listener;
        try {
            url = new URL(strUrl);
        } catch (MalformedURLException e) {
            listener.error();
        }
    }

    public GetHttpTask(Uri uri, HttpResponse listener) {
        this.responseListener = listener;
        try {
            url = new URL(uri.toString());
        } catch (MalformedURLException e) {
            listener.error();
        }
    }

    protected String doInBackground(Void... v) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            HttpURLConnection httpConnection = (HttpURLConnection) url.openConnection();
            httpConnection.setRequestMethod("GET");

            if(Nanorep.isInitialized() && Nanorep.getInstance().getHttpRequestTimeout() != 0) {
                httpConnection.setConnectTimeout(Nanorep.getInstance().getHttpRequestTimeout() * 1000);
            }

            InputStream inputStream = httpConnection.getInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream);
            char[] buffer = new char[1024];
            int charsRead;
            while ((charsRead = reader.read(buffer)) != -1) {
                stringBuilder.append(buffer, 0, charsRead);
            }
            reader.close();
            inputStream.close();
            httpConnection.disconnect();
            return stringBuilder.toString();
        } catch (NullPointerException | IOException e){
            return null;
        }
    }

    protected void onPostExecute(String response) {
        if (response == null) {
            responseListener.error();
            return;
        }
        responseListener.success(response);
    }
}