/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.nanoclient.Response;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRFAQData;
import com.nanorep.nanoclient.model.ConfirmationDialogsTextProvider;
import com.nanorep.nanoclient.model.NRLabel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NRConfiguration {
    private NRFAQData mFaqData;
    private String mLanguageCode;
    private HashMap<String, Object> mParams;
    private boolean mIsContextDependent = false;
    private NRTitle title;
    private NRAutoComplete autoComplete;
    private NRSearchBar searchBar;
    private NRFaq faq;
    private NRContent content;
    private HashMap<String, String> customization;
    private List<NRLabel> labels;
    private ConfirmationDialogsTextProvider confirmationDialogsTextProvider;
    private int feedbackDialogType;
    public static final int MULTIPLE_CHOICE_OPEN_TEXT = 0;
    public static final int MULTIPLE_CHOICE = 1;
    public static final int OPEN_TEXT = 2;
    public static final int NO_FEEDBACK_DIALOG_TYPE = -1;
    public static final int ICONS_LIKE_VIEW = 0;
    public static final int TEXT_LIKE_VIEW = 1;

    public NRConfiguration() {
        this.mParams = new HashMap();
        this.customization = new HashMap();
    }

    public NRConfiguration(HashMap<String, Object> params) {
        if (params != null) {
            this.mParams = params;
        }
        if (params != null) {
            if (params.get("customization") != null) {
                this.customization = (HashMap)params.get("customization");
            }
            if (this.customization == null) {
                this.customization = new HashMap();
            }
            this.mIsContextDependent = false;
            Object faq = this.mParams.get("faqData");
            if (faq != null && faq instanceof String && "context-dependent".toLowerCase().equals(((String)faq).toLowerCase())) {
                this.mIsContextDependent = true;
            }
            if (this.mParams.containsKey("onLoadPageScript")) {
                try {
                    String json = (String)this.mParams.get("onLoadPageScript");
                    this.labels = (List)new Gson().fromJson(json, new TypeToken<List<NRLabel>>(){}.getType());
                }
                catch (JsonSyntaxException jse) {
                    jse.printStackTrace();
                }
            }
            this.mLanguageCode = (String)params.get("kbLanguageCode");
        }
    }

    public ConfirmationDialogsTextProvider getConfirmationDialogsText(Context context) {
        if (this.confirmationDialogsTextProvider == null) {
            this.confirmationDialogsTextProvider = new ConfirmationDialogsTextProvider(context);
        }
        return this.confirmationDialogsTextProvider;
    }

    public List<String> getFeedbackOptions() {
        String secondFeedbackOption;
        String firstFeedbackOption;
        ArrayList<String> feedBackChoices = new ArrayList<String>();
        try {
            firstFeedbackOption = (String)this.mParams.get("feedbackSearchProblemText");
            secondFeedbackOption = (String)this.mParams.get("feedbackProblemWithAnswerText");
        }
        catch (ClassCastException e) {
            Log.e((String)"ClassCastException", (String)"CantCastToString");
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)firstFeedbackOption) || TextUtils.isEmpty((CharSequence)secondFeedbackOption)) {
            return null;
        }
        feedBackChoices.add(firstFeedbackOption);
        feedBackChoices.add(secondFeedbackOption);
        return feedBackChoices;
    }

    public int getFeedbackDialogType() {
        int feedbackDialogType;
        try {
            feedbackDialogType = (Integer)this.mParams.get("feedbackDialogType");
        }
        catch (ClassCastException e) {
            feedbackDialogType = -1;
            Log.e((String)"ClassCastException", (String)"CantCastToInt");
        }
        catch (NullPointerException e) {
            feedbackDialogType = -1;
            Log.e((String)"NullPointerException", (String)"KeyNotFound");
        }
        if (feedbackDialogType != -1 && (feedbackDialogType != 2 && this.getFeedbackOptions() != null || feedbackDialogType == 2)) {
            return feedbackDialogType;
        }
        return -1;
    }

    public String getFeedbackDialogTitle() {
        try {
            return (String)this.mParams.get("feedbackSubmissionText");
        }
        catch (ClassCastException e) {
            return "Negative Feedback";
        }
    }

    public String getFeedbackDialogSubmitButtonText() {
        try {
            String title = (String)this.mParams.get("feedbackBottomText");
            if (title != null && !title.isEmpty()) {
                return title;
            }
            return "submit";
        }
        catch (ClassCastException e) {
            return "Submit";
        }
    }

    public String getLanguageCode() {
        return this.mLanguageCode;
    }

    public void setLabels(List<NRLabel> labels) {
        this.labels = labels;
    }

    public List<NRLabel> getLabels() {
        return this.labels;
    }

    public String getFeedbackCustomiseText() {
        if (this.mParams != null && this.mParams.containsKey("feedbackCustomiseText")) {
            return (String)this.mParams.get("feedbackCustomiseText");
        }
        return "Was this article helpful?";
    }

    public String getFeedbackPositiveButtonText() {
        if (this.mParams != null && this.mParams.containsKey("feedbackPositiveButtonText")) {
            return (String)this.mParams.get("feedbackPositiveButtonText");
        }
        return "Yes";
    }

    public String getFeedbackNegativeButtonText() {
        if (this.mParams != null && this.mParams.containsKey("feedbackNegativeButtonText")) {
            return (String)this.mParams.get("feedbackNegativeButtonText");
        }
        return "No";
    }

    public int getLikeViewType() {
        if (this.mParams != null && this.mParams.containsKey("feedbackType") && this.mParams.get("feedbackType") instanceof Integer) {
            return (Integer)this.mParams.get("feedbackType");
        }
        return 1;
    }

    public NRFaq getFaq() {
        if (this.faq == null) {
            this.faq = new NRFaq();
        }
        return this.faq;
    }

    public NRContent getContent() {
        if (this.content == null) {
            this.content = new NRContent();
        }
        return this.content;
    }

    public String getTitleText() {
        if (this.mParams.containsKey("titleTeaserText")) {
            return (String)this.mParams.get("titleTeaserText");
        }
        return "";
    }

    public NRTitle getTitle() {
        if (this.title == null) {
            this.title = new NRTitle();
        }
        return this.title;
    }

    public NRAutoComplete getAutoComplete() {
        if (this.autoComplete == null) {
            this.autoComplete = new NRAutoComplete();
        }
        return this.autoComplete;
    }

    public NRSearchBar getSearchBar() {
        if (this.searchBar == null) {
            this.searchBar = new NRSearchBar();
        }
        return this.searchBar;
    }

    public String getCnfId() {
        return (String)this.mParams.get("id");
    }

    public String getKbId() {
        return (String)this.mParams.get("kbId");
    }

    public String getCacheVar() {
        return (String)this.mParams.get("cacheVar");
    }

    public String getKbLanguageCode() {
        return (String)this.mParams.get("kbLanguageCode");
    }

    public void setAutocompleteEnabled(String autocompleteEnabled) {
        this.mParams.put("autocompleteEnabled", autocompleteEnabled);
    }

    public boolean getAutocompleteEnabled() {
        try {
            return (Boolean)this.mParams.get("autocompleteEnabled");
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public void setSkinName(String skinName) {
        this.mParams.put("skinName", skinName);
    }

    public String getSkinName() {
        return (String)this.mParams.get("skinName");
    }

    public void setTitleNormalText(String titleNormalText) {
        this.mParams.put("titleNormalText", titleNormalText);
    }

    public String getTitleNormalText() {
        return (String)this.mParams.get("titleNormalText");
    }

    public HashMap<String, Object> getmParams() {
        return this.mParams;
    }

    public void overrideCnfData(NRConfiguration cnf) {
        for (String key : cnf.mParams.keySet()) {
            this.mParams.put(key, cnf.mParams.get(key));
        }
        for (String key : cnf.customization.keySet()) {
            this.customization.put(key, cnf.customization.get(key));
        }
        this.mIsContextDependent = cnf.mIsContextDependent;
        this.content = new NRContent(cnf.getContent());
        this.title = new NRTitle(cnf.getTitle());
        this.autoComplete = new NRAutoComplete(cnf.getAutoComplete());
    }

    public boolean getIsContextDependent() {
        return this.mIsContextDependent;
    }

    public String getCustomNoAnswersTextContext(String query) {
        try {
            String context = Nanorep.getInstance().getAccountParams().getContextValues();
            if (context == null || context.length() == 0) {
                return ((String)this.mParams.get("customNoAnswersText")).replace("{QUERY}", query);
            }
            return ((String)this.mParams.get("customNoAnswersTextContext")).replace("{CONTEXT}", context);
        }
        catch (Exception e) {
            return "No results found for " + query;
        }
    }

    public void setFaqData(ArrayList<HashMap<String, Object>> faqList) {
        this.mParams.put("faqData", faqList);
        this.mIsContextDependent = false;
    }

    public NRFAQData getFaqData() {
        if (this.mIsContextDependent) {
            return null;
        }
        if (this.mFaqData == null) {
            if (this.mParams == null) {
                return null;
            }
            ArrayList faq = (ArrayList)this.mParams.get("faqData");
            if (faq == null) {
                return null;
            }
            if (faq.get(0) == null) {
                return null;
            }
            this.mFaqData = new NRFAQData(faq);
        }
        return this.mFaqData;
    }

    public class NRLogo {
        public void setHideBranding(String hideBranding) {
            NRConfiguration.this.mParams.put("hideBranding", hideBranding);
        }

        public String getHideBranding() {
            return (String)NRConfiguration.this.mParams.get("hideBranding");
        }
    }

    public class NRChanneling {
    }

    public class NRLike {
    }

    public class NRContent {
        String marginTop;
        String marginRight;
        String marginLeft;
        String marginBottom;

        public NRContent(NRContent content) {
            this.marginTop = content.getContentMarginTop();
            this.marginRight = content.getContentMarginRight();
            this.marginLeft = content.getContentMarginLeft();
            this.marginBottom = content.getContentMarginBottom();
        }

        public NRContent() {
        }

        public void setNoResultsMessage(String noResultsMessage) {
            NRConfiguration.this.mParams.put("mobile.noResultsMessage", noResultsMessage);
        }

        public String getNoResultsMessage() {
            return (String)NRConfiguration.this.mParams.get("mobile.noResultsMessage");
        }

        public void setAnswerTextColor(String answerTextColor) {
            NRConfiguration.this.mParams.put("mobile.answerTextColor", answerTextColor);
        }

        public String getAnswerTextColor() {
            return (String)NRConfiguration.this.mParams.get("mobile.answerTextColor");
        }

        public void setAnswerTextFont(String answerTextFont) {
            NRConfiguration.this.mParams.put("mobile.answerTextFont", answerTextFont);
        }

        public String getAnswerTextFont() {
            return (String)NRConfiguration.this.mParams.get("mobile.answerTextFont");
        }

        public void setAnswerTitleColor(String answerTitleColor) {
            NRConfiguration.this.customization.put("answerTitleColor", answerTitleColor);
        }

        public String getAnswerTitleColor() {
            return (String)NRConfiguration.this.customization.get("answerTitleColor");
        }

        public void setAnswerTitleFont(String answerTitleFont) {
            NRConfiguration.this.customization.put("answerTitleFont", answerTitleFont);
        }

        public String getAnswerTitleFont() {
            return (String)NRConfiguration.this.customization.get("answerTitleFont");
        }

        public void setWidgetBackgroundColor(String widgetBackgroundColor) {
            NRConfiguration.this.mParams.put("mobile.widgetBackgroundColor", widgetBackgroundColor);
        }

        public String getWidgetBackgroundColor() {
            return (String)NRConfiguration.this.mParams.get("mobile.widgetBackgroundColor");
        }

        public void setContentMarginTop(String marginTop) {
            this.marginTop = marginTop;
        }

        public void setContentMarginBottom(String marginBottom) {
            this.marginBottom = marginBottom;
        }

        public void setContentMarginRight(String marginRight) {
            this.marginRight = marginRight;
        }

        public void setContentMarginLeft(String marginLeft) {
            this.marginLeft = marginLeft;
        }

        public String getContentMarginTop() {
            if (this.marginTop == null) {
                return "15";
            }
            return this.marginTop;
        }

        public String getContentMarginBottom() {
            return this.marginBottom;
        }

        public String getContentMarginRight() {
            return this.marginRight;
        }

        public String getContentMarginLeft() {
            return this.marginLeft;
        }
    }

    public class NRAutoComplete {
        private Integer suggestionRowHeight;
        private boolean dividerVisible;
        private Integer maxLines;

        public NRAutoComplete(NRAutoComplete autoComplete) {
            this.suggestionRowHeight = autoComplete.getSuggestionRowHeight();
            this.dividerVisible = autoComplete.isDividerVisible();
            this.maxLines = autoComplete.getMaxLines();
        }

        public NRAutoComplete() {
        }

        public boolean isDividerVisible() {
            return this.dividerVisible;
        }

        public void setDividerVisible(boolean dividerVisible) {
            this.dividerVisible = dividerVisible;
        }

        public Integer getMaxLines() {
            return this.maxLines;
        }

        public void setMaxLines(Integer maxLines) {
            this.maxLines = maxLines;
        }

        public void setChatConfiguration(String chatConfiguration) {
            NRConfiguration.this.mParams.put("chatConfiguration", chatConfiguration);
        }

        public String getChatConfiguration() {
            return (String)NRConfiguration.this.mParams.get("chatConfiguration");
        }

        public Integer getSuggestionRowHeight() {
            if (this.suggestionRowHeight == null) {
                return 40;
            }
            return this.suggestionRowHeight;
        }

        public void setSuggestionRowHeight(Integer suggestionRowHeight) {
            this.suggestionRowHeight = suggestionRowHeight;
        }
    }

    public class NRSearchBar {
        public void setInitialText(String initialText) {
            NRConfiguration.this.mParams.put("initialText", initialText);
        }

        public String getInitialText() {
            return (String)NRConfiguration.this.mParams.get("initialText");
        }

        public void setVoiceEnabled(String voiceEnabled) {
            NRConfiguration.this.mParams.put("voiceEnabled", voiceEnabled);
        }

        public String getVoiceEnabled() {
            return (String)NRConfiguration.this.mParams.get("voiceEnabled");
        }
    }

    public class NRFaq {
        public void setFaqTextColor(String faqTextColor) {
            NRConfiguration.this.mParams.put("mobile.faqTextColor", faqTextColor);
        }

        public String getFaqTextColor() {
            return (String)NRConfiguration.this.mParams.get("mobile.faqTextColor");
        }

        public void setFaqTextFont(String faqTextFont) {
            NRConfiguration.this.mParams.put("mobile.faqTextFont", faqTextFont);
        }

        public String getFaqTextFont() {
            return (String)NRConfiguration.this.mParams.get("mobile.faqTextFont");
        }

        public void setFaqBackgroundColor(String faqBackgroundColor) {
            NRConfiguration.this.mParams.put("mobile.faqBackgroundColor", faqBackgroundColor);
        }

        public String getFaqBackgroundColor() {
            return "#636161";
        }
    }

    public class NRTitle {
        private String titleRowHeight = "45";

        public NRTitle(NRTitle title) {
            this.titleRowHeight = title.getTitleRowHeight();
        }

        public NRTitle() {
        }

        public String getTitleRowHeight() {
            return this.titleRowHeight;
        }

        public void setTitleRowHeight(String titleRowHeight) {
            this.titleRowHeight = titleRowHeight;
        }

        public void setTitleBGColor(String titleBGColor) {
            NRConfiguration.this.mParams.put("titleBGColor", titleBGColor);
        }

        public String getTitleBGColor() {
            return (String)NRConfiguration.this.mParams.get("titleBGColor");
        }

        public void setTitle(String title) {
            NRConfiguration.this.mParams.put("titleNormalText", title);
        }

        public String getTitle() {
            return (String)NRConfiguration.this.mParams.get("titleNormalText");
        }

        public void setTitleFont(String titleFont) {
            NRConfiguration.this.customization.put("titleFont", titleFont);
        }

        public String getTitleFont() {
            return (String)NRConfiguration.this.customization.get("titleFont");
        }

        public void setTitleColor(String titleColor) {
            NRConfiguration.this.mParams.put("titleColor", titleColor);
        }

        public String getTitleColor() {
            return (String)NRConfiguration.this.mParams.get("titleColor");
        }
    }
}

