package com.nanorep.nanoclient.Response;

import android.graphics.Typeface;
import android.text.Spannable;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created by nissopa on 9/12/15.
 */
public class NRSuggestions {
    private int mResultsCount;
    private String mRequestId;
    private String mLanguageCode;
    private String mQueryAnalysis;
    private ArrayList<Spannable> mSuggestions;

    /**
     * Converts JSON string into NRSuggestions
     *
     * @param params HashMap contains the NRSuggestions params
     */
    public NRSuggestions(HashMap<String, Object> params) {
        mResultsCount = (int)params.get("c");
        mRequestId = (String)params.get("rid");
        mLanguageCode = (String)params.get("lc");
        mQueryAnalysis = (String)params.get("q");
        mSuggestions = (ArrayList<Spannable>)params.get("a");
    }

    /**
     *
     * @return value of results count
     */
    public int getResultsCount() {
        return mResultsCount;
    }

    /**
     *
     * @return value of request id
     */
    public String getRequestId() {
        return mRequestId;
    }

    /**
     *
     * @return value of language code
     */
    public String getLanguageCode() {
        return mLanguageCode;
    }

    /**
     *
     * @return value of query analysis
     */
    public String getQueryAnalysis() {
        return mQueryAnalysis;
    }

    /**
     *
     * @return value of answers
     */

    /***
     *
     * @param fontName : input null to default font (roboto fonts)
     * @param fontColor : input 0 to default font color
     * @param fontSize : input 0 to default font size
     * @param isItalic : input false to default font
     */
    public void setSuggestionsFont (String fontName, int fontColor, int fontSize, boolean isItalic) {
        TypefaceSpan typefaceSpan = new TypefaceSpan(fontName);
        for (Spannable s : mSuggestions) {

            if (fontName != null && !fontName.isEmpty()) {
                s.setSpan(typefaceSpan, 0, s.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            }

            if (fontSize > 0) {
                s.setSpan(new AbsoluteSizeSpan(fontSize, true), 0, s.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            }

            if (fontColor != 0) {
                s.setSpan(new ForegroundColorSpan(fontColor), 0, s.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            }

            if (isItalic) {
                s.setSpan(new StyleSpan(Typeface.ITALIC), 0, s.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            }

        }
    }

    public ArrayList<Spannable> getSuggestions() {
        return mSuggestions;
    }
}
