package com.nanorep.nanoclient.Channeling;

import android.support.annotation.IntDef;

import com.nanorep.nanoclient.Interfaces.NRQueryResult;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;


/**
 * Created by nissimpardo on 29/12/15.
 */
public class NRChanneling {
    protected String buttonText;
    protected String channelDescription;
    protected NRChannelingType type;
    protected NRQueryResult mQueryResult;
    protected HashMap<String, Object> mParams;
    private Map<String, String> extraData;
    private String noResultExtra;
    private String contactForm;
    private String iconUrl;
    protected int channelCode;
    protected String predefinedExtraData;

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String icon) {
        this.iconUrl = icon;
    }

    public String getName() {
        if(mParams != null && mParams.containsKey("name")) {
            return (String) mParams.get("name");
        }
        return "";
    }

    public String getThankYouMessage() {
        if(mParams != null && mParams.containsKey("thankYouMessage")) {
            return (String) mParams.get("thankYouMessage");
        }
        return "";
    }

    public int getChannelCode() {
        return channelCode;
    }

        public void setExtraData(Map<String, String> extraData, String predefinedExtraData) {
        this.extraData = extraData;
        this.predefinedExtraData = predefinedExtraData;

    }

    public JSONObject getExtraData() {

        JSONObject extraDataJson = null;

        try {

            if (predefinedExtraData != null) {
                extraDataJson = new JSONObject(predefinedExtraData);
            }

            if (extraData != null && !extraData.entrySet().isEmpty()) {

                if (extraDataJson == null) {
                    extraDataJson = new JSONObject();
                }

                for (Map.Entry<String, String> entry : extraData.entrySet()) {

                    String key = entry.getKey();
                    String value = entry.getValue();

                    if (!key.isEmpty() && !value.isEmpty()) {
                        extraDataJson.put(entry.getKey(), entry.getValue());
                    }
                }
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (extraDataJson != null && !extraDataJson.toString().isEmpty()) {
            return extraDataJson;
        }

        return null;
    }

    public String getContactForm() {
        return contactForm;
    }

    public void setNoResultExtra(String noResultExtra) {
        this.noResultExtra = noResultExtra;
    }

    public String getNoResultExtra() {
        return noResultExtra;
    }

//    public NRChanneling(ChannelingResponse.ChannelData channel) {
//        buttonText = channel.getButtonText();
//        channelDescription = channel.getDescription();
//        mParams = new HashMap<>();
//        mParams.put("actionEsc", channel.getActionEsc());
//        mParams.put("channel", channel.getChannel());
//        type = channel.getChannelType();
//    }

    public enum NRChannelingType {
        PhoneNumber,
        OpenCustomURL,
        CustomScript,
        ContactForm,
        ChatForm
    }

    @IntDef({ChannelCode.PHONE, ChannelCode.CHAT_FORM, ChannelCode.CONTACT_FORM})
    @interface ChannelCode {
        int PHONE = 5;
        int CHAT_FORM = 3;
        int CONTACT_FORM = 1;
    }

    public NRChanneling(HashMap<String, ?> params) {
        mParams = (HashMap<String, Object>) params;
        buttonText = value("buttonText");
        channelDescription = value("description");
        contactForm = value("contactForms");
        iconUrl = value("icon");
    }

    public NRChanneling(HashMap<String, ?> params, int channelCode) {
        this(params);
        this.channelCode = channelCode;
    }



    protected String value(String key) {
        if (key != null) {
            return (String) mParams.get(key);
        }
        return null;
    }

    protected Boolean booleanValue(String key) {
        if (key != null) {
            return (Boolean) mParams.get(key);
        }
        return null;
    }

    public String getButtonText() {
        return buttonText;
    }

    public String getChannelDescription() {
        return channelDescription;
    }

    public NRChannelingType getType() {
        return type;
    }

    public void setQueryResult(NRQueryResult queryResult) {
        mQueryResult = queryResult;
    }

    public NRQueryResult getQueryResult() {
        return mQueryResult;
    }

    public static NRChanneling channelForParams(HashMap <String, Object> params) {
        String actionEsc = (String)params.get("actionEsc");
        if (actionEsc != null) {
            switch (Integer.valueOf(actionEsc)) {
                case 1:
                    return new NRChannelingOpenCustomURL(params);
                case 2:
                    return new NRChannelingCustomScript(params);
                case 0:
                    String channelCode = (String) params.get("channel");
                    if (channelCode != null) {
                        switch (Integer.valueOf(channelCode)) {
                            case ChannelCode.PHONE:
                                return new NRChannelingPhoneNumber(params, ChannelCode.PHONE);
                            case ChannelCode.CHAT_FORM:
                                return new NRChannelingChatForm(params, ChannelCode.CHAT_FORM);
                            case ChannelCode.CONTACT_FORM:
                                return new NRChannelingContactForm(params, ChannelCode.CONTACT_FORM);
                        }
                    }

            }
        }
        return null;
    }
}
