/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.nanoclient.network;

import android.net.Uri;
import android.os.AsyncTask;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.network.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

public class GetHttpTask
extends AsyncTask<Void, Void, String> {
    private HttpResponse responseListener;
    private URL url;

    public GetHttpTask(String strUrl, HttpResponse listener) {
        this.responseListener = listener;
        try {
            this.url = new URL(strUrl);
        }
        catch (MalformedURLException e) {
            listener.error();
        }
    }

    public GetHttpTask(Uri uri, HttpResponse listener) {
        this.responseListener = listener;
        try {
            this.url = new URL(uri.toString());
        }
        catch (MalformedURLException e) {
            listener.error();
        }
    }

    protected String doInBackground(Void ... v) {
        try {
            int charsRead;
            StringBuilder stringBuilder = new StringBuilder();
            HttpURLConnection httpConnection = (HttpURLConnection)this.url.openConnection();
            httpConnection.setRequestMethod("GET");
            if (Nanorep.isInitialized() && Nanorep.getInstance().getHttpRequestTimeout() != 0) {
                httpConnection.setConnectTimeout(Nanorep.getInstance().getHttpRequestTimeout() * 1000);
            }
            InputStream inputStream = httpConnection.getInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream);
            char[] buffer = new char[1024];
            while ((charsRead = reader.read(buffer)) != -1) {
                stringBuilder.append(buffer, 0, charsRead);
            }
            reader.close();
            inputStream.close();
            httpConnection.disconnect();
            return stringBuilder.toString();
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (ProtocolException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void onPostExecute(String response) {
        if (response == null) {
            this.responseListener.error();
            return;
        }
        this.responseListener.success(response);
    }
}

