package com.nanorep.nanoclient.model;

import com.google.gson.annotations.SerializedName;
import com.nanorep.nanoclient.Channeling.NRChanneling;

import java.util.List;

/**
 * Created by Aviran Abady on 4/18/17.
 */

public class ChannelingResponse {
    @SerializedName("rechanneling")
    private List<ChannelData> channels;

    public List<ChannelData> getChannels() {
        return channels;
    }

    public static class ChannelData {
        private String description;
        private String showInArticle;
        private String name;
        private String contactForms;
        private String actionEsc;
        private String channel;
        private String ThankYouMessage;
        private String buttonText;

        public String getDescription() {
            return description;
        }

        public String getShowInArticle() {
            return showInArticle;
        }

        public String getName() {
            return name;
        }

        public String getContactForms() {
            return contactForms;
        }

        public String getActionEsc() {
            return actionEsc;
        }

        public String getChannel() {
            return channel;
        }

        public String getThankYouMessage() {
            return ThankYouMessage;
        }

        public String getButtonText() {
            return buttonText;
        }


        public NRChanneling.NRChannelingType getChannelType() {
            switch (channel) {
                case "1":
                    return NRChanneling.NRChannelingType.ContactForm;
                case "3":
                    return NRChanneling.NRChannelingType.ChatForm;
                case "5":
                    return NRChanneling.NRChannelingType.PhoneNumber;
                default:
                    return NRChanneling.NRChannelingType.ContactForm;
            }
        }
    }

}
