package com.nanorep.nanoclient.Channeling;

import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.model.ChannelingResponse;

import java.util.HashMap;
import java.util.Map;


/**
 * Created by nissimpardo on 29/12/15.
 */
public class NRChanneling {
    protected String buttonText;
    protected String channelDescription;
    protected NRChannelingType type;
    protected NRQueryResult mQueryResult;
    protected HashMap<String, Object> mParams;
    private Map<String, String> extraData;
    private String noResultExtra;
    private String contactForm;
    private String iconUrl;

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String icon) {
        this.iconUrl = icon;
    }



    public String getName() {
        if(mParams != null && mParams.containsKey("name")) {
            return (String) mParams.get("name");
        }
        return "";
    }

    public String getThankYouMessage() {
        if(mParams != null && mParams.containsKey("thankYouMessage")) {
            return (String) mParams.get("thankYouMessage");
        }
        return "";
    }



    public void setExtraData(Map<String, String> extraData) {
        this.extraData = extraData;
    }

    public String getExtraData() {
        if(extraData == null || extraData.size() == 0 ) {
            return null;
        }
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry<String, String> entry : extraData.entrySet()) {
            sb.append(String.format("\"%s\": \"%s\",",entry.getKey(),entry.getValue()));
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    public String getContactForm() {
        return contactForm;
    }

    public void setNoResultExtra(String noResultExtra) {
        this.noResultExtra = noResultExtra;
    }

    public String getNoResultExtra() {
        return noResultExtra;
    }

//    public NRChanneling(ChannelingResponse.ChannelData channel) {
//        buttonText = channel.getButtonText();
//        channelDescription = channel.getDescription();
//        mParams = new HashMap<>();
//        mParams.put("actionEsc", channel.getActionEsc());
//        mParams.put("channel", channel.getChannel());
//        type = channel.getChannelType();
//    }

    public enum NRChannelingType {
        PhoneNumber,
        OpenCustomURL,
        CustomScript,
        ContactForm,
        ChatForm
    }

    public NRChanneling(HashMap <String, ?> params) {
        mParams = (HashMap<String, Object>) params;
        buttonText = value("buttonText");
        channelDescription = value("description");
        contactForm = value("contactForms");
        iconUrl = value("icon");
    }



    protected String value(String key) {
        if (key != null) {
            return (String) mParams.get(key);
        }
        return null;
    }

    protected Boolean booleanValue(String key) {
        if (key != null) {
            return (Boolean) mParams.get(key);
        }
        return null;
    }

    public String getButtonText() {
        return buttonText;
    }

    public String getChannelDescription() {
        return channelDescription;
    }

    public NRChannelingType getType() {
        return type;
    }

    public void setQueryResult(NRQueryResult queryResult) {
        mQueryResult = queryResult;
    }

    public NRQueryResult getQueryResult() {
        return mQueryResult;
    }

    public static NRChanneling channelForParams(HashMap <String, Object> params) {
        int actionEsc = Integer.parseInt((String)params.get("actionEsc"));
        switch (actionEsc) {
            case 1:
                return new NRChannelingOpenCustomURL(params);
            case 2:
                return new NRChannelingCustomScript(params);
            case 0:
                switch (Integer.parseInt((String)params.get("channel"))) {
                    case 5:
                        return new NRChannelingPhoneNumber(params);
                    case 3:
                        return new NRChannelingChatForm(params);
                    case 1:
                        return new NRChannelingContactForm(params);
                }
        }
        return null;
    }
}
