/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.nanoclient.RequestParams;

import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.RequestParams.NRRequestParams;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class NRSearchLikeParams
extends NRRequestParams {
    private String mSearchQuery;
    private NRLikeType mFeedbackType;
    private String mKeywordSetId;
    private String mKBLanguageCode;
    private String mArticleId;

    public NRSearchLikeParams(NRQueryResult result) {
        super(result);
        this.setArticleId(result.getId());
        this.setKeywordSetId(result.getKeywordSetId());
        this.setSearchQuery(result.getTitle());
    }

    public void setSearchQuery(String searchQuery) {
        String encodedText = null;
        try {
            encodedText = URLEncoder.encode(searchQuery, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.mSearchQuery = encodedText == null ? "" : encodedText;
        this.setValue(this.mSearchQuery, "text");
    }

    public void setFeedbackType(NRLikeType feedbackType) {
        this.mFeedbackType = feedbackType;
        this.setValue(feedbackType.toString(), "type");
    }

    public void setKeywordSetId(String keywordSetId) {
        this.mKeywordSetId = keywordSetId;
        this.setValue(keywordSetId, "ksId");
    }

    public void setKBLanguageCode(String KBLanguageCode) {
        this.mKBLanguageCode = KBLanguageCode;
        this.setValue(KBLanguageCode, "kbLC");
    }

    public void setArticleId(String articleId) {
        this.mArticleId = articleId;
        this.setValue(articleId, "articleId");
    }

    public String getArticleId() {
        return this.mArticleId;
    }
}

