/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.nanoclient;

import android.net.Uri;
import com.nanorep.nanoclient.Connection.NRUtilities;
import java.util.HashMap;
import java.util.Map;

public class AccountParams
implements Comparable<AccountParams> {
    private String mHost;
    private String mAccount;
    private String mKnowledgeBase;
    private HashMap<String, String> mContext;
    private String mReferrer;
    private String mDomain;
    private boolean labels;
    private String knowledgeBaseId;
    private String currentLabelContext;
    private Map<String, String> selectedContext;
    private int labelId;
    private boolean contextExclusivity = true;
    private boolean openLinksInternally = true;
    private String fixedTitle;

    public AccountParams(String account, String kb) {
        this.mAccount = account;
        this.mKnowledgeBase = kb;
        this.selectedContext = new HashMap<String, String>();
    }

    public int getLabelId() {
        return this.labelId;
    }

    public void setLabelId(int labelId) {
        this.labelId = labelId;
    }

    public String getAccount() {
        return this.mAccount;
    }

    public void setAccount(String account) {
        this.mAccount = account;
    }

    public String getHost() {
        return this.mHost;
    }

    public void setmHost(String mHost) {
        this.mHost = mHost;
    }

    public String getKnowledgeBase() {
        if (this.mKnowledgeBase == null) {
            return "";
        }
        return this.mKnowledgeBase;
    }

    public void setKnowledgeBase(String knowledgeBase) {
        this.mKnowledgeBase = knowledgeBase;
    }

    public void setContext(HashMap<String, String> context) {
        this.mContext = context;
    }

    public String getNanorepContext() {
        if (this.mContext != null) {
            return NRUtilities.wrappedContextBase64(this.mContext);
        }
        return null;
    }

    public String getContext() {
        String context = null;
        if (this.mContext != null) {
            context = "";
            for (String key : this.mContext.keySet()) {
                context = context + key + ":" + this.mContext.get(key) + ",";
            }
            if (context.length() > 0) {
                context = context.substring(0, context.length() - 1);
            }
        }
        return context;
    }

    public String getReferrer() {
        if (this.mReferrer == null) {
            this.mReferrer = "mobile";
        }
        return this.mReferrer;
    }

    public void setReferrer(String referrer) {
        this.mReferrer = referrer;
    }

    public Uri.Builder getUri(boolean setReferer) {
        Uri.Builder uri = this.getUriNoReferer();
        if (setReferer) {
            uri.appendQueryParameter("referer", NRUtilities.buildReferer(this.getReferrer()));
        }
        return uri;
    }

    private Uri.Builder getUriNoReferer() {
        Uri.Builder uri = new Uri.Builder();
        uri.scheme("https");
        if (this.mHost != null) {
            uri.authority(this.mHost + ".nanorep.com");
            uri.appendEncodedPath("~" + this.getAccount());
        } else {
            uri.authority(this.getAccount() + ".nanorep.co");
        }
        return uri;
    }

    public Uri.Builder getUri() {
        Uri.Builder uri = this.getUriNoReferer();
        uri.appendQueryParameter("referer", NRUtilities.buildReferer(this.getReferrer()));
        return uri;
    }

    public String getDomain() {
        return this.mDomain;
    }

    public void setDomain(String domain) {
        this.mDomain = domain;
    }

    @Override
    public int compareTo(AccountParams o) {
        if (this.getAccount().equals(o.getAccount()) && this.getKnowledgeBase().equals(o.getKnowledgeBase()) && this.stringEqual(this.getHost(), o.getHost()) && this.stringEqual(this.getContext(), o.getContext())) {
            return 0;
        }
        return -1;
    }

    private boolean stringEqual(String myString, String oString) {
        if (myString == null && oString == null) {
            return true;
        }
        return myString != null && myString.equals(oString);
    }

    public void setLabelsMode(boolean labelsMode) {
        this.labels = labelsMode;
    }

    public boolean isLabelsMode() {
        return this.labels;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setCurrentLabelContext(String currentLabelContext) {
        this.currentLabelContext = currentLabelContext;
    }

    public String getCurrentLabelContext() {
        return this.currentLabelContext;
    }

    public void setSelectedContext(String ctx) {
        String[] parts = ctx.split(":");
        if (parts.length != 2) {
            return;
        }
        this.selectedContext.put(parts[0], parts[1]);
    }

    public String getSelectedContext() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> ctx : this.selectedContext.entrySet()) {
            builder.append(ctx.getKey()).append(":").append(ctx.getValue()).append(",");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public void setContext(String nrContext) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] contextArray = nrContext.split(",");
        if (contextArray.length == 0) {
            return;
        }
        for (String ctx : contextArray) {
            String[] kv = ctx.split(":");
            if (kv.length != 2) continue;
            map.put(kv[0], kv[1]);
        }
        this.setContext(map);
    }

    public void setContextExclusivity(boolean contextExclusivity) {
        this.contextExclusivity = contextExclusivity;
    }

    public boolean isContextExclusivity() {
        return this.contextExclusivity;
    }

    public boolean isOpenLinksInternally() {
        return this.openLinksInternally;
    }

    public void setOpenLinksInternally(boolean openLinksInternally) {
        this.openLinksInternally = openLinksInternally;
    }

    public void setFixedTitle(String fixedTitle) {
        this.fixedTitle = fixedTitle;
    }

    public String getFixedTitle() {
        return this.fixedTitle;
    }

    public void clearSelectedContext() {
        this.selectedContext.clear();
    }
}

