package nanorep.nanowidget.DataClass;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.model.ContextValue;
import com.nanorep.nanoclient.model.NRLabel;

import java.util.ArrayList;
import java.util.List;

import nanorep.nanowidget.R;

/**
 * Created by Aviran Abady on 7/23/17.
 */

class ContextSelectionAdapter extends RecyclerView.Adapter<ContextSelectionAdapter.ViewHolder> {

    private final ContextSelectionListener listener;
    public interface ContextSelectionListener {
        void onContextSelected(String ctx);
    }

    private boolean hasSubContext;
    private ContextValue contextValues;
    private StringBuilder contextBuilder;

    public ContextSelectionAdapter(ContextValue contextValues, ContextSelectionListener listener) {
        this.listener = listener;
        contextBuilder = new StringBuilder();
        this.contextValues = contextValues;
        if(contextValues.subContext.size() > 0) {
            hasSubContext = true;
        }
    }

    @Override
    public ContextSelectionAdapter.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Context context = parent.getContext();
        View view = LayoutInflater.from(context).inflate(R.layout.context_selection_recycler_item, parent, false);
        return new ContextSelectionAdapter.ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(ContextSelectionAdapter.ViewHolder holder, int position) {
        String text = hasSubContext ?
                contextValues.subContext.get(position).parentContextValue :
                contextValues.values.get(position);
        holder.textView.setText(text);
    }


    @Override
    public int getItemCount() {
        return hasSubContext ? contextValues.subContext.size() : contextValues.values.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder implements View.OnClickListener {
        public TextView textView;

        public ViewHolder(View view) {
            super(view);
            view.setOnClickListener(this);
            textView = (TextView) view.findViewById(R.id.context_selection_item_textview);

        }

        @Override
        public void onClick(View v) {
            if(hasSubContext) {
                contextBuilder.append(contextValues.contextKey).append(":");
                contextValues = contextValues.subContext.get(getAdapterPosition());
                contextBuilder.append(contextValues.parentContextValue).append(",");
                hasSubContext = contextValues.subContext.size() > 0;
                notifyDataSetChanged();
            }
            else {
                contextBuilder
                        .append(contextValues.contextKey).append(":")
                        .append(contextValues.values.get(getAdapterPosition()));

                listener.onContextSelected(contextBuilder.toString());
            }
        }
    }
}