/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import java.util.List;
import nanorep.nanowidget.R;

public class DislikeDialog
extends AlertDialog.Builder
implements DialogInterface.OnDismissListener {
    private String feedbackText;
    private EditText feedbackEditText;
    private Listener mListener;
    private AlertDialog alert;
    private boolean isDismissHandled;
    private TextView dialogTitle;
    private static final int FIRST_RADIO_BUTTON_ID = R.id.feedback_radiobutton_first;
    private static final int SECOND_RADIO_BUTTON_ID = R.id.feedback_radiobutton_second;
    private static final int MULTIPLE_CHOICE_OPEN_TEXT = 0;
    private static final int MULTIPLE_CHOICE = 1;
    public static final int OPEN_TEXT = 2;
    private NRLikeType mSelection = NRLikeType.MISSING_INFORMATION;

    public void onDismiss(DialogInterface dialog) {
        if (!this.isDismissHandled) {
            this.mListener.onCancel();
        }
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public DislikeDialog(@NonNull Context context, View dislikeView, final int dialogType) {
        super(context);
        this.setView(dislikeView);
        this.dialogTitle = (TextView)dislikeView.findViewById(R.id.dislikeTitle);
        this.dialogTitle.setText((CharSequence)Nanorep.getInstance().getNRConfiguration().getFeedbackDialogTitle());
        this.feedbackEditText = (EditText)dislikeView.findViewById(R.id.feedbackEditText);
        RadioGroup feedbackChoicesRadio = (RadioGroup)dislikeView.findViewById(R.id.feedback_radiogroup);
        List feedbackOptions = Nanorep.getInstance().getNRConfiguration().getFeedbackOptions();
        if (dialogType != 2 && feedbackOptions != null && feedbackOptions.size() > 1) {
            RadioButton firstRadioOption = (RadioButton)dislikeView.findViewById(FIRST_RADIO_BUTTON_ID);
            firstRadioOption.setText((CharSequence)Nanorep.getInstance().getNRConfiguration().getFeedbackOptions().get(0));
            RadioButton secondRadioOption = (RadioButton)dislikeView.findViewById(SECOND_RADIO_BUTTON_ID);
            secondRadioOption.setText((CharSequence)Nanorep.getInstance().getNRConfiguration().getFeedbackOptions().get(1));
            if (dialogType == 1) {
                this.feedbackEditText.setVisibility(8);
            }
            feedbackChoicesRadio.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

                public void onCheckedChanged(RadioGroup group, @IdRes int checkedId) {
                    if (checkedId == FIRST_RADIO_BUTTON_ID) {
                        DislikeDialog.this.mSelection = NRLikeType.MISSING_INFORMATION;
                    } else {
                        DislikeDialog.this.mSelection = NRLikeType.IRRELEVANT;
                    }
                }
            });
        } else if (dialogType == 2) {
            feedbackChoicesRadio.setVisibility(8);
        } else {
            this.alert.dismiss();
            return;
        }
        ListView reasonsList = (ListView)dislikeView.findViewById(R.id.reasonsList);
        Button cancelButton = (Button)dislikeView.findViewById(R.id.cancelButton);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DislikeDialog.this.isDismissHandled = true;
                DislikeDialog.this.mListener.onCancel();
                DislikeDialog.this.alert.dismiss();
            }
        });
        Button okButton = (Button)dislikeView.findViewById(R.id.okButton);
        okButton.setText((CharSequence)Nanorep.getInstance().getNRConfiguration().getFeedbackDialogPositiveButtonText());
        okButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DislikeDialog.this.isDismissHandled = true;
                DislikeDialog.this.alert.dismiss();
                if (dialogType == 2 || dialogType == 0) {
                    DislikeDialog.this.feedbackText = DislikeDialog.this.feedbackEditText.getText().toString();
                }
                DislikeDialog.this.mListener.onDislike(DislikeDialog.this.mSelection, DislikeDialog.this.feedbackText);
            }
        });
        this.alert = this.create();
        this.alert.show();
    }

    public static interface Listener {
        public void onCancel();

        public void onDislike(NRLikeType var1, String var2);
    }
}

