/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.List;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.DataClass.NRResultsAdapter;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;

public class NRResultsView
extends LinearLayout
implements NRResultsAdapter.Listener {
    private RecyclerView mResultsRecyclerView;
    private NRResultsAdapter adapter;
    private Listener listener;
    private boolean isAnimated;
    private String title;
    private FrameLayout loadingview;
    private RelativeLayout frequentlyQuestions;
    private TextView frequentlyQuestionsTv;

    public void setIsAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public void setAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
    }

    public NRResultsView(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.results_view, (ViewGroup)this);
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.adapter = new NRResultsAdapter();
        this.mResultsRecyclerView = (RecyclerView)child.findViewById(R.id.resultsView);
        this.mResultsRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(this.getContext(), 1));
        this.mResultsRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mResultsRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.loadingview = (FrameLayout)child.findViewById(R.id.loading_layout);
    }

    public void setLoading(boolean loading) {
        this.loadingview.setVisibility(loading ? 0 : 8);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setResults(List<NRResult> results, String title, NRCustomViewAdapter viewAdapter) {
        this.title = title;
        this.adapter.setListener(this);
        this.adapter.setViewAdapter(viewAdapter);
        this.adapter.addItems(results);
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void onResultItemSelected(NRResultsAdapter.ViewHolder titleViewHolder, int pos) {
        this.listener.onResultSelected(0, titleViewHolder);
    }

    public static interface Listener {
        public void onResultSelected(int var1, NRResultsAdapter.ViewHolder var2);
    }
}

