/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components.ChannelPresenters;

import android.net.Uri;
import android.util.Log;
import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingChatForm;
import com.nanorep.nanoclient.Channeling.NRChannelingContactForm;
import com.nanorep.nanoclient.Channeling.NRChannelingOpenCustomURL;
import com.nanorep.nanoclient.Nanorep;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresentor;
import nanorep.nanowidget.DataClass.NRResult;

public class NRWebContentChannelPresentor
implements NRChannelPresentor {
    private Nanorep mNanoRep;
    private NRChanneling mChanneling;
    private String mUrl;

    public NRWebContentChannelPresentor(Nanorep nanoRep) {
        this.mNanoRep = nanoRep;
    }

    @Override
    public void present() {
        Uri.Builder channelUri = new Uri.Builder();
        channelUri.scheme("http").authority("dev4.nanorep.com");
        String url = null;
        switch (this.mChanneling.getType()) {
            case ContactForm: {
                channelUri.appendEncodedPath("sdk/mobile/contactform.html");
                channelUri.appendQueryParameter("account", this.mNanoRep.getAccountParams().getAccount());
                channelUri.appendQueryParameter("articleId", this.mChanneling.getQueryResult().getId());
                channelUri.appendQueryParameter("context", "null").appendQueryParameter("host", "my.nanorep.com");
                channelUri.appendQueryParameter("kb", this.mNanoRep.getAccountParams().getKnowledgeBase());
                channelUri.appendQueryParameter("text", this.mChanneling.getQueryResult().getTitle());
                channelUri.appendQueryParameter("contactFormId", ((NRChannelingContactForm)this.mChanneling).getContactForms());
                channelUri.appendQueryParameter("customCSS", ".CF_textFieldDiv%20%7B%20background%3A%20none%20!important%20%7D%0Alabel.fieldElement%20%7B%20background%3A%20none%20!important%20%7D%0Ainput%5Bname%3D%22submitbutton%22%5D%20%7B%20background%3A%20%2348af4a%20!important%20%7D\"");
                break;
            }
            case ChatForm: {
                channelUri.appendEncodedPath("sdk/mobile/chat.html");
                channelUri.appendQueryParameter("channel.chatProvider", ((NRChannelingChatForm)this.mChanneling).getChatProvider());
                channelUri.appendQueryParameter("channelUri.appendQueryParameter", ((NRChannelingChatForm)this.mChanneling).getAccountNum());
                channelUri.appendQueryParameter("channel.chatOptions.apiKey", "c774b56ff8a64cbba27743a8d4418b26");
                break;
            }
            case OpenCustomURL: {
                channelUri = null;
                url = ((NRChannelingOpenCustomURL)this.mChanneling).getLinkUrl();
            }
        }
        this.mUrl = url == null ? channelUri.toString() : url;
    }

    @Override
    public String getUrl() {
        AccountParams accountParams = Nanorep.getInstance().getAccountParams();
        Uri.Builder channelUri = accountParams.getUri();
        String host = accountParams.getHost() != null ? accountParams.getHost() + ".nanorep.com" : accountParams.getAccount() + ".nanorep.co";
        String url = null;
        switch (this.mChanneling.getType()) {
            case ContactForm: {
                channelUri.appendEncodedPath("sdk/mobile/contactform.html");
                channelUri.appendQueryParameter("account", this.mNanoRep.getAccountParams().getAccount());
                if (this.mChanneling.getQueryResult() != null) {
                    channelUri.appendQueryParameter("articleId", this.mChanneling.getQueryResult().getId());
                    channelUri.appendQueryParameter("text", this.mChanneling.getQueryResult().getTitle());
                }
                channelUri.appendQueryParameter("host", host);
                channelUri.appendQueryParameter("kb", this.mNanoRep.getAccountParams().getKnowledgeBase());
                channelUri.appendQueryParameter("contactFormId", ((NRChannelingContactForm)this.mChanneling).getContactForms());
                channelUri.appendQueryParameter("customCSS", ".CF_textFieldDiv%20%7B%20background%3A%20none%20!important%20%7D%0Alabel.fieldElement%20%7B%20background%3A%20none%20!important%20%7D%0Ainput%5Bname%3D%22submitbutton%22%5D%20%7B%20background%3A%20%2348af4a%20!important%20%7D\"");
                channelUri.appendQueryParameter("channelName", this.mChanneling.getName());
                if (this.mChanneling.getExtraData() == null) break;
                channelUri.appendQueryParameter("predefinedValues", this.mChanneling.getExtraData());
                break;
            }
            case ChatForm: {
                channelUri.appendEncodedPath("sdk/mobile/chat.html");
                channelUri.appendQueryParameter("channel.chatProvider", ((NRChannelingChatForm)this.mChanneling).getChatProvider());
                channelUri.appendQueryParameter("channelUri.appendQueryParameter", ((NRChannelingChatForm)this.mChanneling).getAccountNum());
                channelUri.appendQueryParameter("channel.chatOptions.apiKey", "c774b56ff8a64cbba27743a8d4418b26");
                break;
            }
            case OpenCustomURL: {
                channelUri = null;
                url = ((NRChannelingOpenCustomURL)this.mChanneling).getLinkUrl();
            }
        }
        url = url == null ? channelUri.toString() : url;
        Log.d((String)"NRWebContentChannel", (String)url);
        return url;
    }

    @Override
    public void setChannel(NRChanneling channeling) {
        this.mChanneling = channeling;
    }

    @Override
    public NRResult getResult() {
        return null;
    }
}

