/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.support.v7.widget.RecyclerView;
import android.text.Spannable;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.nanorep.nanoclient.Nanorep;
import nanorep.nanowidget.R;
import nanorep.nanowidget.Utilities.Calculate;

public class NRSuggestionItem
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    private TextView mTextView;
    private OnSuggestionSelectedListener mListener;
    private View itemView;
    private LinearLayout divider;

    public void onClick(View v) {
        this.mListener.onSuggestionSelected(this.mTextView.getText().toString());
    }

    public NRSuggestionItem(View itemView) {
        super(itemView);
        this.itemView = itemView;
        int height = Nanorep.getInstance().getNRConfiguration().getAutoComplete().getSuggestionRowHeight();
        this.itemView.getLayoutParams().height = (int)Calculate.pxFromDp(itemView.getContext(), height);
        this.itemView.requestLayout();
        this.mTextView = (TextView)itemView.findViewById(R.id.suggestion);
        this.itemView.setOnClickListener((View.OnClickListener)this);
        this.divider = (LinearLayout)itemView.findViewById(R.id.divider);
        if (Nanorep.getInstance().getNRConfiguration().getAutoComplete().isDividerVisible()) {
            this.divider.setVisibility(0);
        } else {
            this.divider.setVisibility(8);
        }
        Integer maxLines = Nanorep.getInstance().getNRConfiguration().getAutoComplete().getMaxLines();
        if (maxLines != null) {
            this.mTextView.setMaxLines(maxLines.intValue());
        }
    }

    public void setListener(OnSuggestionSelectedListener listener) {
        this.mListener = listener;
    }

    public void setText(Spannable text) {
        this.mTextView.setText((CharSequence)text);
    }

    public static interface OnSuggestionSelectedListener {
        public void onSuggestionSelected(String var1);
    }
}

