package nanorep.nanowidget.DataClass;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.CRUDAdapterInterface;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;

public class NRResultsAdapter extends RecyclerView.Adapter<NRResultsAdapter.ViewHolder> implements CRUDAdapterInterface<NRResult> {

    private ArrayList<NRResult> results;
    private NRCustomViewAdapter viewAdapter;
    private NRResultsAdapter.Listener listener;

    public interface Listener {
        void onResultItemSelected(ViewHolder titleViewHolder, int pos);
    }

    public NRResultsAdapter() {
        results = new ArrayList<NRResult>();
    }

    public class ViewHolder extends RecyclerView.ViewHolder implements View.OnClickListener {
        private TextView textView;
        private NRResult result;

        public ViewHolder(View view) {
            super(view);
            view.findViewById(R.id.titleLayout).setOnClickListener(this);
            textView = (TextView) view.findViewById(R.id.titleTextView);
        }

        @Override
        public void onClick(View v) {
            listener.onResultItemSelected(this, getAdapterPosition());
        }

        public NRResult getResult() {
            return result;
        }

        public void setResult(NRResult result) {
            this.result = result;
        }
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.title_item_label, parent, false);
        view.findViewById(R.id.label_image).setVisibility(View.GONE);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(ViewHolder holder,final int position) {
        final NRResult result = getItem(position);
        holder.setResult(result);
        holder.textView.setText(result.getFetchedResult().getTitle());
    }

    @Override
    public int getItemCount() {
        return results.size();
    }

    @Override
    public NRResult getItem(int position) {
        return results.get(position);
    }

    @Override
    public void addItem(NRResult item) {

    }

    @Override
    public void removeItem(NRResult item) {

    }

    @Override
    public void addItems(List<NRResult> items) {
        if(items == null) {
            return;
        }
        results.addAll(items);
        notifyDataSetChanged();
    }

    @Override
    public void clearList() {

    }

    @Override
    public void updateItem(int pos, NRResult item) {

    }

    @Override
    public void showItem(NRResult result, int itemPosition) {
//        listener.onResultSelected(result);
    }

    @Override
    public List<NRResult> getItems() {
        return null;
    }

    @Override
    public void removeItem(int currentItemPosition) {

    }

    public void setViewAdapter(NRCustomViewAdapter viewAdapter) {
        this.viewAdapter = viewAdapter;
    }

    public void setListener(NRResultsAdapter.Listener listener) {
        this.listener = listener;
    }
}
