package nanorep.nanowidget.Fragments;


import android.Manifest;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import android.widget.Toast;

import nanorep.nanowidget.R;
import nanorep.nanowidget.Utilities.NRChannelDismissType;

/**
 * A simple {@link Fragment} subclass.
 */
public class NRWebContentFragment extends Fragment {

    private static final String ARG_URL = "param1";
    private WebView mWebView;
    private WebFormListener mListener;
    private ValueCallback<Uri[]> mValueCallback;
    private WebChromeClient.FileChooserParams mFileChooserParams;
    private RelativeLayout mLoadingView;

    public interface WebFormListener {
        void onDismiss(String result);
    }

    // TODO: Rename and change types and number of parameters
    public static NRWebContentFragment newInstance(String url) {
        NRWebContentFragment fragment = new NRWebContentFragment();
        Bundle args = new Bundle();
        args.putString(ARG_URL, url);
        fragment.setArguments(args);
        return fragment;
    }


    public NRWebContentFragment() {
        // Required empty public constructor
    }

    public void setListener(WebFormListener listener) {
        mListener = listener;
    }


    @SuppressLint("SetJavaScriptEnabled")
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.fragment_nrweb_content, container, false);

        mLoadingView = (RelativeLayout) view.findViewById(R.id.webLoadingView);

        mWebView = (WebView) view.findViewById(R.id.webContentView);

//        mWebView.loadUrl("about:blank");

        mWebView.loadUrl(getArguments().getString(ARG_URL));
        mWebView.getSettings().setJavaScriptEnabled(true);
        mWebView.getSettings().setAllowFileAccess(true);
        mWebView.getSettings().setAllowContentAccess(true);
        mWebView.getSettings().setAllowFileAccessFromFileURLs(true);

        mWebView.setWebChromeClient(new WebChromeClient() {
            @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
            @Override
            public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, FileChooserParams fileChooserParams) {
                mValueCallback = filePathCallback;
                mFileChooserParams = fileChooserParams;
                if (ContextCompat.checkSelfPermission(getActivity(),
                        Manifest.permission.READ_EXTERNAL_STORAGE)
                        != PackageManager.PERMISSION_GRANTED) {
                    ActivityCompat.requestPermissions(getActivity(),
                            new String[]{Manifest.permission.READ_EXTERNAL_STORAGE},
                            100);
                }
                Intent intent = mFileChooserParams.createIntent();
                try {
                    startActivityForResult(intent, 100);
                } catch (ActivityNotFoundException e) {
                    Toast.makeText(getActivity().getApplicationContext(), "Cannot Open File Chooser", Toast.LENGTH_LONG).show();
                }

                return true;
            }
        });
        mWebView.setWebViewClient(new NRPresentorWebClient());


        mWebView.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == KeyEvent.ACTION_DOWN) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                        if (mWebView.canGoBack()) {
                            mWebView.goBack();
                        } else {
                            getFragmentManager().popBackStack();
                            mListener.onDismiss(null);
                        }

                        return true;
                    }
                }

                return false;
            }
        });


        return view;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 100 && data != null) {
            mValueCallback.onReceiveValue(new Uri[]{data.getData()});
        }
    }


    @Override
    public void onDetach() {
        super.onDetach();

        mWebView.stopLoading();
        mWebView.loadUrl("about:blank");
    }

    public class NRPresentorWebClient extends WebViewClient {

        @Override
        public void onPageFinished(WebView view, String url) {
            mLoadingView.setVisibility(View.GONE);
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return shouldOverrideUrl(view, url);
        }

        @TargetApi(Build.VERSION_CODES.LOLLIPOP)
        @Override
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return shouldOverrideUrl(view, request.getUrl().toString());
        }


        private boolean shouldOverrideUrl(WebView webView, String url) {
            final String prefix = "nanorep://formData/";

            if (url.startsWith("nanorep")) {
                if(!url.endsWith("result=3")) {
                    String result = url.startsWith(prefix) ? url.substring(prefix.length()) : "";
                    mListener.onDismiss(result);
                    InputMethodManager imm = (InputMethodManager)getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
                    imm.hideSoftInputFromWindow(webView.getWindowToken(), 0);
                    getFragmentManager().popBackStack();
                }
                return true;
            }
            return false;
        }

        /*
        private boolean shouldOverrideUrl(WebView webView, String url) {
            final String prefix = "nanorep://formData/";
            final String dismissUrl = "nanorep://contactForm.send?result=2";

            if (url.startsWith(prefix)) {
                String result = url.startsWith(prefix) ? url.substring(prefix.length()) : "";
                mListener.onDismiss(result);
                InputMethodManager imm = (InputMethodManager) getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
                imm.hideSoftInputFromWindow(webView.getWindowToken(), 0);
                return true;
            } else if (url.equals(dismissUrl)) {
                getFragmentManager().popBackStack();
                return true;
            }

            return false;
        }
         */
    }
}
