package nanorep.nanowidget.Fragments;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Spannable;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingPhoneNumber;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRExtraDataListener;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRAnswer;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.OnDataResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresentor;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.ChannelPresenters.NRCustomScriptChannelPresentor;
import nanorep.nanowidget.Components.DislikeDialog;
import nanorep.nanowidget.Components.MyWebView;
import nanorep.nanowidget.Components.NRCategoriesView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRLikeView;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRResultTopView;
import nanorep.nanowidget.Components.NRResultsView;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.Components.NRTitleView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRLabelsAdapter;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.DataClass.NRResultsAdapter;
import nanorep.nanowidget.R;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRApplicationContentListener;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRFetcherListener;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

import static com.nanorep.nanoclient.Channeling.NRChanneling.NRChannelingType.PhoneNumber;

public class NRMainFragment extends Fragment implements NRSearchBarListener, NRLabelsAdapter.NRLabelsListener,
        NRSuggestionsListener,
        NRCategoriesView.Listener,
        NRResultsView.Listener,
        NRContentView.Listener,
        NRChannelItem.OnChannelSelectedListener,
        NRResultTopView.Listener,
        NRErrorHandler.Listener {

    public static final String TAG = NRMainFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;

    private NRFetchedDataManager mFetchedDataManager;

    private NRCustomViewAdapter viewAdapter;

    private RelativeLayout mLoadingView;

    private LinearLayout fragmentMainLayout;

    private FrameLayout contentMain;

    // search bar
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;

    // suggestion view
    private NRCustomSuggestionsView mSuggestionsView;
    private LinearLayout mSuggestionViewContainer;

    private NRCategoriesView categoriesView;

    private boolean resetSuggestions = false;

    private boolean autocompleteEnabled = true;

    private View.OnKeyListener onKeyListener;

    // no answer
    private TextView mNoTitleView;
    private RelativeLayout mNotitleViewHolder;

    // no connection
    private LinearLayout noConnecttionView;

    private boolean animation = false;

    private NRApplicationContentListener applicationContentListener;
    private NRCustomChannelView channelView;
    private String articleId;
    private Button clearContextButton;
    private TextView userSelecteContextTextView;
    private LinearLayout userSelectedContextLayout;
    private String userSelectedContextKey;
    private NRLabel currentLabel;
    private TextView actionBarTextView;
    private NRResult currentResult;

    public static NRMainFragment newInstance(String context) {
        NRMainFragment fragment = new NRMainFragment();
        return fragment;
    }

    @Override
    public void fetchBodyForResult(final NRCustomContentView view, String resultID, Integer resultHash) {
        this.articleId = resultID;
        mFetchedDataManager.faqAnswer(resultID, resultHash, new OnFAQAnswerFetched() {
            @Override
            public void onAnswerFetched(NRQueryResult result) {
                if (result != null) {
                    view.loadData(result.getBody(), "text/html", "UTF-8");
                }
            }
        });
    }

    @Override
    public void closeAnswer() {
        // get the last view
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);

        if (!animation) {
            view.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_out_left));
        } else {
            if (view instanceof NRResultTopView && !((NRResultTopView) view).getmResult().isSingle()) {
                ((NRResultTopView) view).setResultUnFoldState(false);
                ((NRResultTopView) view).removeTopView();
            }
        }

        contentMain.removeView(view);
    }

    @Override
    public void onChannelSelected(final NRChanneling channeling) {
        if (currentResult.getFetchedResult().getExtraData() == null) {
            openChannel(channeling);
            return;
        }

        Nanorep.getInstance()
                .getWidgetListener()
                .personalInfoWithExtraData(
                        channeling.getChannelDescription(),
                        getCurrentResult().getExtraData(),
                        new NRExtraDataListener() {
                            @Override
                            public void onExtraData(Map<String, String> extraData) {
                                channeling.setExtraData(extraData);
                                openChannel(channeling);
                            }
                        });
    }

    private void openChannel(NRChanneling channeling) {

        NRChannelPresentor presentor = NRChannelStrategy.presentor(getContext(), channeling, Nanorep.getInstance());

        if (presentor instanceof NRCustomScriptChannelPresentor) {

            presentor.present();

        } else {

            String url = presentor.getUrl();
            if (url != null) {
                final RelativeLayout holder = (RelativeLayout) getView().findViewById(R.id.fragment_place_holder);
                holder.setVisibility(View.VISIBLE);
                NRWebContentFragment webContentFragment = NRWebContentFragment.newInstance(url);
                webContentFragment.setListener(new NRWebContentFragment.WebFormListener() {
                    @Override
                    public void onDismiss(String result) {
                        if(result != null) {
                            Nanorep.getInstance().getWidgetListener().onSubmitSupportForm(result);
                        }
                        getView().requestFocus();
                    }
                });
                getFragmentManager()
                        .beginTransaction()
                        .setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out)
                        .add(R.id.content_main, webContentFragment)
                        .addToBackStack("linked").commit();
            } else if (channeling.getType() == PhoneNumber) {
                String phoneNumber = ((NRChannelingPhoneNumber) channeling).getPhoneNumber();
                Intent intent = new Intent(Intent.ACTION_DIAL, Uri.fromParts("tel", phoneNumber, null));
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
                startActivity(intent);
                Nanorep.getInstance().reportChanneling(articleId, "5");
            }
        }
    }


    private NRQueryResult getCurrentResult() {
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
        if (view instanceof NRResultTopView) {
            return ((NRResultTopView) view).getmResult().getFetchedResult();
        }
        return null;
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
        mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched() {
            @Override
            public void onAnswerFetched(final NRQueryResult result) {

                NRResult newResult = new NRResult(result, NRResultItem.RowType.TITLE);
                int height = Integer.valueOf(Nanorep.getInstance().getNRConfiguration().getTitle().getTitleRowHeight());
                newResult.setHeight((int) Calculate.pxFromDp(getContext(), height));
                newResult.setSingle(true);

                NRResultTopView resultTopView = getTopView();
                contentMain.addView(resultTopView);

                resultTopView.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_in_left));

                resultTopView.openOpenedView(newResult);

                getView().requestFocus();
            }
        });
    }

    @Override
    public void onLinkClicked(String url) {
        MyWebView webView = new MyWebView(getContext(), url, new MyWebView.Listener() {
            @Override
            public void onDismiss() {
                contentMain.removeViewAt(contentMain.getChildCount() - 1);
                getView().requestFocus();
            }
        });

        contentMain.addView(webView);
        getView().requestFocus();
    }

    @Override
    public void onDismiss() { //for NRContent
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);

        if (view instanceof NRResultTopView) {
            view.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_out_left));
        }

        removeTopView();
    }

    @Override
    public void onLikeClicked(final NRResultTopView view, final NRCustomLikeView likeView, String resultId, boolean isLike) {
        final NRResult result = view.getmResult();

        if (isLike) {
            result.getFetchedResult().setLikeState(NRQueryResult.LikeState.positive);
            mFetchedDataManager.sendLike(NRLikeType.POSITIVE, "", result.getFetchedResult(), new Nanorep.OnLikeSentListener() {
                @Override
                public void onLikeSent(boolean success) {
                    if (!success) {
                        view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                        likeView.resetLikeView();
                    }
                }
            });
        } else if (!isLike) {
            if (likeView.shouldOpenDialog()) {
                openDislikeDialog(result, view, likeView);
            } else {
                onDislike(result, view, likeView, NRLikeType.INCORRECT_ANSWER, "");
            }
        }
    }

    private void onDislike(NRResult result, final NRResultTopView view, final NRCustomLikeView likeView, NRLikeType type, String feedbackText) {
        result.getFetchedResult().setLikeState(NRQueryResult.LikeState.negative);
        mFetchedDataManager.sendLike(type, feedbackText, result.getFetchedResult(), new Nanorep.OnLikeSentListener() {
            @Override
            public void onLikeSent(boolean success) {
                if (!success) {
                    view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                }
            }
        });
        removeTopView();
    }

    private void onDismissDislike() {
        // update channeling
        Nanorep.getInstance().getChanneling(articleId, false, new OnDataResponse<List<NRChanneling>>() {
            @Override
            public void onSuccess(List<NRChanneling> response) {

                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (view instanceof NRResultTopView) {
                    NRQueryResult fetchedResult = ((NRResultTopView) view).getmResult().getFetchedResult();
                    for (NRChanneling channel : response) {
                        channel.setQueryResult(fetchedResult);
                    }
                }
                channelView.setVisibility(View.VISIBLE);
                channelView.setChanneling(response);
            }

            @Override
            public void onError(NRConnectionException error) {

            }
        });
    }


    private void openDislikeDialog(final NRResult result, final NRResultTopView view, final NRCustomLikeView likeView) {
        String reasons[] = new String[]{getString(R.string.missing_information), getString(R.string.didnt_find)};
        View dislikeView = getActivity().getLayoutInflater().inflate(R.layout.dislike_dialog_gojek, null);

        final DislikeDialog dislikeAlert = new DislikeDialog(getContext(), dislikeView);
//        dislikeAlert.setTitle(getString(R.string.wrong));
        dislikeAlert.setListener(new DislikeDialog.Listener() {
            @Override
            public void onCancel() {
                likeView.resetLikeView();
                NRMainFragment.this.onDismissDislike();
            }

            @Override
            public void onDislike(NRLikeType type, String feedbackText) {
                NRMainFragment.this.onDislike(result, view, likeView, type, feedbackText);
            }
        });
        dislikeAlert.setDislikeOptions(reasons);
    }

    public static NRMainFragment newInstance() {

        Bundle args = new Bundle();

        NRMainFragment fragment = new NRMainFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if (context instanceof NRCustomViewAdapter) {
            viewAdapter = (NRCustomViewAdapter) context;
        }
    }

    private void initDataManager() {
        mFetchedDataManager = new NRFetchedDataManager(getContext(), new NRConfigFetcherListener() {
            @Override
            public void onConfigurationReady() {

                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) {
                    contentMain.removeView(view);
                }

                updateTitleNormalText();
                updateSearchBar();
                showSuggestionsView();
                mLoadingView.setVisibility(View.GONE);
            }

            @Override
            public void insertRows(ArrayList<NRFAQGroupItem> groups) {
                hideKeyboard();
                if (groups != null && groups.size() > 1 || Nanorep.getInstance().getAccountParams().isLabelsMode()) {
                    openCategoriesView(groups);
                } else if (groups.size() == 1) {
                    // show results view immidiately
                    openNRResultView(mFetchedDataManager.generateNRResultArray(groups.get(0).getAnswers(), getContext()), groups.get(0).getTitle());
                }
            }

            @Override
            public void onError() {
                mLoadingView.setVisibility(View.GONE);

                noConnecttionView.getLayoutParams().height = 0;
                noConnecttionView.requestLayout();

                NRErrorView errorView = new NRErrorView(getContext());
                errorView.setListener(new NRErrorView.Listener() {
                    @Override
                    public void tryAgain() {
                        mFetchedDataManager.fetchConfiguration();
                        mLoadingView.setVisibility(View.VISIBLE);
                    }
                });
                contentMain.addView(errorView);
            }
        });

        mFetchedDataManager.setFetcherListener(new NRFetcherListener() {

            @Override
            public void reloadWithAnimation() {

            }

            @Override
            public void reload() {

            }

            @Override
            public void insertRows(List<NRResult> results, String userSelectedContext) {
                hideKeyboard();
                if (userSelectedContext == null) {
                    userSelectedContextLayout.setVisibility(View.GONE);
                } else {
                    userSelectedContextLayout.setVisibility(View.VISIBLE);
                    String[] ctx = userSelectedContext.split(":");
                    if (ctx.length != 2) {
                        return;
                    }
                    userSelecteContextTextView.setText(ctx[1]);
                    userSelectedContextKey = ctx[0];
                }

                if (results == null || (results != null && results.size() == 0)) {
                    if (searchBarView.getText() != null) {
                        mNotitleViewHolder.getLayoutParams().height = (int) Calculate.pxFromDp(getContext(), NO_TITLE_HEIGHT);
                        mNoTitleView.setText(Nanorep.getInstance().getNRConfiguration().getCustomNoAnswersTextContext(searchBarView.getText()));

                        while (contentMain.getChildCount() > 2) {
                            contentMain.removeViewAt(contentMain.getChildCount() - 1);
                        }

                        contentMain.setVisibility(View.VISIBLE);
                        getView().requestFocus();
                    }
                } else if (results.size() == 1) {
                    currentResult = results.get(0);
                    articleId = currentResult.getFetchedResult().getId();
                    NRResultTopView resultTopView = getTopView();

                    contentMain.setVisibility(View.VISIBLE);
                    contentMain.addView(resultTopView);

                    Animation animation = AnimationUtils.loadAnimation(getContext(), R.anim.slide_in_left);
                    animation.setAnimationListener(new Animation.AnimationListener() {
                        @Override
                        public void onAnimationStart(Animation animation) {
                            for (int i = 0; i <= contentMain.getChildCount() - 2; i++) {
                                View view = contentMain.getChildAt(i);
                                view.setVisibility(View.INVISIBLE);
                            }
//                                    contentMain.getChildAt(contentMain.getChildCount() -2).setVisibility(View.INVISIBLE);
                            contentMain.getChildAt(contentMain.getChildCount() - 1).setVisibility(View.VISIBLE);
                        }

                        @Override
                        public void onAnimationEnd(Animation animation) {
                            for (int i = 0; i <= contentMain.getChildCount() - 2; i++) {
                                View view = contentMain.getChildAt(i);
                                view.setVisibility(View.VISIBLE);
                            }
                        }

                        @Override
                        public void onAnimationRepeat(Animation animation) {

                        }
                    });

                    resultTopView.setAnimation(animation);

                    resultTopView.startAnimation(animation);

                    NRResult result = results.get(0);

                    result.setSingle(true);

                    resultTopView.openOpenedView(result);

                    getView().requestFocus();
                } else if (results.size() > 1) {
                    // show results View
                    contentMain.setVisibility(View.VISIBLE);

                    openNRResultView(results, null);
                }
            }

            @Override
            public void presentSuggestion(String querytext, ArrayList<Spannable> suggestions) {
                if (!resetSuggestions && searchBarView.getText().length() - querytext.length() <= 1 && autocompleteEnabled) {
                    mSuggestionsView.setSuggestions(suggestions);

                    // hide content view
                    contentMain.setVisibility(View.INVISIBLE);

//                    searchBarView.requestFocus();
//                    searchBarView.setOnKeyListener(onKeyListener);
                }
            }

            @Override
            public void onConnectionFailed(HashMap<String, Object> errorParams) {

            }
        });
    }

    private void hideKeyboard() {
        View view = getView();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager) getActivity().getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if (viewAdapter == null) {
            viewAdapter = new NRViewAdapter();
        }


        NRErrorHandler.getInstance().setListener(this);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();

        Nanorep.getInstance().reset();
    }

    @Override
    public void onPause() {
        super.onPause();
        NRErrorHandler.getInstance().setListener(null);
    }

    private void openCategoriesView(ArrayList<NRFAQGroupItem> groups) {
        categoriesView = new NRCategoriesView(getActivity());

        if (Nanorep.getInstance().getAccountParams().isLabelsMode()) {
            categoriesView.setLabels(NRMainFragment.this);
        } else {
            categoriesView.setCategories(groups, viewAdapter, NRMainFragment.this);
        }


        contentMain.addView(categoriesView);
    }

    private NRResultTopView getTopView() {

        NRResultTopView resultTopView = new NRResultTopView(getActivity());

        resultTopView.setListener(this);

        NRCustomTitleView titleView = viewAdapter.getTitle(getContext());

        if (titleView == null) {
            titleView = new NRTitleView(getContext());
            ((NRTitleView) titleView).configViewObjects(Nanorep.getInstance().getNRConfiguration());
        }

        NRCustomContentView contentView = viewAdapter.getContent(getContext());

        if (contentView == null) {
            contentView = new NRContentView(getContext());
        }

        if (applicationContentListener != null) {
            contentView.setApplicationContentListener(applicationContentListener);
        }

        NRCustomLikeView likeView = viewAdapter.getLikeView(getContext());

        if (likeView == null) {
            likeView = new NRLikeView(getContext());
        }

        channelView = viewAdapter.getChannelView(getContext());

        if (channelView == null) {
            channelView = new NRChannelingView(getContext());
        }

        NRCustomFeedbackView feedbackView = viewAdapter.getFeedbackView(getContext());

        resultTopView.setTitleView(titleView);
        resultTopView.setContentView(contentView, this);


        if (feedbackView != null) {
            feedbackView.setCustomChannelView(channelView);
            feedbackView.setCustomLikeView(likeView);
            resultTopView.setLikeView(feedbackView.getCustomLikeView());
            resultTopView.setChannelView(feedbackView.getCustomChannelView(), this);
            resultTopView.setFeedbackView(feedbackView);
        } else {
            resultTopView.setLikeView(likeView);
            resultTopView.setChannelView(channelView, this);
        }

        return resultTopView;
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {

        View view = inflater.inflate(R.layout.fragment_main, container, false);

        mLoadingView = (RelativeLayout) view.findViewById(R.id.fragment_place_holder);

        contentMain = (FrameLayout) view.findViewById(R.id.content_main);

        fragmentMainLayout = (LinearLayout) view.findViewById(R.id.fragment_main_layout);

        mNotitleViewHolder = (RelativeLayout) view.findViewById(R.id.noTiltleView);
        mNoTitleView = (TextView) view.findViewById(R.id.noTitleTextView);

        noConnecttionView = (LinearLayout) view.findViewById(R.id.noConnecttionView);

        userSelecteContextTextView = (TextView) view.findViewById(R.id.user_selected_context_textview);
        clearContextButton = (Button) view.findViewById(R.id.clear_user_selected_button);
        userSelectedContextLayout = (LinearLayout) view.findViewById(R.id.current_user_selected_context_layout);

        clearContextButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mFetchedDataManager.clearUserSelectedContext();
                userSelectedContextLayout.setVisibility(View.GONE);
                if (contentMain.getChildCount() > 1) {
                    removeTopView();
                }
                clearContextFromSession(userSelectedContextKey);
            }
        });

//        noConnecttionView.getLayoutParams().height = (int) Calculate.pxFromDp(getContext(), NO_CONNECTION_HEIGHT);

        setViews(view);
        initDataManager();
        return view;
    }

    private void clearContextFromSession(String ctx) {

        Nanorep.getInstance().setContext(ctx + ":", new OnDataResponse<DefaultResponse>() {
            @Override
            public void onSuccess(DefaultResponse response) {
                Nanorep.getInstance().clearCache();

            }

            @Override
            public void onError(NRConnectionException error) {

            }
        });
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = Nanorep.getInstance().getNRConfiguration().getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = Nanorep.getInstance().getNRConfiguration().getSearchBar();

        searchBarView.setHint(searchBarConfig.getInitialText());

        String titleBGColor = "#0aa0ff";

        // titleConfig color
        if (!isEmpty(titleConfig.getTitleBGColor())) {
            titleBGColor = titleConfig.getTitleBGColor();
        }

        searchBarView.setBackgroundColor(Color.parseColor(titleBGColor));
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = Nanorep.getInstance().getNRConfiguration().getTitle();
        ActionBar actionBar = ((AppCompatActivity) getActivity()).getSupportActionBar();

        if(actionBar == null) {
            return;
        }

        View customActionBar = getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
        ActionBar.LayoutParams layout = new ActionBar.LayoutParams(ActionBar.LayoutParams.MATCH_PARENT, ActionBar.LayoutParams.MATCH_PARENT);

        actionBar.setCustomView(customActionBar, layout);
        actionBar.setDisplayShowHomeEnabled(false);
        actionBar.setDisplayShowTitleEnabled(false);
        actionBar.setDisplayShowCustomEnabled(true);

        Toolbar parent = (Toolbar) customActionBar.getParent();
        parent.setPadding(0, 0, 0, 0);//for tab otherwise give space in tab
        parent.setContentInsetsAbsolute(0, 0);

        actionBarTextView = (TextView) actionBar.getCustomView().findViewById(R.id.titleBarTv);


        // titleConfig text
        String titleText = getString(R.string.default_title);

        if (!isEmpty(title.getTitle())) {
            titleText = title.getTitle();
        }

        actionBarTextView.setText(titleText);

        // titleConfig color
        if (!isEmpty(title.getTitleColor())) {
            String titleColor = title.getTitleColor();
            actionBarTextView.setTextColor(Color.parseColor(titleColor));
        }

        // titleConfig background color
        if (!isEmpty(title.getTitleBGColor())) {
            String titleBGColor = title.getTitleBGColor();
            RelativeLayout relativeLayout = (RelativeLayout) actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
            relativeLayout.setBackgroundColor(Color.parseColor(titleBGColor));
        }

        // titleConfig font
        if (!isEmpty(title.getTitleFont())) {
            String titleFont = title.getTitleFont();
            actionBarTextView.setTypeface(Typeface.create(titleFont, Typeface.NORMAL));
        }

    }

    private void setTitleText(String title) {
        ActionBar actionBar = ((AppCompatActivity) getActivity()).getSupportActionBar();
        if(actionBar == null) {
           return;
        }
        TextView tv = (TextView) actionBar.getCustomView().findViewById(R.id.titleBarTv);
        tv.setText(title);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }


    private void setViews(View nanoView) {

        // suggestion view
        mSuggestionViewContainer = (LinearLayout) nanoView.findViewById(R.id.suggestion_view_container);

        mSuggestionsView = viewAdapter.getSuggestionsView(getContext());

        if (mSuggestionsView == null) {
            mSuggestionsView = new NRSuggestionsView(getContext());
        }

        mSuggestionsView.setListener(this);

        if(mSuggestionsView.getParent() != null) {
            ((LinearLayout) mSuggestionsView.getParent()).removeView(mSuggestionsView);
        }

        mSuggestionViewContainer.addView(mSuggestionsView);


        // search bar
        searchBarContainer = (LinearLayout) nanoView.findViewById(R.id.search_bar_container);

        searchBarView = viewAdapter.getSearchBar(getContext());

        if (searchBarView == null) {
            searchBarView = new NRSearchBar(getContext());
        }

        searchBarView.setListener(this);

        if(searchBarView.getParent() != null) {
            ((LinearLayout) searchBarView.getParent()).removeView(searchBarView);
        }

        searchBarContainer.addView(searchBarView, new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
    }


    @Override
    public void onStartRecording(ImageButton button) {

    }

    @Override
    public void fetchSuggestionsForText(String text) {
        hideNoTitleView();

        resetSuggestions = false;
        mFetchedDataManager.searchSuggestion(text);
    }

    @Override
    public void searchForText(String text) {
        resetSuggestions = true;
        mSuggestionsView.setSuggestions(null);

        mFetchedDataManager.searchText(text);
    }

    @Override
    public void onClearClicked(boolean byUser) {

        if (mNotitleViewHolder.getLayoutParams().height > 0) {
//            if(!(contentMain.getChildAt(contentMain.getChildCount()-1) instanceof NRResultsView)) {
//                contentMain.removeViewAt(contentMain.getChildCount() - 1);
//            }

            mNotitleViewHolder.getLayoutParams().height = 0;
        }

        resetSuggestions = true;
        mSuggestionsView.setSuggestions(null);

        while (contentMain.getChildCount() > 1) {
            contentMain.removeViewAt(contentMain.getChildCount() - 1);
        }

        // show content
        contentMain.setVisibility(View.VISIBLE);

    }

    @Override
    public void onEmptyQuery() {

    }

    private void hideNoTitleView() {
        if (mNotitleViewHolder.getLayoutParams().height > 0) {
            mNotitleViewHolder.getLayoutParams().height = 0;
        }
    }

    @Override
    public void onSelectSuggestion(String suggestion) {
        resetSuggestions = true;

        searchBarView.dismissKeyboard();
        searchBarView.updateEditTextView(suggestion);

        resetSuggestions = true;
        mSuggestionsView.setSuggestions(null);

        mFetchedDataManager.searchText(suggestion);
    }

    private void showSuggestionsView() {
        if (!Nanorep.getInstance().getNRConfiguration().getAutocompleteEnabled()) {
            autocompleteEnabled = false;
        }
    }

    @Override
    public void onCategorySelected(NRFAQGroupItem groupItem) {
        openNRResultView(mFetchedDataManager.generateNRResultArray(groupItem.getAnswers(), getContext()), groupItem.getTitle());
    }

    private void openNRResultView(List<NRResult> results, String title) {

        NRResultsView resultsView = new NRResultsView(getActivity());
        resultsView.setListener(NRMainFragment.this);
        resultsView.setResults(results, title, viewAdapter);
        resultsView.setIsAnimated(animation);

        if (!isEmpty(title)) {
            setTitleText(title);
        }

        contentMain.addView(resultsView);

        if (getView() != null) {
            getView().requestFocus();
        }
    }

    @Override
    public void onResultSelected(final int y, NRResultsAdapter.ViewHolder titleViewHolder) {
        hideKeyboard();
        final NRResultTopView resultTopView = getTopView();
        // get last results view and fade it when answer is opened in animation
        contentMain.addView(resultTopView);
        animateBGColor(500, resultTopView, true, titleViewHolder);
        final NRResult result = titleViewHolder.getResult();

        if (result.getFetchedResult().getBody() == null) {
            this.articleId = result.getFetchedResult().getId();
            mFetchedDataManager.faqAnswer(result.getFetchedResult().getId(), null, new OnFAQAnswerFetched() {
                @Override
                public void onAnswerFetched(NRQueryResult queryResult) {
                    result.setFetchedResult(queryResult);
                    currentResult = result;
                    presentResult(result, y, resultTopView);
                }
            });
        } else {
            presentResult(result, y, resultTopView);
        }
    }

    private void presentResult(NRResult result, int y, NRResultTopView resultTopView) {
        result.setUnfolded(true);

        if (animation) {
            resultTopView.openView(y, result);
        } else {
            resultTopView.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_in_left));
            resultTopView.openOpenedView(result);
        }

        getView().requestFocus();
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        getView().setFocusableInTouchMode(true);
        getView().requestFocus();

        onKeyListener = new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == KeyEvent.ACTION_DOWN) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                        hideNoTitleView();
                        searchBarView.updateEditTextView("");

                        if (NRMainFragment.this.getFragmentManager().getBackStackEntryCount() == 1) {
                            // channel is opened

                            NRMainFragment.this.getFragmentManager().popBackStack();
                            return true;

                        } else if (mSuggestionsView.getHeight() > 0) {
                            resetSuggestions = true;
                            mSuggestionsView.setSuggestions(null);
                            contentMain.setVisibility(View.VISIBLE);
                            return true;
                        } else if (contentMain.getChildCount() > 1) {

                            // get the last view
                            View view = contentMain.getChildAt(contentMain.getChildCount() - 1);

                            if (!animation) {
                                if (view instanceof NRResultTopView) {
                                    view.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_out_left));
                                }

                                removeTopView();

                            } else { // if answer is opened from list, it should be animated
                                if (view instanceof NRResultTopView) {// &&
                                    if (!((NRResultTopView) view).getmResult().isSingle()) { // opened from results lists)
                                        ((NRResultTopView) view).setResultUnFoldState(false);
                                        ((NRResultTopView) view).removeTopView();

                                        updateSearchBarTextForResultTop(view);
                                    } else {
                                        view.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_out_left));

                                        removeTopView();
                                    }

                                } else {

                                    removeTopView();
                                }
                            }

                            return true;
                        } else {
                            return false;
                        }

                    } else { // if (keyCode == KeyEvent.KEYCODE_BACK)
                        return false;
                    }
                } else { // if (event.getAction() == KeyEvent.ACTION_DOWN)
                    return false;
                }
            }
        };

        getView().setOnKeyListener(onKeyListener);
    }

    private void removeTopView() {
        if (contentMain.getChildCount() == 2 && currentLabel != null) {
            // back to labels screen
            String ctx = currentLabel.getContext();
            String []parts = ctx.split(":");
            if(parts.length != 2) {
                return;
            }
            clearContextFromSession(parts[0]);
            currentLabel = null;
        }

        contentMain.removeViewAt(contentMain.getChildCount() - 1);

        View currentView = contentMain.getChildAt(contentMain.getChildCount() - 1);
        if (currentView instanceof NRResultTopView) {

            updateSearchBarTextForResultTop(currentView);
        } else {
            searchBarView.updateEditTextView("");
            getView().requestFocus();

            String title = Nanorep.getInstance().getNRConfiguration().getTitle().getTitle();

            if (currentView instanceof NRResultsView) {
                if (!isEmpty(((NRResultsView) currentView).getTitle())) {
                    title = ((NRResultsView) currentView).getTitle();
                }
            }

            setTitleText(currentLabel == null ? title : currentLabel.getTitle());
        }
    }

    private void updateSearchBarTextForResultTop(View view) {
        if (((NRResultTopView) view).getmResult().getFetchedResult() instanceof NRAnswer) {
            searchBarView.updateEditTextView(((NRResultTopView) view).getmResult().getFetchedResult().getTitle());
            resetSuggestions = true;
            mSuggestionsView.setSuggestions(null);
            contentMain.setVisibility(View.VISIBLE);
            getView().requestFocus();
        }
    }

    private void fadeViews(View view, final float f, long duration, final boolean removeTopTitle) {
        view.animate()
                .alpha(f)
                .setDuration(duration)
                .setListener(new Animator.AnimatorListener() {
                    @Override
                    public void onAnimationStart(Animator animation) {

                    }

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        if (removeTopTitle) {
                            contentMain.removeViewAt(contentMain.getChildCount() - 1);
                        }
                    }

                    @Override
                    public void onAnimationCancel(Animator animation) {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation) {

                    }
                });
    }

    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) {
        if (beforeGoingDown) {
            animateBGColor(50, contentMain.getChildAt(contentMain.getChildCount() - 1), false, null);

        } else {
            fadeViews(contentMain.getChildAt(contentMain.getChildCount() - 1), 0.0f, 500, true);
        }
    }

    private void animateBGColor(int milliseconds, final View view, final boolean unfold, final NRResultsAdapter.ViewHolder titleViewHolder) {

        int colorFrom = getResources().getColor(R.color.nr_background_color);
        int colorTo = getResources().getColor(R.color.white);

        if (!unfold) {
            colorFrom = Color.WHITE;
            colorTo = getResources().getColor(R.color.nr_background_color);
        }

        ValueAnimator colorAnimation = ValueAnimator.ofObject(new ArgbEvaluator(), colorFrom, colorTo);
        colorAnimation.setDuration(milliseconds); // milliseconds
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {

            @Override
            public void onAnimationUpdate(ValueAnimator animator) {
                view.setBackgroundColor((int) animator.getAnimatedValue());
            }

        });

        colorAnimation.addListener(new Animator.AnimatorListener() {
            @Override
            public void onAnimationStart(Animator animation) {

            }

            @Override
            public void onAnimationEnd(Animator animation) {
                if (unfold) {
//                    titleViewHolder.getTitleView().setVisibility(View.VISIBLE);
                }
            }

            @Override
            public void onAnimationCancel(Animator animation) {

            }

            @Override
            public void onAnimationRepeat(Animator animation) {

            }
        });

        if (unfold) {
            colorAnimation.setStartDelay(300);
        }
        colorAnimation.start();
    }

    @Override
    public void show(NRErrorHandler.ErrorType errorType) { // error handler
        switch (errorType) {
            case TIMEOUT_UPPER_LINE:
                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (!(view instanceof NRErrorView)) {
                    noConnecttionView.getLayoutParams().height = (int) Calculate.pxFromDp(getContext(), NO_CONNECTION_HEIGHT);
                    searchBarView.dismissKeyboard();
                }
                break;
        }

    }

    @Override
    public void dismiss() {
        noConnecttionView.getLayoutParams().height = 0;
        noConnecttionView.requestLayout();
    }


    public NRApplicationContentListener getApplicationContentListener() {
        return applicationContentListener;
    }


    @Override
    public void onLabelSelected(final NRLabel label) {
        this.currentLabel = label;
        if(actionBarTextView != null) {
            actionBarTextView.setText(label.getTitle());
        }
        Nanorep.getInstance().setContext(label.getContext(), new OnDataResponse<DefaultResponse>() {
            @Override
            public void onSuccess(DefaultResponse response) {
                mFetchedDataManager.fetchLabelFAQ(label);
            }

            @Override
            public void onError(NRConnectionException error) {

            }
        });
    }
}
