package nanorep.nanowidget.DataClass;

import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.support.v7.app.AlertDialog;
import android.util.Base64;
import android.util.Log;
import android.view.inputmethod.InputMethodManager;


import com.google.gson.Gson;
import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Connection.NRConnection;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Interfaces.NRSpeechRecognizerCompletion;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRFAQLikeParams;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.RequestParams.NRSearchLikeParams;
import com.nanorep.nanoclient.Response.NRFAQAnswer;
import com.nanorep.nanoclient.Response.NRFAQData;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.Response.NRSearchResponse;
import com.nanorep.nanoclient.Response.NRSuggestions;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.NRContextList;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.OnDataResponse;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRFetcherListener;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

/**
 * Created by nissimpardo on 04/06/16.
 */
public class NRFetchedDataManager {

    private NRFAQData mFaqData;
    private NRFetcherListener mFetcherListener;
    private NRConfigFetcherListener mconfigFetcherListener;
    Context mContext;
    private String preContextSelectionQuery;
    private String userSelectedContext;

    public NRFetchedDataManager(Context context, NRConfigFetcherListener configFetcherListener) {
        mContext = context;
        mconfigFetcherListener = configFetcherListener;

        fetchConfiguration();
    }

    public void fetchConfiguration() {
        if (Nanorep.getInstance().getNRConfiguration() != null) {
            mconfigFetcherListener.onConfigurationReady();
            prepareDatasource();
        }
    }

    public void setFetcherListener(NRFetcherListener listener) {
        mFetcherListener = listener;
    }

    public void setConfigFetcherListener(NRConfigFetcherListener mconfigFetcherListener) {
        this.mconfigFetcherListener = mconfigFetcherListener;
    }

    private void prepareDatasource() {
        if (Nanorep.getInstance().getAccountParams().isLabelsMode()) {
            updateCategoriesResults(null);
            return;
        }

        /*

          if (cnf.getIsContextDependent()) {
                            fetchFaqList(new NRConnection.Listener() {
                                @Override
                                public void response(Object responseParam, int status, NRError error) {
                                    if (responseParam != null && responseParam instanceof ArrayList) {
                                        cnf.setFaqData((ArrayList) responseParam);
                                        overrideCnfData(cnf);
                                        NRCacheManager.storeAnswerById(mContext, NRUtilities.md5(mAccountParams.getKnowledgeBase() + mAccountParams.getAccount() + mAccountParams.getNanorepContext()), cnf.getmParams());
                                        if (!fast) {
                                            updateFAQContentsAndCallHello(cnf);
                                        }
                                    } else {
                                        overrideCnfData(cnf);
                                    }
                                    if (onConfigurationFetchedListener != null) {
                                        if (error != null) {
                                            onConfigurationFetchedListener.onConfigurationFetched(error);
                                        } else if (responseParam != null) {
                                            onConfigurationFetchedListener.onConfigurationFetched(null);

                                        } else {
                                            onConfigurationFetchedListener.onConfigurationFetched(NRError.error("com.nanorepfaq", 1002, "faqData empty"));
                                        }
                                    }
    }
         */

        NRConnection.Listener listener = new NRConnection.Listener() {
            @Override
            public void response(Object responseParam, int status, NRError error) {

                final ArrayList<NRFAQGroupItem> groups = new ArrayList<>();
                if (responseParam instanceof HashMap) {
                    final HashMap<String, Object> map = (HashMap<String, Object>) responseParam;
                    final NRFAQGroupItem group = new NRFAQGroupItem(map);
                    groups.add(group);
                    mconfigFetcherListener.insertRows(groups);
                }
            }

            @Override
            public void log(String tag, String msg) {

            }
        };

        Nanorep.getInstance().updateFaqList(null, Nanorep.getInstance().getAccountParams().getContext(), true, listener);


    }

    private void updateCategoriesResults(ArrayList<NRFAQGroupItem> groups) {
        if (groups != null) {

            mconfigFetcherListener.insertRows(groups);
        } else {
            mconfigFetcherListener.insertRows(null);
        }
    }

    public static ArrayList<NRResult> generateNRResultArray(ArrayList<NRQueryResult> queryResults, Context context) {
        if (queryResults != null) {
            int height = Integer.valueOf(Nanorep.getInstance().getNRConfiguration().getTitle().getTitleRowHeight());
            ArrayList<NRResult> results = new ArrayList<>();
            for (NRQueryResult result : queryResults) {
                NRResult currentResult = new NRResult(result, NRResultItem.RowType.TITLE);
                currentResult.setHeight((int) Calculate.pxFromDp(context, height));
                results.add(currentResult);
            }
            return results;
        }
        return null;
    }

    public void searchText(final String text) {
        Nanorep.getInstance().searchText(text, new Nanorep.OnSearchResultsFetchedListener() {
            @Override
            public void onSearchResponse(NRSearchResponse response, NRError error) {
                if (error != null) {

                } else {
                    ArrayList<NRResult> results = generateNRResultArray(response.getAnswerList(), mContext);
                    boolean contextSelectionOnly = false;
                    String selectedContextId;
                    String contextName = null;
                    try {
                        contextSelectionOnly = (boolean) response.getAnswerList().get(0).getParams().get("contextSelectionOnly");
                        selectedContextId = (String) response.getAnswerList().get(0).getParams().get("context");
                        selectedContextId = selectedContextId.split(",")[0];
                        List<Map<String, Object>> contextList = (List<Map<String, Object>>) ((Map<String, Object>) response.getParams().get("context")).get("values");
                        contextList.size();
                        contextName = findContextName(selectedContextId, contextList);
                        if (contextName == null) {
                            contextSelectionOnly = false;
                        }
                    } catch (NullPointerException | ClassCastException e) {
                        contextSelectionOnly = false;
                    }
                    if (contextSelectionOnly) {
                        preContextSelectionQuery = text;
                        fetchContextSelectionData(contextName);
                    } else {
                        mFetcherListener.insertRows(results, userSelectedContext);
                    }
                }
            }
        });
    }

    private void fetchContextSelectionData(final String contextName) {
        Nanorep.getInstance().getContextValues(contextName, new OnDataResponse<NRContextList>() {
            @Override
            public void onSuccess(NRContextList contextList) {
                showContextSelectionDialog(contextName, contextList);
            }

            @Override
            public void onError(NRConnectionException error) {
                //crappy parsing until server side will support json response
                String json = error.getData().substring("contextValuesHandler(".length(), error.getData().length() - 2);
                NRContextList contextList = new Gson().fromJson(json, NRContextList.class);
                showContextSelectionDialog(contextName, contextList);
            }
        });
    }

    private void showContextSelectionDialog(final String contextName, final NRContextList contextList) {

        CharSequence[] list = new CharSequence[contextList.getValues().size()];
        contextList.getValues().toArray(list);

        AlertDialog.Builder builder = new AlertDialog.Builder(mContext);
        builder
                .setTitle("Select context")
                .setItems(list, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int position) {
                        addContextToSession(contextName + ":" + contextList.getValues().get(position));
                    }
                });
        builder.create().show();
    }

    private void addContextToSession(final String context) {
        Nanorep.getInstance().setContext(context, new OnDataResponse<DefaultResponse>() {
            @Override
            public void onSuccess(DefaultResponse response) {
                Nanorep.getInstance().removeFromSearchCache(preContextSelectionQuery);
                userSelectedContext = context;
                searchText(preContextSelectionQuery);
            }

            @Override
            public void onError(NRConnectionException error) {

            }
        });
    }

    private String findContextName(String selectedContextId, List<Map<String, Object>> contextList) {
        for (Map<String, Object> map : contextList) {
            String id = String.valueOf(map.get("id"));
            if (id.equals(selectedContextId)) {
                return (String) map.get("name");
            }

        }
        return null;
    }

    public void searchSuggestion(final String suggestion) {
        Nanorep.getInstance().suggestionsForText(suggestion, new Nanorep.OnSuggestionsFetchedListener() {
            @Override
            public void onSuggestionsFetched(NRSuggestions suggestions, NRError error) {
                if (error != null) {
                    Log.d("Fetcher", error.getDomain());
                } else if (suggestions != null && suggestions.getSuggestions() != null) {
                    mFetcherListener.presentSuggestion(suggestion, suggestions.getSuggestions());
                }
            }
        });
    }

    public void startSpeech(NRSpeechRecognizerCompletion completion) {
//        mNanoRep.startVoiceRecognition(completion);
    }

    public void sendLike(NRLikeType likeType, String feedbackText, NRQueryResult result, Nanorep.OnLikeSentListener completion) {
        if (true) {
            NRFAQLikeParams likeParams = new NRFAQLikeParams(result, feedbackText);
            likeParams.setLikeType(likeType);
            likeParams.setAnswerId(result.getId());
            Nanorep.getInstance().likeForFAQResult(likeParams, completion);
        } else {
            NRSearchLikeParams likeParams = new NRSearchLikeParams(result);
            likeParams.setFeedbackType(likeType);
            Nanorep.getInstance().likeForSearchResult(likeParams, completion);
        }
    }

    public void resetLike(String resultId) {
        for (NRQueryResult result : mFaqData.getGroups().get(0).getAnswers()) {
            if (result.getId().equals(resultId)) {
                result.setLikeState(NRQueryResult.LikeState.notSelected);
            }
        }
    }

    public void faqAnswer(final String answerId, Integer answerHash, final OnFAQAnswerFetched answerFetcher) {
        Nanorep.getInstance().fetchFAQAnswer(answerId, answerHash, new Nanorep.OnFAQAnswerFetchedListener() {
            @Override
            public void onFAQAnswerFetched(NRFAQAnswer faqAnswer, NRError error) {
                if (error == null) {
                    answerFetcher.onAnswerFetched(faqAnswer);
                } else {
                    answerFetcher.onAnswerFetched(null);
                }
            }
        });
    }

    private void onRequestError(NRError error) {

    }

    public void clearUserSelectedContext() {
        userSelectedContext = null;
    }

    public void fetchLabelFAQ(final NRLabel label) {
        final NRConnection.Listener listener = new NRConnection.Listener() {
            @Override
            public void response(Object responseParam, int status, NRError error) {

                final ArrayList<NRFAQGroupItem> groups = new ArrayList<>();
                if (responseParam instanceof HashMap) {
                    final HashMap<String, Object> map = (HashMap<String, Object>) responseParam;
                    final NRFAQGroupItem group = new NRFAQGroupItem(map);
                    groups.add(group);
                    mconfigFetcherListener.insertRows(groups);
                }
            }

            @Override
            public void log(String tag, String msg) {

            }
        };

//        Integer.toHexString(label.getId())
        Nanorep.getInstance().updateFaqList(null, label.getContext(), false, listener);
    }

    private boolean duplicateFAQ(NRQueryResult nrQueryResult, ArrayList<NRQueryResult> answers) {
        for (NRQueryResult answer : answers) {
            if (answer.getId().equals(nrQueryResult.getId())) {
                return true;
            }
        }
        return false;
    }
}
