/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Fragments;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Spannable;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingPhoneNumber;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRExtraDataListener;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRAnswer;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresentor;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.ChannelPresenters.NRCustomScriptChannelPresentor;
import nanorep.nanowidget.Components.DislikeDialog;
import nanorep.nanowidget.Components.MyWebView;
import nanorep.nanowidget.Components.NRCategoriesView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRLikeView;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRResultTopView;
import nanorep.nanowidget.Components.NRResultsView;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.Components.NRTitleView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRLabelsAdapter;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.DataClass.NRResultsAdapter;
import nanorep.nanowidget.Fragments.NRWebContentFragment;
import nanorep.nanowidget.R;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRApplicationContentListener;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRFetcherListener;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

public class NRMainFragment
extends Fragment
implements NRSearchBarListener,
NRLabelsAdapter.NRLabelsListener,
NRSuggestionsListener,
NRCategoriesView.Listener,
NRResultsView.Listener,
NRContentView.Listener,
NRChannelItem.OnChannelSelectedListener,
NRResultTopView.Listener,
NRErrorHandler.Listener {
    public static final String TAG = NRMainFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;
    private NRFetchedDataManager mFetchedDataManager;
    private NRCustomViewAdapter viewAdapter;
    private RelativeLayout mLoadingView;
    private LinearLayout fragmentMainLayout;
    private FrameLayout contentMain;
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;
    private NRCustomSuggestionsView mSuggestionsView;
    private LinearLayout mSuggestionViewContainer;
    private NRCategoriesView categoriesView;
    private boolean resetSuggestions = false;
    private boolean autocompleteEnabled = true;
    private View.OnKeyListener onKeyListener;
    private TextView mNoTitleView;
    private RelativeLayout mNotitleViewHolder;
    private LinearLayout noConnecttionView;
    private boolean animation = false;
    private NRApplicationContentListener applicationContentListener;
    private NRCustomChannelView channelView;
    private String articleId;
    private Button clearContextButton;
    private TextView userSelecteContextTextView;
    private LinearLayout userSelectedContextLayout;
    private String userSelectedContextKey;
    private NRLabel currentLabel;
    private TextView actionBarTextView;
    private NRResult currentResult;

    public static NRMainFragment newInstance(String context) {
        NRMainFragment fragment = new NRMainFragment();
        return fragment;
    }

    @Override
    public void fetchBodyForResult(final NRCustomContentView view, String resultID, Integer resultHash) {
        this.articleId = resultID;
        this.mFetchedDataManager.faqAnswer(resultID, resultHash, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                if (result != null) {
                    view.loadData(result.getBody(), "text/html", "UTF-8");
                }
            }
        });
    }

    @Override
    public void closeAnswer() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (!this.animation) {
            view.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_out_left));
        } else if (view instanceof NRResultTopView && !((NRResultTopView)view).getmResult().isSingle()) {
            ((NRResultTopView)view).setResultUnFoldState(false);
            ((NRResultTopView)view).removeTopView();
        }
        this.contentMain.removeView(view);
    }

    @Override
    public void onChannelSelected(final NRChanneling channeling) {
        if (this.currentResult.getFetchedResult().getExtraData() == null) {
            this.openChannel(channeling);
            return;
        }
        Nanorep.getInstance().getWidgetListener().personalInfoWithExtraData(channeling.getChannelDescription(), this.getCurrentResult().getExtraData(), new NRExtraDataListener(){

            public void onExtraData(Map<String, String> extraData) {
                channeling.setExtraData(extraData);
                NRMainFragment.this.openChannel(channeling);
            }
        });
    }

    private void openChannel(NRChanneling channeling) {
        NRChannelPresentor presentor = NRChannelStrategy.presentor(this.getContext(), channeling, Nanorep.getInstance());
        if (presentor instanceof NRCustomScriptChannelPresentor) {
            presentor.present();
        } else {
            String url = presentor.getUrl();
            if (url != null) {
                RelativeLayout holder = (RelativeLayout)this.getView().findViewById(R.id.fragment_place_holder);
                holder.setVisibility(0);
                NRWebContentFragment webContentFragment = NRWebContentFragment.newInstance(url);
                webContentFragment.setListener(new NRWebContentFragment.WebFormListener(){

                    @Override
                    public void onDismiss(String result) {
                        if (result != null) {
                            Nanorep.getInstance().getWidgetListener().onSubmitSupportForm(result);
                        }
                        NRMainFragment.this.getView().requestFocus();
                    }
                });
                this.getFragmentManager().beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(R.id.content_main, (Fragment)webContentFragment).addToBackStack("linked").commit();
            } else if (channeling.getType() == NRChanneling.NRChannelingType.PhoneNumber) {
                String phoneNumber = ((NRChannelingPhoneNumber)channeling).getPhoneNumber();
                Intent intent = new Intent("android.intent.action.DIAL", Uri.fromParts((String)"tel", (String)phoneNumber, null));
                intent.setFlags(0x10008000);
                this.startActivity(intent);
            }
        }
    }

    private NRQueryResult getCurrentResult() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRResultTopView) {
            return ((NRResultTopView)view).getmResult().getFetchedResult();
        }
        return null;
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
        this.mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                NRResult newResult = new NRResult(result, NRResultItem.RowType.TITLE);
                int height = Integer.valueOf(Nanorep.getInstance().getNRConfiguration().getTitle().getTitleRowHeight());
                newResult.setHeight((int)Calculate.pxFromDp(NRMainFragment.this.getContext(), height));
                newResult.setSingle(true);
                NRResultTopView resultTopView = NRMainFragment.this.getTopView();
                NRMainFragment.this.contentMain.addView((View)resultTopView);
                resultTopView.startAnimation(AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_in_left));
                resultTopView.openOpenedView(newResult);
                NRMainFragment.this.getView().requestFocus();
            }
        });
    }

    @Override
    public void onLinkClicked(String url) {
        MyWebView webView = new MyWebView(this.getContext(), url, new MyWebView.Listener(){

            @Override
            public void onDismiss() {
                NRMainFragment.this.contentMain.removeViewAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                NRMainFragment.this.getView().requestFocus();
            }
        });
        this.contentMain.addView((View)webView);
        this.getView().requestFocus();
    }

    @Override
    public void onDismiss() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRResultTopView) {
            view.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_out_left));
        }
        this.removeTopView();
    }

    @Override
    public void onLikeClicked(final NRResultTopView view, final NRCustomLikeView likeView, String resultId, boolean isLike) {
        NRResult result = view.getmResult();
        if (isLike) {
            result.getFetchedResult().setLikeState(NRQueryResult.LikeState.positive);
            this.mFetchedDataManager.sendLike(NRLikeType.POSITIVE, "", result.getFetchedResult(), new Nanorep.OnLikeSentListener(){

                public void onLikeSent(boolean success) {
                    if (!success) {
                        view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                        likeView.resetLikeView();
                    }
                }
            });
        } else if (!isLike) {
            if (likeView.shouldOpenDialog()) {
                this.openDislikeDialog(result, view, likeView);
            } else {
                this.onDislike(result, view, likeView, NRLikeType.INCORRECT_ANSWER, "");
            }
        }
    }

    private void onDislike(NRResult result, final NRResultTopView view, final NRCustomLikeView likeView, NRLikeType type, String feedbackText) {
        result.getFetchedResult().setLikeState(NRQueryResult.LikeState.negative);
        this.mFetchedDataManager.sendLike(type, feedbackText, result.getFetchedResult(), new Nanorep.OnLikeSentListener(){

            public void onLikeSent(boolean success) {
                if (!success) {
                    view.getmResult().getFetchedResult().setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                }
            }
        });
        this.removeTopView();
    }

    private void onDismissDislike() {
        Nanorep.getInstance().getChanneling(this.articleId, false, (OnDataResponse)new OnDataResponse<List<NRChanneling>>(){

            public void onSuccess(List<NRChanneling> response) {
                View view = NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                if (view instanceof NRResultTopView) {
                    NRQueryResult fetchedResult = ((NRResultTopView)view).getmResult().getFetchedResult();
                    for (NRChanneling channel : response) {
                        channel.setQueryResult(fetchedResult);
                    }
                }
                NRMainFragment.this.channelView.setVisibility(0);
                NRMainFragment.this.channelView.setChanneling(response);
            }

            public void onError(NRConnectionException error) {
            }
        });
    }

    private void openDislikeDialog(final NRResult result, final NRResultTopView view, final NRCustomLikeView likeView) {
        String[] reasons = new String[]{this.getString(R.string.missing_information), this.getString(R.string.didnt_find)};
        View dislikeView = this.getActivity().getLayoutInflater().inflate(R.layout.dislike_dialog_gojek, null);
        DislikeDialog dislikeAlert = new DislikeDialog(this.getContext(), dislikeView);
        dislikeAlert.setListener(new DislikeDialog.Listener(){

            @Override
            public void onCancel() {
                likeView.resetLikeView();
                NRMainFragment.this.onDismissDislike();
            }

            @Override
            public void onDislike(NRLikeType type, String feedbackText) {
                NRMainFragment.this.onDislike(result, view, likeView, type, feedbackText);
            }
        });
        dislikeAlert.setDislikeOptions(reasons);
    }

    public static NRMainFragment newInstance() {
        Bundle args = new Bundle();
        NRMainFragment fragment = new NRMainFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof NRCustomViewAdapter) {
            this.viewAdapter = (NRCustomViewAdapter)context;
        }
    }

    private void initDataManager() {
        this.mFetchedDataManager = new NRFetchedDataManager(this.getContext(), new NRConfigFetcherListener(){

            @Override
            public void onConfigurationReady() {
                View view = NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) {
                    NRMainFragment.this.contentMain.removeView(view);
                }
                NRMainFragment.this.updateTitleNormalText();
                NRMainFragment.this.updateSearchBar();
                NRMainFragment.this.showSuggestionsView();
                NRMainFragment.this.mLoadingView.setVisibility(8);
            }

            @Override
            public void insertRows(ArrayList<NRFAQGroupItem> groups) {
                NRMainFragment.this.hideKeyboard();
                if (groups != null && groups.size() > 1 || Nanorep.getInstance().getAccountParams().isLabelsMode()) {
                    NRMainFragment.this.openCategoriesView(groups);
                } else if (groups.size() == 1) {
                    NRMainFragment.this.mFetchedDataManager;
                    NRMainFragment.this.openNRResultView(NRFetchedDataManager.generateNRResultArray(groups.get(0).getAnswers(), NRMainFragment.this.getContext()), groups.get(0).getTitle());
                }
            }

            @Override
            public void onError() {
                NRMainFragment.this.mLoadingView.setVisibility(8);
                ((NRMainFragment)NRMainFragment.this).noConnecttionView.getLayoutParams().height = 0;
                NRMainFragment.this.noConnecttionView.requestLayout();
                NRErrorView errorView = new NRErrorView(NRMainFragment.this.getContext());
                errorView.setListener(new NRErrorView.Listener(){

                    @Override
                    public void tryAgain() {
                        NRMainFragment.this.mFetchedDataManager.fetchConfiguration();
                        NRMainFragment.this.mLoadingView.setVisibility(0);
                    }
                });
                NRMainFragment.this.contentMain.addView((View)errorView);
            }
        });
        this.mFetchedDataManager.setFetcherListener(new NRFetcherListener(){

            @Override
            public void reloadWithAnimation() {
            }

            @Override
            public void reload() {
            }

            @Override
            public void insertRows(List<NRResult> results, String userSelectedContext) {
                NRMainFragment.this.hideKeyboard();
                if (userSelectedContext == null) {
                    NRMainFragment.this.userSelectedContextLayout.setVisibility(8);
                } else {
                    NRMainFragment.this.userSelectedContextLayout.setVisibility(0);
                    String[] ctx = userSelectedContext.split(":");
                    if (ctx.length != 2) {
                        return;
                    }
                    NRMainFragment.this.userSelecteContextTextView.setText((CharSequence)ctx[1]);
                    NRMainFragment.this.userSelectedContextKey = ctx[0];
                }
                if (results == null || results != null && results.size() == 0) {
                    if (NRMainFragment.this.searchBarView.getText() != null) {
                        ((NRMainFragment)NRMainFragment.this).mNotitleViewHolder.getLayoutParams().height = (int)Calculate.pxFromDp(NRMainFragment.this.getContext(), 100.0f);
                        NRMainFragment.this.mNoTitleView.setText((CharSequence)Nanorep.getInstance().getNRConfiguration().getCustomNoAnswersTextContext(NRMainFragment.this.searchBarView.getText()));
                        while (NRMainFragment.this.contentMain.getChildCount() > 2) {
                            NRMainFragment.this.contentMain.removeViewAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                        }
                        NRMainFragment.this.contentMain.setVisibility(0);
                        NRMainFragment.this.getView().requestFocus();
                    }
                } else if (results.size() == 1) {
                    NRMainFragment.this.currentResult = results.get(0);
                    NRMainFragment.this.articleId = NRMainFragment.this.currentResult.getFetchedResult().getId();
                    NRResultTopView resultTopView = NRMainFragment.this.getTopView();
                    NRMainFragment.this.contentMain.setVisibility(0);
                    NRMainFragment.this.contentMain.addView((View)resultTopView);
                    Animation animation = AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_in_left);
                    animation.setAnimationListener(new Animation.AnimationListener(){

                        public void onAnimationStart(Animation animation) {
                            for (int i = 0; i <= NRMainFragment.this.contentMain.getChildCount() - 2; ++i) {
                                View view = NRMainFragment.this.contentMain.getChildAt(i);
                                view.setVisibility(4);
                            }
                            NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1).setVisibility(0);
                        }

                        public void onAnimationEnd(Animation animation) {
                            for (int i = 0; i <= NRMainFragment.this.contentMain.getChildCount() - 2; ++i) {
                                View view = NRMainFragment.this.contentMain.getChildAt(i);
                                view.setVisibility(0);
                            }
                        }

                        public void onAnimationRepeat(Animation animation) {
                        }
                    });
                    resultTopView.setAnimation(animation);
                    resultTopView.startAnimation(animation);
                    NRResult result = results.get(0);
                    result.setSingle(true);
                    resultTopView.openOpenedView(result);
                    NRMainFragment.this.getView().requestFocus();
                } else if (results.size() > 1) {
                    NRMainFragment.this.contentMain.setVisibility(0);
                    NRMainFragment.this.openNRResultView(results, null);
                }
            }

            @Override
            public void presentSuggestion(String querytext, ArrayList<Spannable> suggestions) {
                if (!NRMainFragment.this.resetSuggestions && NRMainFragment.this.searchBarView.getText().length() - querytext.length() <= 1 && NRMainFragment.this.autocompleteEnabled) {
                    NRMainFragment.this.mSuggestionsView.setSuggestions(suggestions);
                    NRMainFragment.this.contentMain.setVisibility(4);
                }
            }

            @Override
            public void onConnectionFailed(HashMap<String, Object> errorParams) {
            }
        });
    }

    private void hideKeyboard() {
        View view = this.getView();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.viewAdapter == null) {
            this.viewAdapter = new NRViewAdapter();
        }
        NRErrorHandler.getInstance().setListener((NRErrorHandler.Listener)this);
    }

    public void onDestroyView() {
        super.onDestroyView();
        Nanorep.getInstance().reset();
    }

    public void onPause() {
        super.onPause();
        NRErrorHandler.getInstance().setListener(null);
    }

    private void openCategoriesView(ArrayList<NRFAQGroupItem> groups) {
        this.categoriesView = new NRCategoriesView((Context)this.getActivity());
        if (Nanorep.getInstance().getAccountParams().isLabelsMode()) {
            this.categoriesView.setLabels(this);
        } else {
            this.categoriesView.setCategories(groups, this.viewAdapter, this);
        }
        this.contentMain.addView((View)this.categoriesView);
    }

    private NRResultTopView getTopView() {
        NRCustomLikeView likeView;
        NRCustomContentView contentView;
        NRResultTopView resultTopView = new NRResultTopView((Context)this.getActivity());
        resultTopView.setListener(this);
        NRCustomTitleView titleView = this.viewAdapter.getTitle(this.getContext());
        if (titleView == null) {
            titleView = new NRTitleView(this.getContext());
            ((NRTitleView)titleView).configViewObjects(Nanorep.getInstance().getNRConfiguration());
        }
        if ((contentView = this.viewAdapter.getContent(this.getContext())) == null) {
            contentView = new NRContentView(this.getContext());
        }
        if (this.applicationContentListener != null) {
            contentView.setApplicationContentListener(this.applicationContentListener);
        }
        if ((likeView = this.viewAdapter.getLikeView(this.getContext())) == null) {
            likeView = new NRLikeView(this.getContext());
        }
        this.channelView = this.viewAdapter.getChannelView(this.getContext());
        if (this.channelView == null) {
            this.channelView = new NRChannelingView(this.getContext());
        }
        NRCustomFeedbackView feedbackView = this.viewAdapter.getFeedbackView(this.getContext());
        resultTopView.setTitleView(titleView);
        resultTopView.setContentView(contentView, this);
        if (feedbackView != null) {
            feedbackView.setCustomChannelView(this.channelView);
            feedbackView.setCustomLikeView(likeView);
            resultTopView.setLikeView(feedbackView.getCustomLikeView());
            resultTopView.setChannelView(feedbackView.getCustomChannelView(), this);
            resultTopView.setFeedbackView(feedbackView);
        } else {
            resultTopView.setLikeView(likeView);
            resultTopView.setChannelView(this.channelView, this);
        }
        return resultTopView;
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_main, container, false);
        this.mLoadingView = (RelativeLayout)view.findViewById(R.id.fragment_place_holder);
        this.contentMain = (FrameLayout)view.findViewById(R.id.content_main);
        this.fragmentMainLayout = (LinearLayout)view.findViewById(R.id.fragment_main_layout);
        this.mNotitleViewHolder = (RelativeLayout)view.findViewById(R.id.noTiltleView);
        this.mNoTitleView = (TextView)view.findViewById(R.id.noTitleTextView);
        this.noConnecttionView = (LinearLayout)view.findViewById(R.id.noConnecttionView);
        this.userSelecteContextTextView = (TextView)view.findViewById(R.id.user_selected_context_textview);
        this.clearContextButton = (Button)view.findViewById(R.id.clear_user_selected_button);
        this.userSelectedContextLayout = (LinearLayout)view.findViewById(R.id.current_user_selected_context_layout);
        this.clearContextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NRMainFragment.this.mFetchedDataManager.clearUserSelectedContext();
                NRMainFragment.this.userSelectedContextLayout.setVisibility(8);
                if (NRMainFragment.this.contentMain.getChildCount() > 1) {
                    NRMainFragment.this.removeTopView();
                }
                NRMainFragment.this.clearContextFromSession(NRMainFragment.this.userSelectedContextKey);
            }
        });
        this.setViews(view);
        this.initDataManager();
        return view;
    }

    private void clearContextFromSession(String ctx) {
        Nanorep.getInstance().setContext(ctx + ":", (OnDataResponse)new OnDataResponse<DefaultResponse>(){

            public void onSuccess(DefaultResponse response) {
                Nanorep.getInstance().clearCache();
            }

            public void onError(NRConnectionException error) {
            }
        });
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = Nanorep.getInstance().getNRConfiguration().getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = Nanorep.getInstance().getNRConfiguration().getSearchBar();
        this.searchBarView.setHint(searchBarConfig.getInitialText());
        String titleBGColor = "#0aa0ff";
        if (!NRMainFragment.isEmpty(titleConfig.getTitleBGColor())) {
            titleBGColor = titleConfig.getTitleBGColor();
        }
        this.searchBarView.setBackgroundColor(Color.parseColor((String)titleBGColor));
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = Nanorep.getInstance().getNRConfiguration().getTitle();
        ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
        View customActionBar = this.getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
        ActionBar.LayoutParams layout2 = new ActionBar.LayoutParams(-1, -1);
        actionBar.setCustomView(customActionBar, layout2);
        actionBar.setDisplayShowHomeEnabled(false);
        actionBar.setDisplayShowTitleEnabled(false);
        actionBar.setDisplayShowCustomEnabled(true);
        Toolbar parent = (Toolbar)customActionBar.getParent();
        parent.setPadding(0, 0, 0, 0);
        parent.setContentInsetsAbsolute(0, 0);
        this.actionBarTextView = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
        String titleText = this.getString(R.string.default_title);
        if (!NRMainFragment.isEmpty(title.getTitle())) {
            titleText = title.getTitle();
        }
        this.actionBarTextView.setText((CharSequence)titleText);
        if (!NRMainFragment.isEmpty(title.getTitleColor())) {
            String titleColor = title.getTitleColor();
            this.actionBarTextView.setTextColor(Color.parseColor((String)titleColor));
        }
        if (!NRMainFragment.isEmpty(title.getTitleBGColor())) {
            String titleBGColor = title.getTitleBGColor();
            RelativeLayout relativeLayout = (RelativeLayout)actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
            relativeLayout.setBackgroundColor(Color.parseColor((String)titleBGColor));
        }
        if (!NRMainFragment.isEmpty(title.getTitleFont())) {
            String titleFont = title.getTitleFont();
            this.actionBarTextView.setTypeface(Typeface.create((String)titleFont, (int)0));
        }
    }

    private void setTitleText(String title) {
        ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
        TextView tv = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
        tv.setText((CharSequence)title);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private void setViews(View nanoView) {
        this.mSuggestionViewContainer = (LinearLayout)nanoView.findViewById(R.id.suggestion_view_container);
        this.mSuggestionsView = this.viewAdapter.getSuggestionsView(this.getContext());
        if (this.mSuggestionsView == null) {
            this.mSuggestionsView = new NRSuggestionsView(this.getContext());
        }
        this.mSuggestionsView.setListener(this);
        this.mSuggestionViewContainer.addView((View)this.mSuggestionsView);
        this.searchBarContainer = (LinearLayout)nanoView.findViewById(R.id.search_bar_container);
        this.searchBarView = this.viewAdapter.getSearchBar(this.getContext());
        if (this.searchBarView == null) {
            this.searchBarView = new NRSearchBar(this.getContext());
        }
        this.searchBarView.setListener(this);
        this.searchBarContainer.addView((View)this.searchBarView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
    }

    @Override
    public void onStartRecording(ImageButton button) {
    }

    @Override
    public void fetchSuggestionsForText(String text) {
        this.hideNoTitleView();
        this.resetSuggestions = false;
        this.mFetchedDataManager.searchSuggestion(text);
    }

    @Override
    public void searchForText(String text) {
        this.resetSuggestions = true;
        this.mSuggestionsView.setSuggestions(null);
        this.mFetchedDataManager.searchText(text);
    }

    @Override
    public void onClearClicked(boolean byUser) {
        if (this.mNotitleViewHolder.getLayoutParams().height > 0) {
            this.mNotitleViewHolder.getLayoutParams().height = 0;
        }
        this.resetSuggestions = true;
        this.mSuggestionsView.setSuggestions(null);
        while (this.contentMain.getChildCount() > 1) {
            this.contentMain.removeViewAt(this.contentMain.getChildCount() - 1);
        }
        this.contentMain.setVisibility(0);
    }

    @Override
    public void onEmptyQuery() {
    }

    private void hideNoTitleView() {
        if (this.mNotitleViewHolder.getLayoutParams().height > 0) {
            this.mNotitleViewHolder.getLayoutParams().height = 0;
        }
    }

    @Override
    public void onSelectSuggestion(String suggestion) {
        this.resetSuggestions = true;
        this.searchBarView.dismissKeyboard();
        this.searchBarView.updateEditTextView(suggestion);
        this.resetSuggestions = true;
        this.mSuggestionsView.setSuggestions(null);
        this.mFetchedDataManager.searchText(suggestion);
    }

    private void showSuggestionsView() {
        if (!Nanorep.getInstance().getNRConfiguration().getAutocompleteEnabled()) {
            this.autocompleteEnabled = false;
        }
    }

    @Override
    public void onCategorySelected(NRFAQGroupItem groupItem) {
        this.openNRResultView(NRFetchedDataManager.generateNRResultArray(groupItem.getAnswers(), this.getContext()), groupItem.getTitle());
    }

    private void openNRResultView(List<NRResult> results, String title) {
        NRResultsView resultsView = new NRResultsView((Context)this.getActivity());
        resultsView.setListener(this);
        resultsView.setResults(results, title, this.viewAdapter);
        resultsView.setIsAnimated(this.animation);
        if (!NRMainFragment.isEmpty(title)) {
            this.setTitleText(title);
        }
        this.contentMain.addView((View)resultsView);
        if (this.getView() != null) {
            this.getView().requestFocus();
        }
    }

    @Override
    public void onResultSelected(final int y, NRResultsAdapter.ViewHolder titleViewHolder) {
        this.hideKeyboard();
        final NRResultTopView resultTopView = this.getTopView();
        this.contentMain.addView((View)resultTopView);
        this.animateBGColor(500, (View)resultTopView, true, titleViewHolder);
        final NRResult result = titleViewHolder.getResult();
        if (result.getFetchedResult().getBody() == null) {
            this.articleId = result.getFetchedResult().getId();
            this.mFetchedDataManager.faqAnswer(result.getFetchedResult().getId(), null, new OnFAQAnswerFetched(){

                @Override
                public void onAnswerFetched(NRQueryResult queryResult) {
                    result.setFetchedResult(queryResult);
                    NRMainFragment.this.currentResult = result;
                    NRMainFragment.this.presentResult(result, y, resultTopView);
                }
            });
        } else {
            this.presentResult(result, y, resultTopView);
        }
    }

    private void presentResult(NRResult result, int y, NRResultTopView resultTopView) {
        result.setUnfolded(true);
        if (this.animation) {
            resultTopView.openView(y, result);
        } else {
            resultTopView.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_in_left));
            resultTopView.openOpenedView(result);
        }
        this.getView().requestFocus();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.getView().setFocusableInTouchMode(true);
        this.getView().requestFocus();
        this.onKeyListener = new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 0) {
                    if (keyCode == 4) {
                        NRMainFragment.this.hideNoTitleView();
                        NRMainFragment.this.searchBarView.updateEditTextView("");
                        if (NRMainFragment.this.getFragmentManager().getBackStackEntryCount() == 1) {
                            NRMainFragment.this.getFragmentManager().popBackStack();
                            return true;
                        }
                        if (NRMainFragment.this.mSuggestionsView.getHeight() > 0) {
                            NRMainFragment.this.resetSuggestions = true;
                            NRMainFragment.this.mSuggestionsView.setSuggestions(null);
                            NRMainFragment.this.contentMain.setVisibility(0);
                            return true;
                        }
                        if (NRMainFragment.this.contentMain.getChildCount() > 1) {
                            View view = NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                            if (!NRMainFragment.this.animation) {
                                if (view instanceof NRResultTopView) {
                                    view.startAnimation(AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_out_left));
                                }
                                NRMainFragment.this.removeTopView();
                            } else if (view instanceof NRResultTopView) {
                                if (!((NRResultTopView)view).getmResult().isSingle()) {
                                    ((NRResultTopView)view).setResultUnFoldState(false);
                                    ((NRResultTopView)view).removeTopView();
                                    NRMainFragment.this.updateSearchBarTextForResultTop(view);
                                } else {
                                    view.startAnimation(AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_out_left));
                                    NRMainFragment.this.removeTopView();
                                }
                            } else {
                                NRMainFragment.this.removeTopView();
                            }
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }
        };
        this.getView().setOnKeyListener(this.onKeyListener);
    }

    private void removeTopView() {
        if (this.contentMain.getChildCount() == 2 && this.currentLabel != null) {
            String ctx = this.currentLabel.getContext();
            String[] parts = ctx.split(":");
            if (parts.length != 2) {
                return;
            }
            this.clearContextFromSession(parts[0]);
            this.currentLabel = null;
        }
        this.contentMain.removeViewAt(this.contentMain.getChildCount() - 1);
        View currentView = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (currentView instanceof NRResultTopView) {
            this.updateSearchBarTextForResultTop(currentView);
        } else {
            this.searchBarView.updateEditTextView("");
            this.getView().requestFocus();
            String title = Nanorep.getInstance().getNRConfiguration().getTitle().getTitle();
            if (currentView instanceof NRResultsView && !NRMainFragment.isEmpty(((NRResultsView)currentView).getTitle())) {
                title = ((NRResultsView)currentView).getTitle();
            }
            this.setTitleText(title);
        }
    }

    private void updateSearchBarTextForResultTop(View view) {
        if (((NRResultTopView)view).getmResult().getFetchedResult() instanceof NRAnswer) {
            this.searchBarView.updateEditTextView(((NRResultTopView)view).getmResult().getFetchedResult().getTitle());
            this.resetSuggestions = true;
            this.mSuggestionsView.setSuggestions(null);
            this.contentMain.setVisibility(0);
            this.getView().requestFocus();
        }
    }

    private void fadeViews(View view, float f, long duration, final boolean removeTopTitle) {
        view.animate().alpha(f).setDuration(duration).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (removeTopTitle) {
                    NRMainFragment.this.contentMain.removeViewAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) {
        if (beforeGoingDown) {
            this.animateBGColor(50, this.contentMain.getChildAt(this.contentMain.getChildCount() - 1), false, null);
        } else {
            this.fadeViews(this.contentMain.getChildAt(this.contentMain.getChildCount() - 1), 0.0f, 500L, true);
        }
    }

    private void animateBGColor(int milliseconds, final View view, final boolean unfold, final NRResultsAdapter.ViewHolder titleViewHolder) {
        int colorFrom = this.getResources().getColor(R.color.nr_background_color);
        int colorTo = this.getResources().getColor(R.color.white);
        if (!unfold) {
            colorFrom = -1;
            colorTo = this.getResources().getColor(R.color.nr_background_color);
        }
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration((long)milliseconds);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                view.setBackgroundColor(((Integer)animator.getAnimatedValue()).intValue());
            }
        });
        colorAnimation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (unfold) {
                    titleViewHolder.getTitleView().setVisibility(0);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        if (unfold) {
            colorAnimation.setStartDelay(300L);
        }
        colorAnimation.start();
    }

    public void show(NRErrorHandler.ErrorType errorType) {
        switch (errorType) {
            case TIMEOUT_UPPER_LINE: {
                View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) break;
                this.noConnecttionView.getLayoutParams().height = (int)Calculate.pxFromDp(this.getContext(), 24.0f);
                this.searchBarView.dismissKeyboard();
            }
        }
    }

    public void dismiss() {
        this.noConnecttionView.getLayoutParams().height = 0;
        this.noConnecttionView.requestLayout();
    }

    public NRApplicationContentListener getApplicationContentListener() {
        return this.applicationContentListener;
    }

    @Override
    public void onLabelSelected(final NRLabel label) {
        this.currentLabel = label;
        this.actionBarTextView.setText((CharSequence)label.getTitle());
        Nanorep.getInstance().setContext(label.getContext(), (OnDataResponse)new OnDataResponse<DefaultResponse>(){

            public void onSuccess(DefaultResponse response) {
                NRMainFragment.this.mFetchedDataManager.fetchLabelFAQ(label);
            }

            public void onError(NRConnectionException error) {
            }
        });
    }
}

