/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.nanorep.nanoclient.Nanorep;
import java.util.List;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.DataClass.NRResultsAdapter;
import nanorep.nanowidget.R;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;

public class NRResultsView
extends LinearLayout
implements NRResultsAdapter.Listener {
    private RecyclerView mResultsRecyclerView;
    private NRResultsAdapter adapter;
    private Listener listener;
    private boolean isAnimated;
    private String title;
    private RelativeLayout frequentlyQuestions;
    private TextView frequentlyQuestionsTv;

    public void setIsAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public void setAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
    }

    public NRResultsView(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.results_view, (ViewGroup)this);
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.frequentlyQuestions = (RelativeLayout)child.findViewById(R.id.frequentlyQuestions);
        this.frequentlyQuestionsTv = (TextView)child.findViewById(R.id.frequentlyQuestionsTv);
        this.adapter = new NRResultsAdapter();
        this.mResultsRecyclerView = (RecyclerView)child.findViewById(R.id.resultsView);
        String margin = Nanorep.getInstance().getNRConfiguration().getContent().getContentMarginTop();
        if (margin != null) {
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mResultsRecyclerView.getLayoutParams();
            params.setMargins(0, (int)Calculate.pxFromDp(this.getContext(), Float.valueOf(margin).floatValue()), 0, 0);
            this.mResultsRecyclerView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mResultsRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mResultsRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setResults(List<NRResult> results, String title, NRCustomViewAdapter viewAdapter) {
        this.title = title;
        this.adapter.setListener(this);
        this.adapter.setViewAdapter(viewAdapter);
        this.adapter.addItems(results);
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void onResultItemSelected(NRResultsAdapter.ViewHolder titleViewHolder, int pos) {
        int marginTop = titleViewHolder.getTitle_container().getHeight() * pos;
        int offSet = this.mResultsRecyclerView.computeVerticalScrollOffset();
        int divider = (int)Calculate.pxFromDp(this.getContext(), 5.0f) * pos;
        int y = marginTop - offSet + (int)Calculate.pxFromDp(this.getContext(), 16.0f) + divider;
        if (this.isAnimated) {
            titleViewHolder.getTitleView().setVisibility(4);
        }
        this.listener.onResultSelected(y, titleViewHolder);
    }

    public static interface Listener {
        public void onResultSelected(int var1, NRResultsAdapter.ViewHolder var2);
    }
}

