/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.DataClass;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.GetBinaryHttpTask;
import java.util.ArrayList;
import java.util.List;
import nanorep.nanowidget.R;

public class NRLabelsAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final NRLabelsListener listener;
    private List<NRLabel> labels;

    public NRLabelsAdapter(NRLabelsListener listener) {
        this.listener = listener;
        this.labels = Nanorep.getInstance().getNRConfiguration().getLabels();
        if (this.labels == null) {
            this.labels = new ArrayList<NRLabel>();
        }
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Context context = parent.getContext();
        View view = LayoutInflater.from((Context)context).inflate(R.layout.title_item_label, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        NRLabel label = this.labels.get(position);
        holder.textView.setText((CharSequence)label.getTitle());
        this.loadImage(holder.imageView, label.getIcon());
    }

    private void loadImage(final ImageView imageView, String url) {
        if (url == null || url.length() == 0) {
            return;
        }
        new GetBinaryHttpTask(url, new GetBinaryHttpTask.HttpBinaryResponse(){

            public void success(byte[] response) {
                Bitmap b = NRLabelsAdapter.this.convertToBitmap(response);
                if (b != null) {
                    imageView.setImageBitmap(b);
                }
            }

            public void error() {
            }
        }).execute((Object[])new Void[0]);
    }

    public Bitmap convertToBitmap(byte[] bytes) {
        try {
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
            return bitmap;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
    }

    public int getItemCount() {
        return this.labels.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        public ImageView imageView;
        public TextView textView;

        public ViewHolder(View view) {
            super(view);
            view.findViewById(R.id.titleLayout).setOnClickListener((View.OnClickListener)this);
            this.textView = (TextView)view.findViewById(R.id.titleTextView);
            this.imageView = (ImageView)view.findViewById(R.id.label_image);
        }

        public void onClick(View v) {
            NRLabelsAdapter.this.listener.onLabelSelected((NRLabel)NRLabelsAdapter.this.labels.get(this.getAdapterPosition()));
        }
    }

    public static interface NRLabelsListener {
        public void onLabelSelected(NRLabel var1);
    }
}

