/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.DataClass;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import com.google.gson.Gson;
import com.nanorep.nanoclient.Connection.NRConnection;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Interfaces.NRSpeechRecognizerCompletion;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRFAQLikeParams;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRFAQAnswer;
import com.nanorep.nanoclient.Response.NRFAQData;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.Response.NRSearchResponse;
import com.nanorep.nanoclient.Response.NRSuggestions;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.NRContextList;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRFetcherListener;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

public class NRFetchedDataManager {
    private NRFAQData mFaqData;
    private NRFetcherListener mFetcherListener;
    private NRConfigFetcherListener mconfigFetcherListener;
    Context mContext;
    private String preContextSelectionQuery;
    private String userSelectedContext;

    public NRFetchedDataManager(Context context, NRConfigFetcherListener configFetcherListener) {
        this.mContext = context;
        this.mconfigFetcherListener = configFetcherListener;
        this.fetchConfiguration();
    }

    public void fetchConfiguration() {
        if (Nanorep.getInstance().getNRConfiguration() != null) {
            this.mconfigFetcherListener.onConfigurationReady();
            this.prepareDatasource();
        }
    }

    public void setFetcherListener(NRFetcherListener listener) {
        this.mFetcherListener = listener;
    }

    public void setConfigFetcherListener(NRConfigFetcherListener mconfigFetcherListener) {
        this.mconfigFetcherListener = mconfigFetcherListener;
    }

    private void prepareDatasource() {
        if (Nanorep.getInstance().getAccountParams().isLabelsMode()) {
            this.updateCategoriesResults(null);
            return;
        }
        NRConnection.Listener listener = new NRConnection.Listener(){

            public void response(Object responseParam, int status, NRError error) {
                ArrayList<NRFAQGroupItem> groups = new ArrayList<NRFAQGroupItem>();
                if (responseParam instanceof HashMap) {
                    HashMap map = (HashMap)responseParam;
                    NRFAQGroupItem group = new NRFAQGroupItem(map);
                    groups.add(group);
                    NRFetchedDataManager.this.mconfigFetcherListener.insertRows(groups);
                }
            }

            public void log(String tag, String msg) {
            }
        };
        Nanorep.getInstance().updateFaqList(null, Nanorep.getInstance().getAccountParams().getContext(), true, listener);
    }

    private void updateCategoriesResults(ArrayList<NRFAQGroupItem> groups) {
        if (groups != null) {
            this.mconfigFetcherListener.insertRows(groups);
        } else {
            this.mconfigFetcherListener.insertRows(null);
        }
    }

    public static ArrayList<NRResult> generateNRResultArray(ArrayList<NRQueryResult> queryResults, Context context) {
        if (queryResults != null) {
            int height = Integer.valueOf(Nanorep.getInstance().getNRConfiguration().getTitle().getTitleRowHeight());
            ArrayList<NRResult> results = new ArrayList<NRResult>();
            for (NRQueryResult result : queryResults) {
                NRResult currentResult = new NRResult(result, NRResultItem.RowType.TITLE);
                currentResult.setHeight((int)Calculate.pxFromDp(context, height));
                results.add(currentResult);
            }
            return results;
        }
        return null;
    }

    public void searchText(final String text) {
        Nanorep.getInstance().searchText(text, new Nanorep.OnSearchResultsFetchedListener(){

            public void onSearchResponse(NRSearchResponse response, NRError error) {
                if (error == null) {
                    ArrayList<NRResult> results = NRFetchedDataManager.generateNRResultArray(response.getAnswerList(), NRFetchedDataManager.this.mContext);
                    boolean contextSelectionOnly = false;
                    String contextName = null;
                    try {
                        contextSelectionOnly = (Boolean)((NRQueryResult)response.getAnswerList().get(0)).getParams().get("contextSelectionOnly");
                        String selectedContextId = (String)((NRQueryResult)response.getAnswerList().get(0)).getParams().get("context");
                        selectedContextId = selectedContextId.split(",")[0];
                        List contextList = (List)((Map)response.getParams().get("context")).get("values");
                        contextList.size();
                        contextName = NRFetchedDataManager.this.findContextName(selectedContextId, contextList);
                        if (contextName == null) {
                            contextSelectionOnly = false;
                        }
                    }
                    catch (ClassCastException | NullPointerException e) {
                        contextSelectionOnly = false;
                    }
                    if (contextSelectionOnly) {
                        NRFetchedDataManager.this.preContextSelectionQuery = text;
                        NRFetchedDataManager.this.fetchContextSelectionData(contextName);
                    } else {
                        NRFetchedDataManager.this.mFetcherListener.insertRows(results, NRFetchedDataManager.this.userSelectedContext);
                    }
                }
            }
        });
    }

    private void fetchContextSelectionData(final String contextName) {
        Nanorep.getInstance().getContextValues(contextName, (OnDataResponse)new OnDataResponse<NRContextList>(){

            public void onSuccess(NRContextList contextList) {
                NRFetchedDataManager.this.showContextSelectionDialog(contextName, contextList);
            }

            public void onError(NRConnectionException error) {
                String json = error.getData().substring("contextValuesHandler(".length(), error.getData().length() - 2);
                NRContextList contextList = (NRContextList)new Gson().fromJson(json, NRContextList.class);
                NRFetchedDataManager.this.showContextSelectionDialog(contextName, contextList);
            }
        });
    }

    private void showContextSelectionDialog(final String contextName, final NRContextList contextList) {
        CharSequence[] list = new CharSequence[contextList.getValues().size()];
        contextList.getValues().toArray(list);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setTitle((CharSequence)"Select context").setItems(list, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int position) {
                NRFetchedDataManager.this.addContextToSession(contextName + ":" + (String)contextList.getValues().get(position));
            }
        });
        builder.create().show();
    }

    private void addContextToSession(final String context) {
        Nanorep.getInstance().setContext(context, (OnDataResponse)new OnDataResponse<DefaultResponse>(){

            public void onSuccess(DefaultResponse response) {
                Nanorep.getInstance().removeFromSearchCache(NRFetchedDataManager.this.preContextSelectionQuery);
                NRFetchedDataManager.this.userSelectedContext = context;
                NRFetchedDataManager.this.searchText(NRFetchedDataManager.this.preContextSelectionQuery);
            }

            public void onError(NRConnectionException error) {
            }
        });
    }

    private String findContextName(String selectedContextId, List<Map<String, Object>> contextList) {
        for (Map<String, Object> map : contextList) {
            String id2 = String.valueOf(map.get("id"));
            if (!id2.equals(selectedContextId)) continue;
            return (String)map.get("name");
        }
        return null;
    }

    public void searchSuggestion(final String suggestion) {
        Nanorep.getInstance().suggestionsForText(suggestion, new Nanorep.OnSuggestionsFetchedListener(){

            public void onSuggestionsFetched(NRSuggestions suggestions, NRError error) {
                if (error != null) {
                    Log.d((String)"Fetcher", (String)error.getDomain());
                } else if (suggestions != null && suggestions.getSuggestions() != null) {
                    NRFetchedDataManager.this.mFetcherListener.presentSuggestion(suggestion, suggestions.getSuggestions());
                }
            }
        });
    }

    public void startSpeech(NRSpeechRecognizerCompletion completion) {
    }

    public void sendLike(NRLikeType likeType, String feedbackText, NRQueryResult result, Nanorep.OnLikeSentListener completion) {
        NRFAQLikeParams likeParams = new NRFAQLikeParams(result, feedbackText);
        likeParams.setLikeType(likeType);
        likeParams.setAnswerId(result.getId());
        Nanorep.getInstance().likeForFAQResult(likeParams, completion);
    }

    public void resetLike(String resultId) {
        for (NRQueryResult result : ((NRFAQGroupItem)this.mFaqData.getGroups().get(0)).getAnswers()) {
            if (!result.getId().equals(resultId)) continue;
            result.setLikeState(NRQueryResult.LikeState.notSelected);
        }
    }

    public void faqAnswer(String answerId, Integer answerHash, final OnFAQAnswerFetched answerFetcher) {
        Nanorep.getInstance().fetchFAQAnswer(answerId, answerHash, new Nanorep.OnFAQAnswerFetchedListener(){

            public void onFAQAnswerFetched(NRFAQAnswer faqAnswer, NRError error) {
                if (error == null) {
                    answerFetcher.onAnswerFetched((NRQueryResult)faqAnswer);
                } else {
                    answerFetcher.onAnswerFetched(null);
                }
            }
        });
    }

    private void onRequestError(NRError error) {
    }

    public void clearUserSelectedContext() {
        this.userSelectedContext = null;
    }

    public void fetchLabelFAQ(NRLabel label) {
        NRConnection.Listener listener = new NRConnection.Listener(){

            public void response(Object responseParam, int status, NRError error) {
                ArrayList<NRFAQGroupItem> groups = new ArrayList<NRFAQGroupItem>();
                if (responseParam instanceof HashMap) {
                    HashMap map = (HashMap)responseParam;
                    NRFAQGroupItem group = new NRFAQGroupItem(map);
                    groups.add(group);
                    NRFetchedDataManager.this.mconfigFetcherListener.insertRows(groups);
                }
            }

            public void log(String tag, String msg) {
            }
        };
        Nanorep.getInstance().updateFaqList(Integer.toHexString(label.getId()), label.getContext(), false, listener);
    }

    private boolean duplicateFAQ(NRQueryResult nrQueryResult, ArrayList<NRQueryResult> answers) {
        for (NRQueryResult answer : answers) {
            if (!answer.getId().equals(nrQueryResult.getId())) continue;
            return true;
        }
        return false;
    }
}

