/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.animation.ValueAnimator;
import android.view.View;
import android.widget.LinearLayout;
import com.nanorep.nanoclient.Response.NRConfiguration;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.DataClasse.NRResult;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.NRResultItemListener;
import nanorep.nanowidget.interfaces.NRTitleListener;

public class NRTitleItem
extends NRResultItem
implements NRTitleListener {
    private View mItemView;
    private NRCustomTitleView titleView;
    private LinearLayout title_container;

    @Override
    protected void bindViews(View view) {
        this.mItemView = view;
    }

    public NRTitleItem(View view, NRCustomTitleView titleView, NRResultItemListener listener) {
        super(view, listener);
        this.titleView = titleView;
        this.titleView.setListener(this);
        this.title_container = (LinearLayout)view.findViewById(R.id.title_container);
    }

    @Override
    protected void setListener(NRResultItemListener listener) {
        super.setListener(listener);
    }

    @Override
    public void resetBody() {
    }

    @Override
    protected void configViewObjects(NRConfiguration config) {
    }

    @Override
    public void setData(NRResult result) {
        this.mResult = result;
        if (result.getFetchedResult() != null) {
            this.titleView.setTitleText(result.getFetchedResult().getTitle());
        }
        int height = result.getHeight();
        this.setHeight(height);
    }

    private void setHeight(int height) {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.mItemView.getHeight(), height});
        animator.setDuration(300L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ((NRTitleItem)NRTitleItem.this).titleView.getLayoutParams().height = (Integer)animation.getAnimatedValue();
                ((NRTitleItem)NRTitleItem.this).mItemView.getLayoutParams().height = (Integer)animation.getAnimatedValue();
                NRTitleItem.this.mItemView.requestLayout();
            }
        });
        animator.start();
    }

    public LinearLayout getTitle_container() {
        return this.title_container;
    }

    @Override
    public void onTitleClicked() {
        if (!this.mResult.isSingle()) {
            this.mListener.unfoldItem(this.mResult, false);
        }
    }

    @Override
    public void onTitleCollapsed(int height) {
    }

    @Override
    public void onShareClicked() {
        this.mListener.onShareClicked(this, this.mResult.getFetchedResult().getTitle());
    }

    public NRCustomTitleView getTitleView() {
        return this.titleView;
    }
}

