/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.NRSearchBarListener;

public class NRSearchBar
extends NRCustomSearchBarView
implements View.OnClickListener,
TextWatcher,
TextView.OnEditorActionListener {
    private NRSearchBarListener mListener;
    private ImageButton mSpeechButton;
    private EditText mSearchEditText;
    private LinearLayout searchBarLayout;

    public NRSearchBar(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.search_bar, (ViewGroup)this);
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.searchBarLayout = (LinearLayout)child.findViewById(R.id.searchBarLayout);
        this.mSearchEditText = (EditText)child.findViewById(R.id.searchText);
        this.mSearchEditText.addTextChangedListener((TextWatcher)this);
        this.mSearchEditText.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mSpeechButton = (ImageButton)child.findViewById(R.id.speechButton);
        this.mSpeechButton.setOnClickListener((View.OnClickListener)this);
        this.mSearchEditText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 0 && keyCode == 4) {
                    NRSearchBar.this.clear();
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public void setListener(NRSearchBarListener listener) {
        this.mListener = listener;
    }

    private int resId(String resName) {
        return this.getResources().getIdentifier(resName, "drawable", this.getContext().getPackageName());
    }

    @Override
    public void dismissKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.mSearchEditText.getWindowToken(), 0);
    }

    @Override
    public void updateText(String text) {
        this.mSearchEditText.clearFocus();
        this.mSearchEditText.setText((CharSequence)text);
    }

    @Override
    public void setHint(String text) {
        this.mSearchEditText.setHint((CharSequence)text);
    }

    @Override
    public void updateEditTextView(String text) {
        this.mSearchEditText.removeTextChangedListener((TextWatcher)this);
        this.mSpeechButton.setVisibility(text.length() > 0 ? 0 : 4);
        this.updateText(text);
        this.mSearchEditText.addTextChangedListener((TextWatcher)this);
    }

    @Override
    public String getText() {
        return this.mSearchEditText.getText().toString();
    }

    public void onClick(View v) {
        if (((Boolean)v.getTag()).booleanValue()) {
            this.clear();
        }
    }

    private void clear() {
        this.mSearchEditText.clearFocus();
        this.dismissKeyboard();
        this.mListener.onClearClicked(true);
        this.updateEditTextView("");
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        this.mSpeechButton.setVisibility(charSequence.length() > 0 ? 0 : 4);
        this.mSpeechButton.setImageResource(this.resId(charSequence.length() > 0 ? "searchbar_x_icon" : "searchbar_mic_icon"));
        Boolean state = charSequence.length() > 0;
        this.mSpeechButton.setTag((Object)state);
        if (charSequence.length() == 0) {
            this.dismissKeyboard();
            this.mListener.onClearClicked(true);
        }
    }

    public void afterTextChanged(Editable editable) {
        if (editable != null && editable.length() > 0) {
            this.mListener.fetchSuggestionsForText(this.mSearchEditText.getText().toString());
        } else {
            this.mListener.onEmptyQuery();
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == 3) {
            this.mListener.searchForText(this.mSearchEditText.getText().toString());
            this.dismissKeyboard();
            return true;
        }
        return false;
    }

    public void setBackgroundColor(int color2) {
        super.setBackgroundColor(color2);
        this.searchBarLayout.setBackgroundColor(color2);
    }
}

