/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import java.util.ArrayList;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.DislikeDialog;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRLikeView;
import nanorep.nanowidget.Components.NRLinkedArticlesBrowserView;
import nanorep.nanowidget.Components.NRResultTitleView;
import nanorep.nanowidget.Fragments.NRWebContentFragment;
import nanorep.nanowidget.R;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRResultView;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;
import nanorep.nanowidget.interfaces.OnLikeListener;
import nanorep.nanowidget.interfaces.OnLinkedArticle;

public class NRLinkedArticleFragment
extends Fragment
implements NRContentView.Listener,
OnFAQAnswerFetched,
NRChannelItem.OnChannelSelectedListener,
Nanorep.OnLikeSentListener,
NRResultView,
OnLikeListener {
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";
    private String mParam1;
    private String mParam2;
    private OnLinkedArticle mListener;
    private NRResultTitleView mTitleView;
    private NRContentView mWebView;
    private NRLinkedArticlesBrowserView mBrowserView;
    private ArrayList<NRQueryResult> mLinkedArticles = new ArrayList();
    private int mIndex;
    private LinearLayout mFeedbackView;
    private NRChannelingView mChannelingView;
    private NRLikeView mLikeView;
    private Button mBackButton;
    private OnDismissListener mDismissListener;
    private NRQueryResult mResult;

    public void onLikeSent(boolean success) {
    }

    public static NRLinkedArticleFragment newInstance(String param1, String param2) {
        NRLinkedArticleFragment fragment = new NRLinkedArticleFragment();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    public void setQueryResult(NRQueryResult queryResult) {
        this.mIndex = 0;
        this.mLinkedArticles.add(queryResult);
    }

    public void setDismissListener(OnDismissListener listener) {
        this.mDismissListener = listener;
    }

    public void setListener(OnLinkedArticle listener) {
        this.mListener = listener;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mParam1 = this.getArguments().getString(ARG_PARAM1);
            this.mParam2 = this.getArguments().getString(ARG_PARAM2);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_nrlinked_article, container, false);
        this.mTitleView = (NRResultTitleView)view.findViewById(R.id.linkedArtTitle);
        this.mBackButton = (Button)view.findViewById(R.id.backButton);
        this.mBackButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                NRLinkedArticleFragment.this.mDismissListener.onBackClicked();
            }
        });
        this.mWebView = (NRContentView)view.findViewById(R.id.linkedArtWebView);
        this.mWebView.setListener(this);
        this.mFeedbackView = (LinearLayout)view.findViewById(R.id.linkedArtFeedback);
        this.mLikeView = (NRLikeView)view.findViewById(R.id.linkedArtLikeView);
        this.mLikeView.setListener(this);
        this.mBrowserView = (NRLinkedArticlesBrowserView)view.findViewById(R.id.linkedArtBrowser);
        this.mBrowserView.setListener(new NRLinkedArticlesBrowserView.Listener(){

            @Override
            public void onNextClicked() {
                if (NRLinkedArticleFragment.this.mLinkedArticles.size() > 1) {
                    NRLinkedArticleFragment.this.mIndex++;
                    NRLinkedArticleFragment.this.updateArticle((NRQueryResult)NRLinkedArticleFragment.this.mLinkedArticles.get(NRLinkedArticleFragment.this.mIndex));
                }
            }

            @Override
            public void onPrevClicked() {
                if (NRLinkedArticleFragment.this.mLinkedArticles.size() > 1) {
                    NRLinkedArticleFragment.this.mIndex--;
                    NRLinkedArticleFragment.this.updateArticle((NRQueryResult)NRLinkedArticleFragment.this.mLinkedArticles.get(NRLinkedArticleFragment.this.mIndex));
                }
            }
        });
        this.updateArticle(this.mLinkedArticles.get(0));
        if (this.mFeedbackView != null) {
            RelativeLayout.LayoutParams params = null;
            if (this.mResult.getChanneling() == null) {
                params = (RelativeLayout.LayoutParams)this.mFeedbackView.getLayoutParams();
                params.height = (int)Calculate.pxFromDp(this.getContext(), 50.0f);
            } else {
                this.mChannelingView = (NRChannelingView)view.findViewById(R.id.linkedArtChanneling);
                if (this.mChannelingView != null) {
                    this.mChannelingView.setListener(this);
                    ArrayList channelings = this.mResult.getChanneling();
                    for (NRChanneling channeling : channelings) {
                        channeling.setQueryResult(this.mResult);
                    }
                    this.mChannelingView.setChannelings(channelings);
                    params = (RelativeLayout.LayoutParams)this.mFeedbackView.getLayoutParams();
                    params.height = (int)Calculate.pxFromDp(this.getContext(), 100.0f);
                }
            }
            this.mFeedbackView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        return view;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
    }

    public void onDetach() {
        super.onDetach();
    }

    private void updateArticle(NRQueryResult result) {
        this.mResult = result;
        this.mTitleView.setTitle(result.getTitle());
        this.mWebView.loadData(result.getBody(), "html/text", "UTF-8");
        if (this.mLinkedArticles.size() > 1) {
            if (this.mIndex < this.mLinkedArticles.size() - 1 && this.mIndex > 0) {
                this.mBrowserView.setState(NRLinkedArticlesBrowserView.State.hasNextAndPrev);
            } else if (this.mIndex == 0) {
                this.mBrowserView.setState(NRLinkedArticlesBrowserView.State.hasNext);
            } else if (this.mIndex == this.mLinkedArticles.size() - 1) {
                this.mBrowserView.setState(NRLinkedArticlesBrowserView.State.hasPrev);
            }
        }
        if (result.getLikeState() == NRQueryResult.LikeState.notSelected) {
            this.mLikeView.resetLikeView();
        } else {
            this.mLikeView.updateLikeButton(result.getLikeState() == NRQueryResult.LikeState.positive);
        }
    }

    @Override
    public void onAnswerFetched(NRQueryResult result) {
        if (result != null) {
            ++this.mIndex;
            this.mLinkedArticles.add(this.mIndex, result);
            this.updateArticle(result);
        }
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
        this.mListener.onLinkedArticleClicked(this, articleId);
    }

    @Override
    public void onLinkClicked(String url) {
        NRWebContentFragment webContentFragment = NRWebContentFragment.newInstance(url, null);
        webContentFragment.setListener(new NRWebContentFragment.Listener(){

            @Override
            public void onDismiss() {
                NRLinkedArticleFragment.this.getChildFragmentManager().popBackStack();
            }
        });
        this.getChildFragmentManager().beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(R.id.webContentHolder, (Fragment)webContentFragment).addToBackStack("linked").commit();
    }

    @Override
    public void onDismiss() {
    }

    @Override
    public void onChannelSelected(NRChanneling channeling) {
    }

    @Override
    public void onLikeClicked(NRCustomLikeView likeView, String resultId, boolean isLike) {
        if (this.mLikeView.getLikeSelection()) {
            this.mLinkedArticles.get(this.mIndex).setLikeState(NRQueryResult.LikeState.positive);
            this.mListener.onLikeSelected(this, NRLikeType.POSITIVE, this.mLinkedArticles.get(this.mIndex));
        } else {
            String[] reasons = new String[]{this.getString(R.string.missing_information), this.getString(R.string.didnt_find)};
            View dislikeView = this.getActivity().getLayoutInflater().inflate(R.layout.dislike_dialog, null);
            DislikeDialog dislikeAlert = new DislikeDialog(this.getContext(), dislikeView);
            dislikeAlert.setTitle("What's wrong with this answer");
            dislikeAlert.setListener(new DislikeDialog.Listener(){

                @Override
                public void onCancel() {
                    NRLinkedArticleFragment.this.mLikeView.resetLikeView();
                }

                @Override
                public void onDislike(NRLikeType type) {
                    ((NRQueryResult)NRLinkedArticleFragment.this.mLinkedArticles.get(NRLinkedArticleFragment.this.mIndex)).setLikeState(NRQueryResult.LikeState.negative);
                    NRLinkedArticleFragment.this.mListener.onLikeSelected(NRLinkedArticleFragment.this, type, (NRQueryResult)NRLinkedArticleFragment.this.mLinkedArticles.get(NRLinkedArticleFragment.this.mIndex));
                }
            });
            dislikeAlert.setDislikeOptions(reasons);
        }
    }

    @Override
    public void setLikeState(String resultId, boolean isPositive) {
        if (isPositive) {
            this.mLinkedArticles.get(this.mIndex).setLikeState(this.mLikeView.getLikeSelection() ? NRQueryResult.LikeState.positive : NRQueryResult.LikeState.negative);
        } else {
            this.mLinkedArticles.get(this.mIndex).setLikeState(NRQueryResult.LikeState.notSelected);
            this.mLikeView.resetLikeView();
        }
    }

    public static interface OnDismissListener {
        public void onBackClicked();
    }
}

